<?php

/**
 * SOTESHOP/stBasket
 *
 * Ten plik należy do aplikacji stBasket opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stBasket
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: components.class.php 15818 2011-10-27 11:10:12Z marcin $
 */

/**
 * Akcje komponentu basket
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>, Krzysztof Bebło <krzysztof.beblo@sote.pl>
 *
 * @package     stBasket
 * @subpackage  actions
 */
class stBasketComponents extends sfComponents
{

    protected static
    $productConfig = null,
    $basketConfig = null;

    public function initialize($context)
    {
        $ret = parent::initialize($context);

        if (null === self::$productConfig)
        {
            self::$basketConfig = stConfig::getInstance($context, 'stBasket');
        }

        if (null === self::$productConfig)
        {
            self::$productConfig = stConfig::getInstance($context, 'stProduct');
        }

        return $ret;
    }

    /**
     * Lista produktów w koszyku
     */
    public function executeShow()
    {
        if (self::$productConfig->get('hide_basket') != true)
        {
            $this->smarty = new stSmarty('stBasket');

            $this->basket = stBasket::getInstance($this->getUser());
        }
        else
        {
            return sfView::NONE;
        }
    }

    /**
     * Dodawanie do koszyka
     */
    public function executeAdd()
    {
        if (self::$productConfig->get('hide_basket') != true)
        {
            $this->basket_config = self::$basketConfig;

            $this->product_config = self::$productConfig;

            $this->smarty = new stSmarty('stBasket'); // basket - moduleName

            if (!isset($this->simple))
            {
                $this->simple = false;
            }

            if (!isset($this->info))
            {
                $this->info = false;
            }
            
            if ($this->product->getIsStockValidated())
            {
               $this->enabled = null === $this->product->getStock() || $this->product->getStock() >= $this->product->getMinQty();
            }
            else
            {
               $this->enabled = true;
            }
                        
            $this->show_basket = true;

            $this->getController()->getDispatcher()->notify(new sfEvent($this, 'basket.post_component_add'));
        }
        else
        {
            return sfView::NONE;
        }
    }

}