<?php

use_helper('stCurrency', 'Javascript', 'Validation', 'stProductImage', 'stBasket', 'stUrl', 'stProductOptions');

sfLoader::loadHelpers('stProduct', 'stProduct');

use_javascript('stPrice.js');

if ($sf_request->hasErrors() && $sf_request->hasParameter('option_list'))
{
   $hidden = input_hidden_tag('option_list', $sf_request->getParameter('option_list'));

   $hidden .= input_hidden_tag('product_id', $sf_request->getParameter('product_id'));

   $smarty->assign("form_start", form_tag('stBasket/index', 'id=st_basket-form class=st_form').$hidden);
}
else
{
   $smarty->assign("form_start", form_tag('stBasket/index', 'id=st_basket-form class=st_form'));
}

$results = array();

$smarty->assign('products', $basket->getItems());

foreach ($basket->getItems() as $index => $product)
{
   $results[$index]['id'] = $product->getItemId();

   $results[$index]['if_form_error'] = $sf_request->hasError('basket{products}{'.$product->getItemId().'}');

   $results[$index]['error_show'] = $sf_request->getError('basket{products}{'.$product->getItemId().'}');

   if ($product->productValidate())
   {
      $results[$index]['photo'] = st_link_to(st_product_image_tag($product, 'icon'), 'stProduct/show?url='.$product->getProduct()->getFriendlyUrl());
   }
   else
   {
      $results[$index]['photo'] = st_product_image_tag(null, 'icon');
   }

   if ($product->productValidate())
   {
      $results[$index]['name'] = st_link_to($product->getName(), 'stProduct/show?url='.$product->getProduct()->getFriendlyUrl());
   }
   else
   {
      $results[$index]['name'] = $product->getName();
   }

   if ($product->hasPriceModifiers())
   {
      $results[$index]['name'] = content_tag('div', $results[$index]['name'], array('class' => 'st_product_name_with_options')).st_product_options_get_view($product);
   }

   $results[$index]['price_netto'] = st_currency_format($product->getPriceNetto(true));

   $results[$index]['tax'] = $product->getVat();

   $results[$index]['price_brutto'] = st_currency_format($product->getPriceBrutto(true));

   $results[$index]['num_onmouseover'] = st_basket_js_num_buttons_show($product);

   $results[$index]['num_onmouseout'] = st_basket_js_num_buttons_hide($product);

   if ($sf_request->hasError('basket{products}{'.$product->getItemId().'}'))
   {
      if ($product->getProductStepQty())
      {
         $results[$index]['num'] = st_product_quantity_list('basket[products]['.$product->getItemId().']', $product->getProduct(), $sf_request->getParameter('basket[products]['.$product->getItemId().']'), array('class' => 'st_form-error'));
      }
      else
      {
         $results[$index]['num'] = input_tag('basket[products]['.$product->getItemId().']', $sf_request->getParameter('basket[products]['.$product->getItemId().']'), array(
             'class' => 'st_form-error', 
             'size' => 3, 
             'maxlength' => 11,
             'onchange' => 'this.value = stPrice.fixNumberFormat(this.value, '.$product->getProductStockInDecimals().');'
             ));
      }
   }
   else
   {
      if ($product->getProductStepQty())
      {
         $results[$index]['num'] = st_product_quantity_list('basket[products]['.$product->getItemId().']', $product->getProduct(), $product->getQuantity(), array('max' => $product->getMaxQuantity()));
      }
      else
      {
         $results[$index]['num'] = input_tag('basket[products]['.$product->getItemId().']', $product->getQuantity(), array(
             'size' => 3, 
             'maxlength' => 11,
             'onchange' => 'this.value = stPrice.fixNumberFormat(this.value, '.$product->getProductStockInDecimals().');'
             ));
      }
   }

   if (!$product->getProductStepQty())
   {
      if ($product->getQuantity() > $product->getProductMinQty() && !$sf_request->hasErrors())
      {
         $results[$index]['minus'] = link_to(st_theme_image_tag('minus.gif', array('alt' => '')), 'stBasket/setProduct?product_id='.$product->getItemId().'&quantity='.($product->getQuantity() - 1));
      }
      else
      {
         $results[$index]['minus'] = st_theme_image_tag('minus.gif', array('alt' => ''));
      }

      if (null === $product->getMaxQuantity() || $product->getQuantity() < $product->getMaxQuantity() && !$sf_request->hasErrors())
      {
         $results[$index]['plus'] = link_to(st_theme_image_tag('plus.gif', array('alt' => '')), 'stBasket/setProduct?product_id='.$product->getItemId().'&quantity='.($product->getQuantity() + 1));
      }
      else
      {
         $results[$index]['plus'] = st_theme_image_tag('plus.gif', array('alt' => ''));
      }
   }
   
   $results[$index]['uom'] = st_product_uom($product->getProduct());

   $results[$index]['total_amount'] = st_currency_format($product->getTotalAmount(true, true), array('with_exchange' => false));

   $results[$index]['delete'] = link_to(st_theme_image_tag('delete.gif', array('alt' => '')), 'stBasket/remove?product_id='.$product->getItemId());
}

$smarty->assign("button_update", submit_tag(__('Uaktualnij koszyk')));

$clear_url = st_url_for('stBasket/clear');

$smarty->assign("button_clear", link_to(__("Opróżnij koszyk"), $clear_url, array('onclick' => "javascript: return window.confirm('".__('Czy na pewno opróżnić koszyk?')."')")));

//default2
$smarty->assign('clear_url', $clear_url);

$smarty->assign("return_url", $referer);

$smarty->assign('results', $results);




$smarty->display('basket_products_list.html');