<?php
use_helper('stBasket', 'stUrl', 'stCurrency');

st_theme_use_stylesheet('stBasket.css'); 

$basket_items = $basket->getSessionItems();

$i=0;
foreach($basket_items as $basket_item)
{   
   $url_for = $basket_item->productValidate() ? st_url_for('stProduct/show?url='.$basket_item->getProduct()->getFriendlyUrl()) : null;
   
   $basket_array[$i]['name'] =  $url_for ? content_tag('a', $basket_item->getName(), array('href' => $url_for)) : $basket_item->getName();
   $basket_array[$i]['price'] = st_currency_format($basket_item->getPriceBrutto(true, true), array('with_exchange' => false));
   $basket_array[$i]['quantity'] = $basket_item->getQuantity();
   $basket_array[$i]['image'] = $url_for ? content_tag('a', st_product_image_tag($basket_item, 'icon'), array('href' => $url_for)) : st_product_image_tag($basket_item, 'icon');

   $i++;
}

$smarty->assign('basket_array', $basket_array);

$smarty->fc_assign("basket_amount", st_basket_total_amount($basket, true));

$smarty->fc_assign("basket_icon", st_secure_link_to(st_basket_total_amount($basket, true), 'stBasket/index' . ($sf_context->getModuleName() == 'stBasket' ? '' : 'Referer')));

$smarty->fc_assign("amount_icon", st_secure_link_to(st_theme_image_tag('basket/basket_selected.png'), 'stBasket/index' . ($sf_context->getModuleName() == 'stBasket' ? '' : 'Referer'), 'class=st_basket-list-link'));

$smarty->display("basket_show.html");

?>

<script type="text/javascript" language="javascript">
    jQuery(function ($) {
         $(document).ready(function () {
            $(".st_basket-list-link").tooltip({ 
               effect: 'slide',
               opacity: 1,
               position: 'bottom left',
               offset: [10,92]

            });
        });
    });

</script>