<?php

class stFastCacheFrontendComponents extends sfComponents
{
    public function executeCache()
    {
    	if ($this->getUser()->hasAttribute('fastcache') && $this->getUser()->getAttribute('fastcache')==0) return sfView::NONE;
    	
    	$fastCacheEnabled = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'fast_cache_enabled';
    	$config = stConfig::getInstance($this->getContext(), 'stFastCache');
    	
    	if ($config->isEmpty() || (double)$config->get('fast_cache_priority')<floatval(microtime())) return sfView::NONE;
        $cacheManager = sfContext::getInstance()->getViewCacheManager();
        if (file_exists($fastCacheEnabled) && !$this->hasRequestParameter('hash') && is_object($cacheManager))
        {
            
            $uri = sfRouting::getInstance()->getCurrentInternalUri();
            $cache_vary = $cacheManager->getVary($uri);
            $request = sfContext::getInstance()->getRequest();
            $lang = $this->getUser()->getCulture();
            
            if (!$this->hasRequestParameter('default') && !file_exists(sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'default'.DIRECTORY_SEPARATOR.$lang.DIRECTORY_SEPARATOR.'fast_cache_generate_default'))
            {
                $pathInfo = 'stFastCacheFrontend/default';
                $this->url = '/index.php'.url_for('stFastCacheFrontend/writeCache').'?host='.$request->getHost().'&code='.md5($pathInfo).'&culture='.$lang.'&is_default=1&path_info='.$pathInfo;
                return sfView::SUCCESS;
            }
            
            // if open licence display only wen main module
            if (stLicense::isOpen() && $this->getModuleName()!= 'stFrontendMain' && $this->getActionName() != 'index' ) return sfView::NONE;
            
            if (isset($cache_vary['fastcache']) && !empty($cache_vary['fastcache']))
            {
                $pathInfo = url_for(sfRouting::getInstance()->getCurrentInternalUri(false));
                $this->url = '/index.php'.url_for('stFastCacheFrontend/writeCache').'?host='.$request->getHost().'&code='.md5($pathInfo).'&path_info='.$pathInfo;
                return sfView::SUCCESS;
            }
            return sfView::NONE;
        }
    }
}