<?php

/**
 * SOTESHOP/stOrder
 *
 * Ten plik należy do aplikacji stOrder opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stOrder
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: actions.class.php 16295 2011-11-29 15:33:47Z bartek $
 */

/**
 * Akcje aplikacji stOrder
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>
 *
 * @package     stOrder
 * @subpackage  actions
 */
class stOrderActions extends stActions
{

   /**
    * Zwraca użytkownika
    *
    * @return   stUser
    */
   public function getUser()
   {
      return parent::getUser();
   }

   /**
    * Zwraca obiekt obsługi zdarzeń
    *
    * @return   stEventDispatcher
    */
   public function getDispatcher()
   {
      return stEventDispatcher::getInstance();
   }

   /**
    * Wyświetla listę zamówien klienta
    */
   public function executeList()
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $this->forwardif($this->getUser()->isAnonymous(), 'stUser', 'loginUser');

      $c = new Criteria();

      $c->addDescendingOrderByColumn(OrderPeer::CREATED_AT);

      $c->add(OrderPeer::SF_GUARD_USER_ID, $this->getUser()->getGuardUser()->getId());

      $this->pager = new sfPropelPager('Order', 20);

      $this->pager->setPeerMethod('doSelectJoinAll');

      $this->pager->setCriteria($c);

      $this->pager->setPage($this->getRequestParameter('page'));

      $this->pager->init();
   }

   /**
    * Wyświetla dane szczególowe zamówienia klienta
    */
   public function executeShow()
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $this->order = OrderPeer::retrieveByIdAndHashCode($this->getRequestParameter('id'), $this->getRequestParameter('hash_code'));

      $this->forward404Unless($this->order, 'Operacja niedozwolona - brak zamówienia o podanym numerze i ciągu hash');

      $this->user_data_billing = $this->order->getOrderUserDataBilling();

      $this->user_data_delivery = $this->order->getOrderUserDataDelivery();

      $this->currency = $this->order->getOrderCurrency();

      $this->delivery = $this->order->getOrderDelivery();

      if ($this->order->getOrderPayment()->getPaymentType())
      {
         $this->payment = $this->order->getOrderPayment()->getPaymentType();
      }

      $this->order_products = $this->order->getOrderProducts();

      if ($this->getRequestParameter('confirm'))
      {

         if ($this->getRequestParameter('cancel') == 1)
         {
            $this->order->setOrderStatusId(1);

            $this->order->save();

            $this->setFlash('notice', 'Zamówienie zostało anulowane.');

            $this->redirect('@stOrderShowForUser?id='.$this->order->getId().'&hash_code='.$this->order->getHashCode());
         }

         if (!$this->order->getIsConfirmed())
         {
            $this->order->setIsConfirmed(true);

            $this->order->save();

            $this->setFlash('notice', 'Twoje zamówienie zostało potwierdzone.');
         }
         else
         {
            $this->setFlash('notice', 'Twoje zamówienie zostało już wcześniej potwierdzone.');
         }

         if ($this->getRequestParameter('register') == 1)
         {
            stUser::setIsConfirm($this->order->getSfGuardUser()->getUsername());
            stUser::loginUserOnlyUsername($this->order->getSfGuardUser()->getUsername());

            $this->redirect('@stOrderShowForUser?id='.$this->order->getId().'&hash_code='.$this->order->getHashCode());
         }
         else
         {
            $this->redirect('@stOrderShowForUser?id='.$this->order->getId().'&hash_code='.$this->order->getHashCode());
         }
      }
   }

   /**
    * Akcja wyświetlająca strone potwierdzenia
    */
   public function executeConfirm()
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $this->setFlash('stCurrency-hide_list', true);

      $this->user_data_billing = $this->getRequestParameter('user_data_billing');

      $this->forward404Unless($this->user_data_billing, 'Operacja niedozwolona - brak danych bilingowych...');

      $this->different_delivery = $this->getRequestParameter('different_delivery', false);

      $this->create_account = $this->getRequestParameter('create_account', false);

      $this->password1 = $this->getRequestParameter('password1', false);

      $this->password2 = $this->getRequestParameter('password2', false);

      $this->description = $this->getRequestParameter('description');

      $this->delivery_date = $this->getRequestParameter('delivery[date]');

      $this->delivery_time = $this->getRequestParameter('delivery[time]');

      if ($this->different_delivery)
      {
         $this->user_data_delivery = $this->getRequestParameter('user_data_delivery');

         $this->forward404Unless($this->user_data_delivery, 'Operacja niedozwolona - brak danych dostawy...');
      }
      else
      {
         $this->user_data_delivery = $this->user_data_billing;
      }

      $this->basket = stBasket::getInstance($this->getUser());

      $this->forward404if($this->basket->isEmpty(), 'Operacja niedozwolona - pusty koszyk...');

      $this->currency = stCurrency::getInstance($this->getContext())->get();

      $this->forward404Unless($this->currency, 'Operacja niedozwolona - brak ustawionej waluty...');

      $this->delivery = stDeliveryFrontend::getInstance($this->basket);

      $this->forward404Unless($this->delivery->getDefaultDelivery(), 'Operacja niedozwolona - brak ustawionej dostawy...');

      $total_amount = $this->delivery->getTotalDeliveryCost(true, true) + $this->basket->getTotalAmount(true, true);

      $final_total_amount = $total_amount;

      $paid = 0;

      if (stGiftCardPlugin::isActive() && stGiftCardPlugin::calculateAmountLeft($total_amount) == 0)
      {
         $pt = new PaymentType();

         $pt->setName('Bony zakupowe');

         $this->paymentType = $pt;
      }
      else
      {
         $this->paymentType = $this->delivery->getDefaultDelivery()->getDefaultPayment()->getPaymentType();
      }

      if (stGiftCardPlugin::isActive())
      {
         $paid = stGiftCardPlugin::getTotalAmountPaid();

         $final_total_amount -= $paid;
      }

      $this->forward404Unless($this->paymentType, 'Operacja niedozwolona - brak ustawionej platnosci...');

      $this->total_amount = $total_amount;

      $this->paid = $paid;

      $this->final_total_amount = $final_total_amount >= 0 ? $final_total_amount : 0;
      
      $this->additional_confirm_text = TextPeer::retrieveBySystemName('stOrderConfirm');
   }

   public function validateSave()
   {
      $ok = true;
      
      $refresh_basket = false;
      
      $config = stConfig::getInstance('stProduct');

      if ($this->getRequest()->getMethod() == sfRequest::POST && $config->get('depository_basket'))
      {
         $i18n = $this->getContext()->getI18N();
         
         $request = $this->getRequest();
         
         $basket = stBasket::getInstance($this->getUser());
         
         foreach ($basket->getItems() as $item)
         {
            if (!$item->getProduct()->getIsStockValidated())
            {
               continue;
            }
            
            $ids = array();

            foreach ($item->getPriceModifiers() as $pm)
            {
               $ids[$pm['custom']['id']] = $pm['custom']['id'];
            }
            
            $stock = $item->getProduct()->getStock();

            if ($ids)
            {
               $options = ProductOptionsValuePeer::retrieveByPKs($ids);

               foreach ($options as $option)
               {
                  if (null !== $option->getStock() && $stock > $option->getStock())
                  {
                     $stock = $option->getStock();
                  }
               }
            }
            
            if (null !== $stock && $item->getQuantity() > $stock)
            {
               $request->setError('quantity_'.$item->getItemId(), $i18n->__('Brak wymaganej ilości towaru w magazynie'));
               
               $refresh_basket = true;
               
               $ok = false;
            }
         }
         
         if ($refresh_basket)
         {
            $basket->refresh();
            
            $basket->save();
         }
      }

      return $ok;
   }
   
   public function handleErrorSave()
   {      
      return $this->forward($this->getModuleName(), 'confirm');
   }

   /**
    * Akcja zapisujacą dane zamówienie
    */
   public function executeSave()
   {
      $basket = stBasket::getInstance($this->getUser());

      $this->forward404if($basket->isEmpty(), 'Operacja niedozwolona - pusty koszyk...');

      $currency = stCurrency::getInstance($this->getContext())->get();

      $this->forward404Unless($currency, 'Operacja niedozwolona - brak ustawionej waluty...');

      $delivery = stDeliveryFrontend::getInstance($basket);

      $this->forward404Unless($delivery->hasDefaultDelivery(), 'Operacja niedozwolona - brak ustawionej dostawy...');

      $this->order = new Order();

      $this->order->setClientCulture($this->getUser()->getCulture());

      $this->order->setHost(sfContext::getInstance()->getRequest()->getHost());

      $this->order->setOrderStatus(OrderStatusPeer::retrieveDefaultPendingStatus());

      $this->updateCouponCode($basket);

      $ret = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'stOrderActions.preProcessOrderUserData', array('order' => $this->order)));

      if (!$ret->isProcessed())
      {
         $this->processOrderUserData();
      }

      $this->mirrorOrderCurrency($currency);

      $this->mirrorOrderProduct($basket->getItems());

      $this->mirrorOrderDelivery($delivery, $basket->getTotalAmount(true), $basket->getItems());

      if ($this->getRequest()->hasParameter('description'))
      {
         $this->description = $this->getRequestParameter('description');
         $this->order->setDescription($this->description);
      }

      $this->getDispatcher()->filter(new sfEvent($this, 'stOrderActions.filterOrderSave', array('order' => $this->order)), $this->order);

      // w przypadku gdy użytkownik ma pełne konto i jest zalogowany ustaw potwierdzenie na 1
      if ($this->getUser()->isAuthenticated() && stUser::isFullAccount($this->getUser()->getUsername()))
      {
         $this->order->setIsConfirmed(1);
      }

      $this->order->save();

      $this->generateOrderNumber();

      $basket->clear();

      $this->processGiftCard();

      $this->postExecute();

      OrderPeer::updateOptIsPaid($this->order);

      $this->sendMail();

      return $this->redirect('@stOrderSummary?id='.$this->order->getId().'&hash_code='.$this->order->getHashCode());
   }

   /**
    * Akcja wyświetlająca ostatni etap zamówienia
    */
   public function executeSummary()
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $id = $this->getRequestParameter('id');

      $hash_code = $this->getRequestParameter('hash_code');

      $this->order = OrderPeer::retrieveByIdAndHashCode($id, $hash_code);

      $this->forward404Unless($this->order, 'Operacja niedozwolona - zamówienie o podanym id i ciągu hash nie istnieje...');

      $config = stConfig::getInstance(sfContext::getInstance(), array(
                  'company' => stConfig::STRING,
                  'nip' => stConfig::STRING,
                  'street' => stConfig::STRING,
                  'house' => stConfig::STRING,
                  'flat' => stConfig::STRING,
                  'code' => stConfig::STRING,
                  'town' => stConfig::STRING,
                  'phone' => stConfig::STRING,
                  'fax' => stConfig::STRING,
                  'bank' => stConfig::STRING,
                  'email' => stConfig::STRING
                      )
                      , 'stShopInfoBackend');

      $config->load();

      $this->company = $config->get('company');
      $this->nip = $config->get('nip');
      $this->street = $config->get('street');
      $this->house = $config->get('house');
      $this->flat = $config->get('flat');
      $this->code = $config->get('code');
      $this->town = $config->get('town');
      $this->phone = $config->get('phone');
      $this->fax = $config->get('fax');
      $this->bank = $config->get('bank');
      $this->email = $config->get('email');

      if (class_exists('TextPeer'))
         $this->order_summary_text = TextPeer::retrieveBySystemName('stOrderSummary');

      $this->setFlash('stCurrency-hide_list', true);

      $this->total_amount = stPayment::getUnpayedAmountByOrder($this->order);
   }

   /**
    * Tworzenie kopii aktualnej waluty
    *
    * @param   Currency    $currency           Aktualnie wybrana waluta w sklepie
    */
   protected function mirrorOrderCurrency($currency)
   {
      $order_currency = $this->order->getOrderCurrency();

      $currency = $this->getDispatcher()->filter(new sfEvent($this, 'stOrderActions.filterMirrorOrderCurrency', array('currency' => $currency)), $currency)->getReturnValue();

      $order_currency->setName($currency->getName());

      $order_currency->setExchange($currency->getExchange());

      $order_currency->setFrontSymbol($currency->getFrontSymbol());

      $order_currency->setBackSymbol($currency->getBackSymbol());

      $order_currency->setShortcut($currency->getShortcut());
   }

   /**
    * Tworzenie kopii danych dostawy użytkownika
    *
    * @param      UserData    $user_data_delivery
    */
   protected function mirrorOrderUserDataDelivery($user_data_delivery)
   {
      $order_delivery = $this->order->getOrderUserDataDelivery();

      $user_data_delivery = $this->getDispatcher()->filter(new sfEvent($this, 'stOrderActions.filterMirrorOrderUserDataDelivery', array('user_data_delivery' => $user_data_delivery)), $user_data_delivery)->getReturnValue();

      $this->mirrorUserData($user_data_delivery, $order_delivery);
   }

   /**
    * Tworzenie kopii danych bilingowych użytkownika
    *
    * @param      UserData    $user_data_billing
    */
   protected function mirrorOrderUserDataBilling($user_data_billing)
   {
      $order_billing = $this->order->getOrderUserDataBilling();

      $user_data_billing = $this->getDispatcher()->filter(new sfEvent($this, 'stOrderActions.filterMirrorOrderUserDataBilling', array('user_data_billing' => $user_data_billing)), $user_data_billing)->getReturnValue();

      $this->mirrorUserData($user_data_billing, $order_billing);
   }

   /**
    * Tworzenie kopii danych użytkownika z $source do $target
    *
    * @param   UserData    $source             Dane źródłowe
    * @param   UserDate    $target              Dane docelowe
    */
   protected function mirrorUserData($source, $target)
   {
      $target->setCountries($source->getCountries());

      $target->setFullName($source->getFullName());

      $target->setAddress($source->getAddress());

      $target->setAddressMore($source->getAddressMore());

      $target->setRegion($source->getRegion());

      $target->setCode($source->getCode());

      $target->setTown($source->getTown());

      $target->setPhone($source->getPhone());

      $target->setCompany($source->getCompany());

      $target->setVatNumber($source->getVatNumber());
   }

   /**
    * Tworzenie kopii produktów koszyka
    *
    * @param         array       $basket_products
    */
   protected function mirrorOrderProduct($basket_products)
   {
      foreach ($basket_products as $basket_product)
      {
         $order_product = new OrderProduct();

         $order_product->setProductId($basket_product->getProductId());

         $order_product->setQuantity($basket_product->getQuantity());

         $order_product->setCode($basket_product->getCode());

         $order_product->setName($basket_product->getName());

         $order_product->setBasePriceNetto($basket_product->getBasePriceNetto());

         $order_product->setBasePriceBrutto($basket_product->getBasePriceBrutto());

         $order_product->setImage($basket_product->getImage());

         $order_product->setPriceModifiers($basket_product->getPriceModifiers());

         $order_product->setDiscount($basket_product->getDiscount());

         $order_product->setWholesale($basket_product->getWholesale());

         $order_product->setCurrency($basket_product->getCurrency());

         $order_product->setTax($basket_product->getProduct()->getTax());

         $order_product = $this->getDispatcher()->filter(new sfEvent($this, 'stOrderActions.filterMirrorOrderProduct', array('order_product' => $order_product, 'basket_product' => $basket_product)), $order_product)->getReturnValue();

         $this->order->addOrderProduct($order_product);
      }
   }

   /**
    * Tworzenie kopii dostawy
    *
    * @param      stDeliveryFrontend    $delivery
    */
   protected function mirrorOrderDelivery($delivery)
   {
      $default_delivery = $delivery->getDefaultDelivery();

      $default_payment = $default_delivery->getDefaultPayment();

      $order_delivery = $this->order->getOrderDelivery();

      $order_delivery->setName($default_delivery->getName());

      $order_delivery->setCostNetto($default_delivery->getTotalCost());

      $order_delivery->setCostBrutto($default_delivery->getTotalCost(true));

      $order_delivery->setPaymentCostNetto($default_payment->getCost());

      $order_delivery->setPaymentCostBrutto($default_payment->getCost(true));

      $order_delivery->setOptTax($default_delivery->getTax()->getVat());

      $order_delivery->setDeliveryId($default_delivery->getDelivery()->getId());

      $order_delivery->setTaxId($default_delivery->getTax()->getId());


      if ($this->getRequestParameter('delivery[date]') != "")
      {
         $delivery_date = $this->getRequestParameter('delivery[date]');
      }
      else
      {
         $delivery_date = '00-00-00';
      }

      if ($this->getRequestParameter('delivery[time]') != "")
      {
         $delivery_time = $this->getRequestParameter('delivery[time]');
      }
      else
      {
         $delivery_time = '00:00:00';
      }

      if ($this->getRequestParameter('delivery[date]') != "" || $this->getRequestParameter('delivery[time]') != "")
      {
         $date_delivery = explode("-", $delivery_date);
         $order_delivery->setDeliveryDate($date_delivery[2]."-".$date_delivery[1]."-".$date_delivery[0]." ".$delivery_time);
      }
   }

   protected function processGiftCard()
   {
      foreach (stGiftCardPlugin::get() as $gift_card)
      {
         if ($gift_card->getStatus() != 'A')
         {
            continue;
         }

         $gift_card->setStatus('P');

         $payment = new Payment();

         $payment->setAmount($gift_card->getAmount());

         $payment->setStatus(true);

         $payment->setGiftCard($gift_card);

         $payment->save();

         $pho = new OrderHasPayment();

         $pho->setPaymentId($payment->getId());

         $pho->setOrderId($this->order->getId());

         $pho->save();
      }

      stGiftCardPlugin::clear();
   }

   /**
    * Metoda pomocnicza wykonująca wszystkie potrzebne operacje związane z danymi użytkownika
    */
   protected function processOrderUserData()
   {
      $user_data_delivery = $this->getRequestParameter('user_data_delivery');

      $this->forward404Unless($user_data_delivery, 'Operacja niedozwolona - brak danych dostawy...');

      $user_data_billing = $this->getRequestParameter('user_data_billing');

      $password = $this->getRequestParameter('password1');

      $this->forward404Unless($user_data_billing, 'Operacja niedozwolona - brak danych bilingowych...');

      $different_delivery = $this->getRequestParameter('different_delivery', false);

      $create_account = $this->getRequestParameter('create_account', false);

      $this->create_account = $create_account;

      $this->password = $password;

      // nie zalogowany
      if ($this->getUser()->isAnonymous())
      {
         $username = $user_data_billing['email'];

         $c = new Criteria();
         $c->add(sfGuardUserPeer::USERNAME, $username);
         $user = sfGuardUserPeer::doSelectOne($c);

         // brak użytkownika
         if (!$user)
         {

            if ($create_account == 1)
            {
               $user = stUser::addUser($username, $password);

               $this->getUser()->setGuardUser($user);

               $user_id = $user->getId();
            }
            else
            {
               $user = stUser::addUser($username);

               stUser::loginUserOnlyUsername($username);

               $user_id = $this->getUser()->getGuardUser()->getId();
            }

            $obj_billing = stUser::updateUserData(null, $user_id, 1, 1, $user_data_billing);

            $obj_delivery = stUser::updateUserData(null, $user_id, 0, 1, $different_delivery ? $user_data_delivery : $user_data_billing);
         }
         else
         {

            if ($user->getIsConfirm() == 0 && $create_account == 1)
            {
               $user->setPassword($password);

               $user->save();

               $this->getUser()->setGuardUser($user);

               $user_id = $user->getId();
            }
            else
            {
               $this->getUser()->setGuardUser($user);

               $user_id = $user->getId();
            }

            $obj_billing = stUser::updateUserData(null, $user_id, 1, 1, $user_data_billing);

            $obj_delivery = stUser::updateUserData(null, $user_id, 0, 1, $different_delivery ? $user_data_delivery : $user_data_billing);
         }
      }
      else
      {

         $user_id = $this->getUser()->getGuardUser()->getId();

         $user_data_billing_default = $this->getUser()->getUserDataDefaultBilling();
         $user_data_delivery_default = $this->getUser()->getUserDataDefaultDelivery();

         if ($user_data_billing_default && $this->getUser()->thisSameUserData($user_data_billing, $user_data_billing_default))
         {
            $obj_billing = $user_data_billing_default;
         }
         else
         {
            $obj_billing = stUser::updateUserData(null, $user_id, 1, 1, $user_data_billing);
         }

         if ($user_data_delivery_default && $this->getUser()->thisSameUserData($user_data_delivery, $user_data_delivery_default))
         {
            $obj_delivery = $different_delivery ? $user_data_delivery_default : $user_data_billing_default;
         }
         else
         {
            $obj_delivery = stUser::updateUserData(null, $user_id, 0, 1, $different_delivery ? $user_data_delivery : $user_data_billing);
         }
      }

      $this->mirrorOrderUserDataBilling($obj_billing);

      $this->mirrorOrderUserDataDelivery($obj_delivery);

      $this->order->setGuardUser($this->getUser()->getGuardUser());
   }

   protected function updateCouponCode($basket)
   {
      $coupon_code = $basket->getCouponCode();

      if ($coupon_code && $coupon_code->validateUsage())
      {
         $this->order->setDiscountCouponCode($coupon_code);

         $coupon_code->incrementUsage();

         $coupon_code->save();
      }
      elseif ($coupon_code)
      {
         $basket->refreshItems();
      }
   }

   /**
    * Generuje numer dla zamówienia
    */
   protected function generateOrderNumber()
   {
      $dateFormat = new sfDateFormat();

      $config = stConfig::getInstance($this->getContext(), 'stOrder');

      $format = $config->get('number_format');

      $id = $this->order->getId();

      $date = $dateFormat->getDate($this->order->getCreatedAt(), 'd');

      $number = str_replace(array('{NUMER}', '{DZIEN}', '{MIESIAC}', '{ROK}'), array($id, $date['mday'], $date['mon'], $date['year']), $format);

      $this->order->setNumber($number);

      $this->order->save();
   }

   /**
    * Wysyła mail z zamówieniem do klienta
    */
   function mailWithOrderToUser()
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $mailHtmlHead = stMailer::getHtmlMailDescription("header");

      $mailHtmlFoot = stMailer::getHtmlMailDescription("footer");

      $mailHtmlHeadContent = stMailer::getHtmlMailDescription("top_order_confirm");

      $mailHtmlFootContent = stMailer::getHtmlMailDescription("bottom_order_confirm");

      $sendOrderToUserHtmlMailMessage = stMailTemplate::render('sendOrderToUserHtml', array('order' => $this->order, 'head' => $mailHtmlHead, 'foot' => $mailHtmlFoot, 'head_content' => $mailHtmlHeadContent, 'foot_content' => $mailHtmlFootContent, 'password' => $this->password, 'create_account' => $this->create_account, 'smarty' => $this->smarty));

      $sendOrderToUserPlainMailMessage = stMailTemplate::render('sendOrderToUserPlain', array('order' => $this->order, 'smarty' => $this->smarty));

      $mail = stMailer::getInstance();
      return $mail->setSubject($this->getRequest()->getHost().' - '.__('zamówienie numer').': '.$this->order->getNumber())->setHtmlMessage($sendOrderToUserHtmlMailMessage)->setPlainMessage($sendOrderToUserPlainMailMessage)->setTo($this->order->getSfGuardUser()->getUsername())->sendToClient();
   }

   /**
    * Wysyła mail z zamówieniem do administratora
    */
   function mailWithOrderToAdmin()
   {
      $user = $this->getUser();

      $culture = $user->getCulture();

      $this->order = OrderPeer::retrieveByPK($this->order->getId()); // reload order culture hack

      $c = new Criteria();
      $c->add(LanguagePeer::IS_DEFAULT_PANEL, 1);
      $language = LanguagePeer::doSelectOne($c);
      if (is_object($language))
         $user->setCulture($language->getOriginalLanguage());


      $c = new Criteria();
      $c->add(InvoicePeer::ORDER_ID, $this->order->getId());
      $c->add(InvoicePeer::IS_REQUEST, 1);
      $invoice = InvoicePeer::doSelectOne($c);

      $is_invoice_request = 0;

      if (is_object($invoice))
      {
         $is_invoice_request = 1;
      }

      $this->smarty = new stSmarty($this->getModuleName());

      $mailHtmlHead = stMailer::getHtmlMailDescription("header");

      $mailHtmlFoot = stMailer::getHtmlMailDescription("footer");

      $sendOrderToAdminHtmlMailMessage = stMailTemplate::render('sendOrderToAdminHtml', array('invoice' => $is_invoice_request, 'order' => $this->order, 'head' => $mailHtmlHead, 'foot' => $mailHtmlFoot, 'smarty' => $this->smarty));

      $sendOrderToAdminPlainMailMessage = stMailTemplate::render('sendOrderToAdminPlain', array('invoice' => $is_invoice_request, 'order' => $this->order, 'smarty' => $this->smarty));

      $mail = stMailer::getInstance();
      $mail->setSubject($this->getRequest()->getHost().' - '.__('złożono nowe zamówienie numer').': '.$this->order->getNumber())->setHtmlMessage($sendOrderToAdminHtmlMailMessage)->setPlainMessage($sendOrderToAdminPlainMailMessage)->setReplyTo($this->order->getSfGuardUser()->getUsername());
      stEventDispatcher::getInstance()->notify(new sfEvent($mail, 'stOrderActions.sendMailWithOrderToAdmin', array('order' => $this->order)));

      $ret = $mail->sendToMerchant();

      $user->setCulture($culture);

      return $ret;
   }

   /**
    * Obsługuje wysyłanie mail'i
    */
   function SendMail()
   {
      $mail_error = $this->MailWithOrderToUser();
      $mail_error = $this->MailWithOrderToAdmin();

      return $mail_error;
   }

}