<?php

use_helper('Number', 'stCurrency', 'Date', 'nifty', 'stUrl', 'stProductOptions');

sfLoader::loadHelpers('stProduct', 'stProduct');

st_theme_use_stylesheet('stUser.css');

st_theme_use_stylesheet('stOrder.css');

if ($user_data_billing['company'])
{

   $smarty->assign('user_data_billing_company', stXssSafe::clean($user_data_billing['company']));
}

if (isset($user_data_billing['email']))
{

   $smarty->assign('user_data_billing_email', stXssSafe::clean($user_data_billing['email']));
}

if (isset($user_data_billing['invoice']))
{

   $smarty->assign('user_data_billing_invoice', $user_data_billing['invoice']);
}

if (isset($user_data_billing['newsletter']))
{

   $smarty->assign('user_data_billing_newsletter', $user_data_billing['newsletter']);
}


$smarty->assign('user_data_billing_full_name', stXssSafe::clean($user_data_billing['full_name']));

$smarty->assign('user_data_billing_address', stXssSafe::clean($user_data_billing['address']));

$smarty->assign('user_data_billing_address_more', stXssSafe::clean($user_data_billing['address_more']));

$smarty->assign('user_data_billing_region', stXssSafe::clean($user_data_billing['region']));

$smarty->assign('user_data_billing_code', stXssSafe::clean($user_data_billing['code']));

$smarty->assign('user_data_billing_town', stXssSafe::clean($user_data_billing['town']));

$smarty->assign('user_data_billing_country', CountriesPeer::retrieveByPK($user_data_billing['country']));

$smarty->assign('user_data_billing_phone', stXssSafe::clean($user_data_billing['phone']));

if ($user_data_billing['vatNumber'])
{

   $smarty->assign('user_data_billing_vat_number', stXssSafe::clean($user_data_billing['vatNumber']));
}

if ($user_data_delivery['company'])
{
   $smarty->assign('user_data_delivery_company', stXssSafe::clean($user_data_delivery['company']));
}

$smarty->assign('user_data_delivery_full_name', stXssSafe::clean($user_data_delivery['full_name']));

$smarty->assign('user_data_delivery_address', stXssSafe::clean($user_data_delivery['address']));

$smarty->assign('user_data_delivery_address_more', stXssSafe::clean($user_data_delivery['address_more']));

$smarty->assign('user_data_delivery_region', stXssSafe::clean($user_data_delivery['region']));

$smarty->assign('user_data_delivery_code', stXssSafe::clean($user_data_delivery['code']));

$smarty->assign('user_data_delivery_town', stXssSafe::clean($user_data_delivery['town']));

$smarty->assign('user_data_delivery_country', CountriesPeer::retrieveByPK($user_data_delivery['country']));

$smarty->assign('user_data_delivery_phone', stXssSafe::clean($user_data_delivery['phone']));

$results = array();

foreach ($basket->getItems() as $basket_product)
{

   $row['code'] = $basket_product->getCode();


   $row['validate'] = $basket_product->productValidate();

   if ($row['validate'])
   {

      $row['name_show'] = st_link_to($basket_product->getName(), 'stProduct/show?url=' . $basket_product->getProduct()->getFriendlyUrl());
   }
   else
   {

      $row['name_show'] = $basket_product->getName();
   }

   if ($basket_product->hasPriceModifiers())
   {
      $row['name_show'] = content_tag('div', $row['name_show'], array('class' => 'st_product_name_with_options')) . st_product_options_get_view($basket_product);
   }

   $row['price'] = st_currency_format($basket_product->getPrice(false, true), array('with_exchange' => false));

   $row['vat'] = $basket_product->getVat();

   $row['price_brutto'] = st_currency_format($basket_product->getPrice(true, true), array('with_exchange' => false));

   $row['quantity'] = $basket_product->getQuantity();

   $row['total_amount'] = st_currency_format($basket_product->getTotalAmount(true, true), array('with_exchange' => false));
   
   $row['uom'] = st_product_uom($basket_product->getProduct());
   
   $errors = array();
   
   if ($sf_request->getError('quantity_'.$basket_product->getItemId()))
   {
      $errors['quantity'] = $sf_request->getError('quantity_'.$basket_product->getItemId());
   }
   
   $row['errors'] = $errors;


   $results[] = $row;
}

$smarty->assign('payment_name', $paymentType->getName());

$smarty->assign('payment_info', st_get_component($paymentType->getModuleName() . "Frontend", 'orderSummary', array('basket' => $basket, 'delivery' => $delivery)));

$smarty->assign('delivery_name', $delivery->getDefaultDelivery()->getName());

$smarty->assign('order_cost', st_currency_format($delivery->getTotalDeliveryCost(true, true)));

$smarty->assign('order_total_amount', st_currency_format($total_amount));

$smarty->assign('paid', $paid ? st_currency_format($paid) : null);

$smarty->assign('final_total_amount', st_currency_format($final_total_amount));

$smarty->assign('comment', input_hidden_tag("description", stXssSafe::clean($description)) . content_tag('div', stXssSafe::clean($description), array('style' => 'border: 1px solid #ccc; padding: 5px')));

$smarty->assign('delivery_date', input_hidden_tag("delivery[date]", $delivery_date));

$smarty->assign('delivery_time', input_hidden_tag("delivery[time]", $delivery_time));

if($delivery_date=="1999-11-30"){$delivery_date="";}
if($delivery_time=="00:00:00"){$delivery_time="";}

$smarty->assign('delivery_date_value', $delivery_date." ".$delivery_time);

$smarty->assign('form_start', form_tag('stOrder/save'));

$biling_values = array();

foreach ($user_data_billing as $name => $value)
{

   $row['billing_name'] = input_hidden_tag('user_data_billing[' . $name . ']', $value);

   $biling_values[] = $row;
}

$delivery_values = array();

foreach ($user_data_delivery as $name => $value)
{
   $row['delivery_name'] = input_hidden_tag('user_data_delivery[' . $name . ']', $value);

   $delivery_values[] = $row;
}

$smarty->assign('different_delivery', input_hidden_tag('different_delivery', $different_delivery));

$smarty->assign('create_account', input_hidden_tag('create_account', $create_account));

$smarty->assign('create_account_value', $create_account);

$smarty->assign('password1', input_hidden_tag('password1', $password1));

$smarty->assign('password_value', $password1);

$smarty->assign('password2', input_hidden_tag('password2', $password2));

$smarty->assign('user_data_billing_id', input_hidden_tag('user_data_billing[id]', $user_data_billing['id']));

$smarty->assign('user_data_delivery_id', input_hidden_tag('user_data_delivery[id]', $user_data_delivery['id']));

$smarty->assign('description', input_hidden_tag('description', stXssSafe::clean($description)));

$smarty->assign('description_value', stXssSafe::clean($description));

$smarty->assign('order_correction_submit', submit_tag(__('Popraw'), array('onclick' => "this.form.action ='" . url_for('basket/index?submit_save=true') . "'")));

$smarty->assign('order_correction', url_for('basket/index?submit_save=true'));

$smarty->assign('order_submit', submit_tag(__('Potwierdź')));

$smarty->assign('biling_values', $biling_values);

$smarty->assign('delivery_values', $delivery_values);

$smarty->assign('results', $results);

if ($additional_confirm_text) $smarty->assign('additional_confirm_text', $additional_confirm_text->getContent());

$smarty->display('order_confirm.html');