<?php

use_helper('Number', 'stCurrency', 'Date', 'stApplication', 'stDelivery');

sfLoader::loadHelpers('stProduct', 'stProduct');

$smarty->assign('host', $sf_request->getHost());

$smarty->assign('username', $order->getSfGuardUser()->getUsername());

$smarty->assign('created_at', $order->getCreatedAt());

$smarty->assign('id', $order->getId());

$smarty->assign('number', $order->getNumber());

$smarty->assign('is_invoice_request', $invoice);

$smarty->assign('order_link', st_link_to(__("Przejdź do zamówienia."), '@stGoToOrder?order=' . $order->getId(), 'absolute=true for_app=backend'));

$smarty->assign('billing_company', $order->getOrderUserDataBilling()->getCompany());

$smarty->assign('vat_nr', $order->getOrderUserDataBilling()->getVatNumber());

$smarty->assign('billing_full_name', $order->getOrderUserDataBilling()->getFullName());

$smarty->assign('billing_address', $order->getOrderUserDataBilling()->getAddress());

$smarty->assign('billing_address_more', $order->getOrderUserDataBilling()->getAddressMore());

$smarty->assign('billing_region', $order->getOrderUserDataBilling()->getRegion());

$smarty->assign('billing_code_town', $order->getOrderUserDataBilling()->getCode() . '  ' . $order->getOrderUserDataBilling()->getTown());

$smarty->assign('billing_country', $order->getOrderUserDataBilling()->getCountry());

$smarty->assign('billing_full_phone', $order->getOrderUserDataBilling()->getPhone());


$smarty->assign('delivery_company', $order->getOrderUserDataDelivery()->getCompany());

$smarty->assign('delivery_full_name', $order->getOrderUserDataDelivery()->getFullName());

$smarty->assign('delivery_address', $order->getOrderUserDataDelivery()->getAddress());

$smarty->assign('delivery_address_more', $order->getOrderUserDataDelivery()->getAddressMore());

$smarty->assign('delivery_region', $order->getOrderUserDataDelivery()->getRegion());

$smarty->assign('delivery_code_town', $order->getOrderUserDataDelivery()->getCode() . '  ' . $order->getOrderUserDataDelivery()->getTown());

$smarty->assign('delivery_country', $order->getOrderUserDataDelivery()->getCountry());

$smarty->assign('delivery_full_phone', $order->getOrderUserDataDelivery()->getPhone());

$smarty->assign('user_link', st_link_to(__("Przejdź do konta."), '@stGoToUser?user=' . $order->getSfGuardUser()->getId(), 'absolute=true for_app=backend'));


$results = array();

foreach ($order->getOrderProducts() as $product)
{
    $row['code'] = $product->getCode();

    $options = '';

    if ($product->hasPriceModifiers())
    {
        foreach ($product->getPriceModifiers() as $price_modifier)
        {
            $options .= ', '.$price_modifier['label'];
        }

        $options = '('.ltrim($options, ', ').')';
    }

    $row['name'] = $product->getName() . '<br/>' . $options;

    $row['netto'] = st_currency_format($product->getPriceNetto(true));

    $row['vat'] = $product->getVat();

    $row['brutto'] = st_currency_format($product->getPriceBrutto(true));

    $row['quantity'] = $product->getQuantity();
    
    $row['uom'] = st_product_uom($product->getProduct());

    $row['total_amount'] = st_currency_format($product->getTotalAmount(true, true));

    $results[] = $row;
}

$total_amount = $order->getTotalAmount(true, true);

$final_total_amount = $order->getUnpaidAmount();

$smarty->assign('total_amount_plain', st_currency_format($total_amount));

$smarty->assign('total_amount', st_currency_format($total_amount));

if ($order->getPaidAmount() > 0)
{
   $smarty->assign('paid', st_currency_format($order->getPaidAmount()));
}

$smarty->assign('total_amount_html', st_currency_format($final_total_amount));

$smarty->assign('final_total_amount', st_currency_format($final_total_amount));

$smarty->assign('payment_name', $order->getOrderPayment()->getPaymentType()->getName());

$smarty->assign('delivery_name', $order->getOrderDelivery()->getDelivery()->getName());

$smarty->assign('delivery_cost', st_currency_format($order->getOrderDelivery()->getCostBrutto(true)));

$smarty->assign('delivery_date', getDeliveryDateFormat($order->getOrderDelivery()->getDeliveryDate()));

$smarty->assign('comment', $order->getDescription());

$smarty->assign('results', $results);

$smarty->assign('user_head', $head);

$smarty->assign('user_foot', $foot);

$smarty->display('order_send_order_to_admin_html_mail.html');
