<?php

use_helper('nifty', 'stOrder', 'stUrl', 'stProductOptions', 'stDelivery');

sfLoader::loadHelpers('stProduct', 'stProduct');

st_theme_use_stylesheet('stUser.css');

st_theme_use_stylesheet('stOrder.css');

echo javascript_tag(nifty_round_elements('li.st_order-order_sumary-sumary_box_left', 'same-height'));

echo javascript_tag(nifty_round_elements('div.st_order-order_sumary-user_data', 'same-height'));

if ($sf_user->isAuthenticated() && $sf_user->hasAccount())
{

    $smarty->assign('user', $sf_user->isAuthenticated() && $sf_user->hasAccount());

    $smarty->assign('user_panel_icon', st_theme_image_tag('user_panel_icon.png'));

    $smarty->assign('my_account', link_to(__('Moje konto'), 'stUserData/userPanel'));

    $smarty->assign('order_number', __('Zamówienie numer %number%', array('%number%' => $order->getNumber())));

    $smarty->assign('user_panel_menu', st_get_component('stUserData', 'userPanelMenu'));
}
else
{

    $smarty->assign('order_number', __('Zamówienie numer %number%', array('%number%' => $order->getNumber())));
}

if ($sf_flash->has('notice'))
{

    $smarty->assign('notice_flash', $sf_flash->has('notice'));

    $smarty->assign('notice', __($sf_flash->get('notice')));
}


if ($user_data_billing->getCompany())
{

    $smarty->assign('user_data_billing_company', $user_data_billing->getCompany());
}

$smarty->assign('user_data_billing_full_name', $user_data_billing->getFullName());

$smarty->assign('user_data_billing_address', $user_data_billing->getAddress());

$smarty->assign('user_data_billing_address_more', $user_data_billing->getAddressMore());

$smarty->assign('user_data_billing_region', $user_data_billing->getRegion());

$smarty->assign('user_data_billing_code', $user_data_billing->getCode());

$smarty->assign('user_data_billing_town', $user_data_billing->getTown());

$smarty->assign('user_data_billing_country', $user_data_billing->getCountry());

$smarty->assign('user_data_billing_phone', $user_data_billing->getPhone());

if ($user_data_billing->getVatNumber())
{

    $smarty->assign('user_data_billing_vat_number', $user_data_billing->getVatNumber());
}

if ($user_data_delivery->getCompany())
{

    $smarty->assign('user_data_delivery_company', $user_data_delivery->getCompany());
}

$smarty->assign('user_data_delivery_full_name', $user_data_delivery->getFullName());

$smarty->assign('user_data_delivery_address', $user_data_delivery->getAddress());

$smarty->assign('user_data_delivery_address_more', $user_data_delivery->getAddressMore());

$smarty->assign('user_data_delivery_region', $user_data_delivery->getRegion());

$smarty->assign('user_data_delivery_code', $user_data_delivery->getCode());

$smarty->assign('user_data_delivery_town', $user_data_delivery->getTown());

$smarty->assign('user_data_delivery_country', $user_data_delivery->getCountry());

$smarty->assign('user_data_delivery_phone', $user_data_delivery->getPhone());

$results = array();

foreach ($order_products as $order_product)
{
    $row['code'] = $order_product->getCode();

    $row['validate'] = $order_product->productValidate();

    if ($order_product->productValidate())
    {
        $row['name_show'] = st_link_to($order_product->getName(), 'stProduct/show?url=' . $order_product->getProduct()->getFriendlyUrl());
    }
    else
    {
        $row['name_show'] = $order_product->getName();
    }

    if ($order_product->hasPriceModifiers())
    {
        $row['name_show'] = content_tag('div', $row['name_show'], array('class' => 'st_product_name_with_options')).st_product_options_get_view($order_product);
    }

    $row['price'] = st_order_price($order_product->getPrice(), $currency);

    $row['vat'] = $order_product->getVat();

    $row['price_true'] = st_order_price($order_product->getPrice(true), $currency);

    $row['quantity'] = $order_product->getQuantity();

    $row['uom'] = st_product_uom($order_product->getProduct());
    
    $row['total_amount'] = st_order_product_total_amount($order_product, $currency);


    $results[] = $row;
}

if(isset ($payment))
{
   $smarty->assign('payment_name', $payment->getName());
}

$smarty->assign('delivery_number', $delivery->getNumber());

$smarty->assign('delivery_name', $delivery->getName());

$smarty->assign('delivery_date', getDeliveryDateFormat($delivery->getDeliveryDate()));

$smarty->assign('order_cost', st_order_price($delivery->getCost(true), $currency));

$smarty->assign('order_total_amount', st_order_total_amount($order));

//die('paid'.$order->getPaidAmount());

$smarty->assign('paid', $order->getPaidAmount() ? st_order_price_format($order->getPaidAmount(), $order->getOrderCurrency()) : null);

$smarty->assign('final_total_amount', st_order_price_format($order->getUnpaidAmount(), $order->getOrderCurrency()));

$smarty->assign('show_all', link_to(__("Pokaż listę zamówień "), "/order/list"));


$smarty->assign('created_at', $order->getCreatedAt());

$smarty->assign('status', st_order_status($order->getOrderStatus()));

$smarty->assign('is_paid', $order->getIsPayed() ? __('tak') : __('nie'));

if ($order->getIsConfirmed() == 0 && $order->getOrderStatusId() == 1)
{

    $smarty->assign('is_confirmed', __('nie'));
}
else
{

    $smarty->assign('is_confirmed', $order->getIsConfirmed() ? __('tak') : link_to(__('potwierdź'), '@stOrderConfirmForUser?id=' . $order->getId() . '&hash_code=' . $order->getHashCode() . '&register=0' . '&cancel=0') . " <br/> " . link_to(__('anuluj'), '@stOrderConfirmForUser?id=' . $order->getId() . '&hash_code=' . $order->getHashCode() . '&register=0' . '&cancel=1'));
}

$smarty->assign('review', st_get_component('stReview', 'addReviewList', array('order' => $order, 'smarty' => $smarty, 'results' => $results)));

$smarty->assign('invoice', st_get_component('stInvoicePdf', 'orderInvoice', array('order' => $order)));


$smarty->assign('show_payment', $order->getIsPayed());

$smarty->assign('payment_box', st_get_component('stPayment', 'showPayment'));

$smarty->assign('results', $results);

$smarty->display('order_show.html');
