<?php
/** 
 * SOTESHOP/stPayment 
 * 
 * Ten plik należy do aplikacji stPayment opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stPayment
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: components.class.php 13721 2011-06-20 14:13:12Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>,
 */

/** 
 * Klasa stPaymentComponents
 *
 * @package     stPayment
 * @subpackage  actions
 */
class stPaymentComponents extends sfComponents
{
    /** 
     * Wyświetlenie listy płatności
     */
    public function executeSelectPaymentType()
    {
        $this->smarty = new stSmarty('stPayment');
        $c = new Criteria();
        $c->add(PaymentTypePeer::ACTIVE, 1);
        $this->paymentTypes = PaymentTypePeer::doSelect($c);
        
        $paymentTypes = $this->paymentTypes;
        foreach ($paymentTypes as $key => $paymentType)
        {
            if(class_exists($paymentType->getModuleName()))
            {
                $moduleName = $paymentType->getModuleName();
                $obj = new $moduleName;
                if(method_exists($obj, 'checkPaymentConfiguration'))
                {
                    if (!$obj->checkPaymentConfiguration())
                    {
                        unset($this->paymentTypes[$key]);
                    }
                }
            }
        }
        
        $this->hasPaymentType = false;
        if (count($this->paymentTypes) > 0)
        {
            $this->hasPaymentType = true;
        }
        
        $this->checked = 0;
        
        $paymentType = stPayment::getInstance($this->getContext());
        if(is_object($paymentType->get())) $this->checked = $paymentType->get()->getId();
    }

    /** 
     * Pokazanie płatności w podsumowaniu zamówienia
     */
    public function executeShowPayment()
    {
        $this->smarty = new stSmarty('stPayment');

        if (stPayment::hasOrderIdInSummary($this->getContext()))
        {
            $orderId = stPayment::getOrderIdInSummary($this->getContext());
            
            $c = new Criteria();
            $c->add(OrderHasPaymentPeer::ORDER_ID, $orderId);
            $c->addJoin(OrderHasPaymentPeer::PAYMENT_ID, PaymentPeer::ID);
            $c->add(PaymentPeer::GIFT_CARD_ID, null, Criteria::ISNULL);
            
            $orderHasPayment = OrderHasPaymentPeer::doSelectOne($c);
            
            if (!$orderHasPayment)
            {
               return sfView::NONE;
            }

            $this->paymentType = $orderHasPayment->getPayment()->getPaymentType()->getModuleName();
            
            if(!$this->getController()->componentExists($this->paymentType.'Frontend','showPayment'))
            {
                return sfView::NONE;
            }
        }
    }
    
    /**
     * Pokazywanie informacji na karcie produktu
     */
    public function executeShowInfoInProduct()
    {
    	$this->smarty = new stSmarty('stPayment');
    	$this->id = $this->getRequest()->getParameter('id');
    	
    	if (class_exists('stLukas') && class_exists('stZagiel') && !stLukas::isActive() && !stZagiel::isActive()) return sfView::NONE;
    }
}