<?php

/**
 * SOTESHOP/stProduct
 *
 * Ten plik należy do aplikacji stProduct opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProduct
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 2594 2009-08-14 14:12:36Z krzysiek $
 */

/**
 * Akcje produktu
 *
 * @author Krzysztof Bebło <krzysztof.beblo@sote.pl>
 *
 * @package     stProduct
 * @subpackage  actions
 */
class stProductActions extends stActions
{

   public function executeAttachmentList()
   {
      $product_id = $this->getRequestParameter('id');

      $this->product = ProductPeer::retrieveByPK($product_id);

      $this->smarty = new stSmarty('stProduct');

      $c = new Criteria();

      $c->addJoin(ProductHasAttachmentPeer::SF_ASSET_ID, sfAssetPeer::ID);

      $c->add(ProductHasAttachmentPeer::PRODUCT_ID, $this->product->getId());

      $c->add(ProductHasAttachmentPeer::IS_ACTIVE, true);

      $c->add(ProductHasAttachmentPeer::OPT_CULTURE, $this->getUser()->getCulture());

      $this->attachments = sfAssetPeer::doSelectJoinsfAssetFolder($c);

      $this->setLayout(false);
   }

   /**
    * Lista Produktow z produktów danego producenta 
    */
   public function executeProducerList()
   {
      $this->page = $this->getRequestParameter('page');
      if (!$this->processProducerFriendlyUrl())
      {
         return $this->forward('stProduct', 'producerNotFound');
      }

      $this->config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $this->smarty = new stSmarty($this->getModuleName());

      $pager = new stPropelPager('Product');

      $c = new Criteria();

      $this->addProducerList($c);

      $this->productPagerInit($c);

      $this->product_on_page = $this->product_pager->getCntResults();

      $this->for_link = array(
          'url' => $this->producer->getFriendlyUrl(),
          'type' => $this->type_list_url,
          'sort_by' => $this->sort_by,
          'sort_order' => $this->sort_order,
          'page' => $this->product_pager->getPage()
      );

      $this->sort_labels = $this->getSortColumns('label_names');

      $this->view_labels = $this->getViewTypes('label_names');

      $this->title = $this->producer->getName();
   }

   /**
    * Strona nieznalezionej grupy produktów
    *
    */
   public function executeProducerNotFound()
   {
      $this->getResponse()->setStatusCode(404);

      $this->getResponse()->setHttpHeader('Status', '404 Not Found');

      $this->smarty = new stSmarty($this->getModuleName());
   }

   /**
    *
    * Obsługa przyjaznych linkow dla producentów
    * @author Krzysztof Beblo <krzysztof.beblo@sote.pl>
    *
    */
   protected function processProducerFriendlyUrl()
   {
      if ($this->getRequest()->hasParameter('url'))
      {
         $url = $this->getRequest()->getParameter('url');

         $c = new Criteria();

         $c->addJoin(ProducerI18nPeer::ID, ProducerPeer::ID);

         $c->add(ProducerI18nPeer::URL, $url);

         $this->producer = ProducerPeer::doSelectOne($c);

         if ($this->producer)
         {
            $selected_producer_filter_id = stProducer::getSelectedProducerId();
            if (($selected_producer_filter_id) && ($this->producer->getId() != $selected_producer_filter_id))
            {
               stProducer::clearSelectedProducerId();
            }
            $this->producer->setCulture($this->getUser()->getCulture());

            if ($url != $this->producer->getFriendlyUrl())
            {
               sfLoader::loadHelpers(array('Helper', 'stUrl'));

               $r = sfRouting::getInstance();

               list(, $redirect) = $this->getController()->convertUrlStringToParameters($r->getCurrentInternalUri());

               $redirect['url'] = $this->producer->getFriendlyUrl();

               $this->redirect(st_url_for($redirect, true), 301);
            }
         }
         else
         {
            return false;
         }
      }

      return true;
   }

   /**
    * Dodaje kryteria producenta
    *
    * @param      Criteria    $c
    */
   protected function addProducerList(Criteria $c)
   {
      if ($this->producer)
      {
         $c->add(ProductPeer::PRODUCER_ID, $this->producer->getId());
      }
   }

   /**
    *
    * Lista Produktow z danej grupy
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    *
    */
   public function executeGroupList()
   {
      $this->page = $this->getRequestParameter('page');

      if (!$this->processGroup301Redirects())
      {
         return $this->forward('stProduct', 'productGroupNotFound');
      }

      if (!$this->processGroupFriendlyUrl())
      {
         return $this->forward('stProduct', 'productGroupNotFound');
      }

      $this->config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $this->smarty = new stSmarty($this->getModuleName());

      $pager = new stPropelPager('Product');


      $c = new Criteria();

      $this->addProductGroup($c);

      $this->productPagerInit($c);

      $this->product_on_page = $this->product_pager->getCntResults();

      if ($this->product_on_page == 0 && $this->product_group->getProductGroup() == 'NEW')
      {
         $c->clear();

         $this->addNew($c);

         $this->productPagerInit($c);

         $this->product_on_page = $this->product_pager->getCntResults();
      }

      $this->for_link = array(
          'url' => $this->product_group->getFriendlyUrl(),
          'type' => $this->type_list_url,
          'sort_by' => $this->sort_by,
          'sort_order' => $this->sort_order,
          'page' => $this->product_pager->getPage(),
          'producer_filter' => $this->producer_filter
      );

      $this->sort_labels = $this->getSortColumns('label_names');

      $this->view_labels = $this->getViewTypes('label_names');

      $this->title = $this->product_group->getName();
   }

   /**
    *
    * Lista Produktow
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    *
    */
   public function executeList()
   {
      $this->page = $this->getRequestParameter('page');

      if (!$this->processGroup301Redirects())
      {
         return $this->forward('stProduct', 'groupNotFound');
      }

      if (!$this->processNew301Redirects())
      {
         return $this->forward('stProduct', 'groupNotFound');
      }

      if (!$this->processCategory301Redirects())
      {
         return $this->forward('stProduct', 'categoryNotFound');
      }

      if (!$this->processCategoryFriendlyUrl())
      {
         return $this->forward('stProduct', 'categoryNotFound');
      }

      $this->config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $this->smarty = new stSmarty($this->getModuleName());

      $c = new Criteria();

      $this->addCategory($c);

      $this->productPagerInit($c);

      $this->product_on_page = $this->product_pager->getCntResults();

      $this->for_link = array(
          'url' => $this->category->getFriendlyUrl(),
          'type' => $this->type_list_url,
          'sort_by' => $this->sort_by,
          'sort_order' => $this->sort_order,
          'page' => $this->product_pager->getPage(),
          'producer_filter' => $this->producer_filter
      );

      $this->sort_labels = $this->getSortColumns('label_names');

      $this->view_labels = $this->getViewTypes('label_names');

      $this->getUser()->setParameter('selected', $this->category, 'soteshop/stCategory');
   }

   /**
    * Wyświetla opis szczegółowy produktu
    */
   public function executeShow()
   {
      $this->config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $this->smarty = new stSmarty($this->getModuleName());

      if (!$this->processProduct301Redirects())
      {
         return $this->forward('stProduct', 'productNotFound');
      }

      if (!$this->processProductFriendlyUrl())
      {
         return $this->forward('stProduct', 'productNotFound');
      }

      // zakładki
      $this->addTabs($this->product);

      $this->description = $this->product->getDescription();

      if ($this->hasRequestParameter('uniqid'))
      {
         $this->uniqid = $this->getRequestParameter('uniqid');
         $this->getUser()->setAttribute('uniqid', $this->getRequestParameter('uniqid'));
         $this->getUser()->setAttribute('uniqid_product_id', $this->product->getId());
      }
      else
      {
         $this->uniqid = false;
      }

      if ($this->product->getProducerId())
      {
         $this->producer = $this->product->getProducer();
      }

      $this->category = $this->product->getDefaultCategory();

      if ($this->category)
      {
         $this->getUser()->setParameter('selected', $this->category, 'soteshop/stCategory');
      }

      $this->themeVersion = $this->getController()->getTheme()->getVersion();
   }

   /**
    * Polecane produkty w opisie szczegółowym produktu
    */
   public function executeRecommendProducts()
   {
      $this->setLayout(false);

      $this->config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $this->smarty = new stSmarty($this->getModuleName());

      $this->product_id = $this->getRequestParameter('id');

      //$pager = new sfPropelPager('Product', $this->config->get('other_products_num'));

      $c = new Criteria();

      $c->addDescendingOrderByColumn(ProductI18nPeer::NAME);

      $c->addJoin(ProductHasCategoryPeer::PRODUCT_ID, ProductPeer::ID);

      $c->add(ProductHasCategoryPeer::CATEGORY_ID, $this->getRequestParameter('id_category'));

      $c->add(ProductPeer::ID, $this->product_id, Criteria::NOT_EQUAL);

      $c->setLimit($this->config->get('other_products_num'));

      $this->addProductCriteria($c);

      $this->products = ProductPeer::doSelectWithI18n($c);

      $this->list_type = "listOther";
   }

   /**
    * Wyświetla opis produktu
    */
   public function executeProductDescription()
   {
      $this->smarty = new stSmarty($this->getModuleName());

      $this->setLayout(false);

      $this->product = ProductPeer::getShowedProduct();
      if (!is_object($this->product))
         $this->product = ProductPeer::retrieveByPk($this->getRequestParameter('id'));

      $this->description = $this->product->getDescription();
   }

   /**
    * Strona nieznalezionej kategorii
    *
    */
   public function executeCategoryNotFound()
   {
      $this->getResponse()->setStatusCode(404);

      $this->getResponse()->setHttpHeader('Status', '404 Not Found');

      $this->smarty = new stSmarty($this->getModuleName());
   }

   /**
    * Zwraca zawartość obrazka typu 'big'
    *
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    * @return sfView
    */
   public function executeShowImage()
   {
      $image = $this->getRequestParameter('image');

      $folder = sfAssetFolderPeer::retrieveByPK($this->getRequestParameter('folder'));

      if ($folder)
      {
         $asset = sfAssetPeer::retrieveFromUrl($folder->getRelativePath() . '/' . $image);
      }

      sfLoader::loadHelpers(array('Helper', 'stProductImage'));

      $file = st_product_image_path($asset, 'big', true, true);

      $info = getimagesize($file);

      $this->getResponse()->setHttpHeader('Content-Type', image_type_to_mime_type($info[2]));

      return $this->renderText(file_get_contents($file));
   }

   /**
    * Generuje obrazek z ajax requesta
    *
    * @return   void
    */
   public function executePhotoAjax()
   {
      $product = ProductPeer::retrieveByPK($this->getRequestParameter('id'));
      $this->image = '/uploads/products/' . $product->getImage() . '/' . $this->getRequestParameter("asset_id");
      $dimensions = getimagesize('uploads/products/' . $product->getImage() . '/' . $this->getRequestParameter("asset_id"));
      $dimensions[0] += 20;
      $dimensions[1] += 30;
      $this->dimensions = $dimensions;
   }

   public function executeDownloadAttachment()
   {
      $folder = $this->getRequestParameter('folder');

      $culture = $this->getRequestParameter('culture');

      $filename = $this->getRequestParameter('filename');

      $file = sfAssetPeer::retrieveFromUrl('/media/products/' . $folder . '/attachments/' . $culture . '/' . $filename);

      if (!$file)
      {
         return $this->forward404();
      }

      $filepath = $file->getFullPath();

      $response = $this->getResponse();

      $response->setHttpHeader('Content-Description', 'File Transfer');

      $response->setHttpHeader('Content-Type', 'application/octet-stream');

      $response->setHttpHeader('Content-Disposition', 'attachment; filename=' . $file->getFilename());

      $response->setHttpHeader('Content-Transfer-Encoding', 'binary');

      $response->setHttpHeader('Expires', 0);

      $response->setHttpHeader('Cache-Control', 'must-revalidate, post-check=0, pre-check=0');

      $response->setHttpHeader('Pragma', 'public');

      $response->setHttpHeader('Content-Length', filesize($filepath));

      return $this->renderText(file_get_contents($filepath));
   }

   /**
    * Strona nieznalezionego produktu
    *
    */
   public function executeProductNotFound()
   {
      $this->getResponse()->setStatusCode(404);

      $this->getResponse()->setHttpHeader('Status', '404 Not Found');

      $this->smarty = new stSmarty($this->getModuleName());
   }

   /**
    * Strona nieznalezionej grupy produktów
    *
    */
   public function executeProductGroupNotFound()
   {

      $this->getResponse()->setStatusCode(404);

      $this->getResponse()->setHttpHeader('Status', '404 Not Found');

      $this->smarty = new stSmarty($this->getModuleName());
   }

   public function postExecute()
   {
      if (isset($this->smarty))
      {
         $this->smarty->register_function('st_product_image_tag', 'st_product_smarty_image_tag');
      }

      parent::postExecute();
   }

   /**
    *
    * Pobiera nowy obiekt stPropelPager dla produktu
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    *
    */
   protected function productPagerInit(Criteria $c)
   {
      $this->product_pager = new stPropelPager('Product');

      $c = clone $c;

      $this->addProducer($c);

      $this->addType();

      $this->addSort($c);

      $this->product_pager->setPage($this->page);

      $this->addProductCriteria($c);

      $this->product_pager->setCriteria($c);

      $this->product_pager->setPeerMethod('doSelectWithI18n');

      stEventDispatcher::getInstance()->notify(new sfEvent($this, 'stProductActions.preProductPagerInit', array('pager_criteria' => $this->product_pager->getCriteria())));

      $this->product_pager->init();
   }

   /**
    *
    * Obsluga przyjaznych linkow dla kategorii
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    *
    */
   protected function processCategoryFriendlyUrl()
   {

      if ($this->getRequest()->hasParameter('url'))
      {
         $url = $this->getRequest()->getParameter('url');

         $c = new Criteria();

         $c->addJoin(CategoryI18nPeer::ID, CategoryPeer::ID);

         $c->add(CategoryI18nPeer::URL, $url);

         $producer_id = stProducer::getSelectedProducerId();

         if ($producer_id)
         {
            $c->add(ProductPeer::PRODUCER_ID, $producer_id);
         }

         $c->setLimit(1);

         $category = ProductHasCategoryPeer::doSelectCategories($c, null, false);

         if (isset($category[0]) && $category[0]->getIsActive())
         {
            $this->category = $category[0];

            $this->category->setCulture($this->getUser()->getCulture());

            if ($url != $this->category->getFriendlyUrl())
            {
               sfLoader::loadHelpers(array('Helper', 'stUrl'));

               $r = sfRouting::getInstance();

               list(, $redirect) = $this->getController()->convertUrlStringToParameters($r->getCurrentInternalUri());

               $redirect['url'] = $this->category->getFriendlyUrl();

               $this->redirect(st_url_for($redirect, true), 301);
            }
         }
         else
         {
            return false;
         }
      }

      return true;
   }

   /**
    *
    * Obluga przyjaznych linkow dla grup produktow
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    *
    */
   protected function processGroupFriendlyUrl()
   {
      if ($this->getRequest()->hasParameter('url'))
      {
         $url = $this->getRequest()->getParameter('url');

         $c = new Criteria();

         $c->addJoin(ProductGroupI18nPeer::ID, ProductGroupPeer::ID);

         $c->add(ProductGroupI18nPeer::URL, $url);

         $this->product_group = ProductGroupPeer::doSelectOne($c);

         if ($this->product_group)
         {
            $this->product_group->setCulture($this->getUser()->getCulture());

            if ($url != $this->product_group->getFriendlyUrl())
            {
               sfLoader::loadHelpers(array('Helper', 'stUrl'));

               $r = sfRouting::getInstance();

               list(, $redirect) = $this->getController()->convertUrlStringToParameters($r->getCurrentInternalUri());

               $redirect['url'] = $this->product_group->getFriendlyUrl();

               $this->redirect(st_url_for($redirect, true), 301);
            }
         }
         else
         {
            return false;
         }
      }

      return true;
   }

   protected function processProductFriendlyUrl()
   {
      if ($this->getRequest()->hasParameter('url'))
      {
         $url = $this->getRequest()->getParameter('url');

         $c = new Criteria();

         $c->addJoin(ProductI18nPeer::ID, ProductPeer::ID);

         $c->add(ProductI18nPeer::URL, $url);

         $this->addProductCriteria($c);

         if (ProductPeer::doCount($c))
         {
            $this->product = ProductPeer::getShowedProduct();

            $this->product->setCulture($this->getUser()->getCulture());

            if ($url != $this->product->getFriendlyUrl())
            {
               sfLoader::loadHelpers(array('Helper', 'stUrl'));

               $r = sfRouting::getInstance();

               list(, $redirect) = $this->getController()->convertUrlStringToParameters($r->getCurrentInternalUri());

               $redirect['url'] = $this->product->getFriendlyUrl();

               $this->redirect(st_url_for($redirect, true), 301);
            }
         }
         else
         {
            return false;
         }
      }

      return true;
   }

   /**
    *
    * Obsluga przekierowan dla starych linkow
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    *
    */
   protected function processCategory301Redirects()
   {
      if ($this->hasRequestParameter('id_category'))
      {
         sfLoader::loadHelpers(array('Helper', 'stUrl'));

         $category_id = $this->getRequestParameter('id_category');

         $category = CategoryPeer::retrieveByPK($category_id);

         if (is_null($category))
         {
            return false;
         }

         $category->setCulture($this->getUser()->getCulture());

         if ($this->page)
         {
            $this->redirect(st_url_for('stProduct/list?url=' . $category->getFriendlyUrl() . '&page=' . $this->page, true), 301);
         }
         else
         {
            $this->redirect(st_url_for('stProduct/list?url=' . $category->getFriendlyUrl(), true), 301);
         }
      }

      return true;
   }

   protected function processGroup301Redirects()
   {
      if ($this->hasRequestParameter('group_id'))
      {
         sfLoader::loadHelpers(array('Helper', 'stUrl'));

         $produt_group_id = $this->getRequestParameter('group_id');

         $product_group = ProductGroupPeer::retrieveByPK($produt_group_id);

         if (is_null($product_group))
         {
            return false;
         }

         $product_group->setCulture($this->getUser()->getCulture());

         if ($this->page)
         {
            return $this->redirect(st_url_for('stProduct/groupList?url=' . $product_group->getFriendlyUrl() . '&page=' . $this->page, true), 301);
         }
         else
         {
            return $this->redirect(st_url_for('stProduct/groupList?url=' . $product_group->getFriendlyUrl(), true), 301);
         }
      }

      return true;
   }

   protected function processNew301Redirects()
   {
      if ($this->hasRequestParameter('new'))
      {
         sfLoader::loadHelpers(array('Helper', 'stUrl'));

         $c = new Criteria();

         $c->add(ProductGroupPeer::PRODUCT_GROUP, 'NEW');

         $product_group = ProductGroupPeer::doSelectOne($c);

         if (is_null($product_group))
         {
            return false;
         }

         $product_group->setCulture($this->getUser()->getCulture());

         if ($this->page)
         {
            return $this->redirect(st_url_for('stProduct/groupList?url=' . $product_group->getFriendlyUrl() . '&page=' . $this->page, true), 301);
         }
         else
         {
            return $this->redirect(st_url_for('stProduct/groupList?url=' . $product_group->getFriendlyUrl(), true), 301);
         }
      }

      return true;
   }

   protected function processProduct301Redirects()
   {
      if ($this->hasRequestParameter('id'))
      {
         sfLoader::loadHelpers(array('Helper', 'stUrl'));

         $product_id = $this->getRequestParameter('id');

         $product = ProductPeer::retrieveByPK($product_id);

         if (is_null($product))
         {
            return false;
         }

         $product->setCulture($this->getUser()->getCulture());

         return $this->redirect(st_url_for('stProduct/show?url=' . $product->getFriendlyUrl(), true), 301);
      }

      return true;
   }

   /**
    * Typ wyświetlanej listy
    *
    * @param        object      $pager
    */
   protected function addType()
   {
      $view_types = $this->getViewTypes('view_names');

      if ($this->hasRequestParameter('type'))
      {
         $this->getUser()->setAttribute('view_type', $this->getRequestParameter('type'), 'soteshop/stProduct');
      }

      $this->type_list_url = $this->getUser()->getAttribute('view_type', $this->config->get('list_type'), 'soteshop/stProduct');

      if (isset($view_types[$this->type_list_url]))
      {
         $this->list_type = $view_types[$this->type_list_url];

         $this->product_pager->setMaxPerPage($this->config->get($this->type_list_url . '_list'));
      }
   }

   /**
    * Sprawdza czy jest to kategoria i dodaje kryteria kategorii
    *
    * @param      Criteria    $c
    */
   protected function addCategory(Criteria $c)
   {
      if ($this->category)
      {
         $c->addJoin(ProductPeer::ID, ProductHasCategoryPeer::PRODUCT_ID);

         $c->add(ProductHasCategoryPeer::CATEGORY_ID, $this->category->getId());
      }
   }

   /**
    * Sprawdza czy jest wybrane filtrowanie po producentach
    *
    * @param Criteria $c
    */
   protected function addProducer(Criteria $c)
   {
      $default = stProducer::getSelectedProducerId() ? stProducer::getSelectedProducerId() : 0;
      
      if ($this->hasRequestParameter('producer_filter'))
      {
         $producer_filter = $this->getRequestParameter('producer_filter');

         $this->getUser()->setAttribute('producer_filter', $producer_filter, 'soteshop/stProduct');
      }
      elseif (!$this->hasRequestParameter('page'))
      {
         $this->getUser()->setAttribute('producer_filter', $default, 'soteshop/stProduct');
      }

      $this->producer_filter = $this->getUser()->getAttribute('producer_filter', $default, 'soteshop/stProduct');

      if ($this->producer_filter)
      {
         $c->add(ProductPeer::PRODUCER_ID, $this->producer_filter);
      }
   }

   /**
    * Wyświetla nowości
    *
    * @param      Criteria    $c
    */
   protected function addNew(Criteria $c)
   {
      $config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $c->add(ProductPeer::CREATED_AT, $config->get('new_product_date'), Criteria::GREATER_THAN);

      $this->new = $this->getRequestParameter('new');
   }

   /**
    * Wyświetla daną grupę produktów
    *
    * @param      Criteria    $c
    */
   protected function addProductGroup(Criteria $c)
   {
      $c->addJoin(ProductGroupHasProductPeer::PRODUCT_ID, ProductPeer::ID);
      $c->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $this->product_group->getId());
   }

   /**
    * Dodaje Sortowanie
    *
    * @param      Criteria    $c
    */
   protected function addSort(Criteria $c)
   {
      $sort_columns = $this->getSortColumns('table_names');

      if ($this->hasRequestParameter('sort_order'))
      {
         $this->getUser()->setAttribute('sort_order', $this->getRequestParameter('sort_order'), 'soteshop/stProduct');
      }

      if ($this->hasRequestParameter('sort_by'))
      {
         $this->getUser()->setAttribute('sort_by', $this->getRequestParameter('sort_by'), 'soteshop/stProduct');
      }

      $this->sort_order = $this->getUser()->getAttribute('sort_order', $this->config->get('sort_asc_desc'), 'soteshop/stProduct');

      $this->sort_by = $this->getUser()->getAttribute('sort_by', $this->config->get('sort_type'), 'soteshop/stProduct');

      if (isset($sort_columns[$this->sort_by]))
      {
         if ($this->sort_order == "asc")
         {
            $c->addAscendingOrderByColumn($sort_columns[$this->sort_by]);
         }
         else
         {
            $c->addDescendingOrderByColumn($sort_columns[$this->sort_by]);
         }
      }
   }

   /**
    * Zakładki
    */
   protected function addTabs()
   {
      if ($this->product->getDefaultCategory())
      {
         $category = $this->product->getDefaultCategory();
         $category_id = $category->getId();
      }
      else
      {
         $category_id = $this->product->getCategoryId();
      }

      $for_product = array(
          'id' => $this->product->getId(),
          'id_category' => $category_id,
          'id_producer' => $this->product->getProducerId(),
      );

      $config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $show_description = $config->get('show_description');

      $show_other_products = $config->get('show_other_products');


      $c = new Criteria();

      $c->addJoin(ProductHasCategoryPeer::PRODUCT_ID, ProductPeer::ID);

      $c->add(ProductHasCategoryPeer::CATEGORY_ID, $category_id);

      $c->add(ProductPeer::ID, $this->product->getId(), Criteria::NOT_EQUAL);


      $this->productList = stTabNavigator::getInstance($this->getContext(), 'product_list', 'product/show?id=' . $this->product->getId());

      if ($show_other_products == 1 && ProductHasCategoryPeer::doCount($c) > 0)
      {
         $this->productList->addTab('Polecamy produkty', 'stProduct', 'recommendProducts', $for_product);
      }

      $this->productList->setTab($this->getRequestParameter('product_list'));

      $this->productDescription = stTabNavigator::getInstance($this->getContext(), 'product_description', 'product/show?id=' . $this->product->getId());

      if ($this->getController()->getTheme()->getVersion() < 2)
      {
         if ($show_description == 1 )
         {
            $this->productDescription->addTab('Opis', 'stProduct', 'productDescription', $for_product);
         }
      }

      $c = new Criteria();

      $c->add(ProductHasAttachmentPeer::IS_ACTIVE, true);

      $c->add(ProductHasAttachmentPeer::OPT_CULTURE, $this->getUser()->getCulture());

      if ($this->product->countProductHasAttachments($c) > 0)
      {
         $this->productDescription->addTab('Załączniki', 'stProduct', 'attachmentList', $for_product);
      }

      $this->productDescription->setTab($this->getRequestParameter('product_description', 0));
   }

   /**
    * Dodaje kryteria pokazywania produktu
    *
    * @param      Criteria    $c
    */
   protected function addProductCriteria(Criteria $c)
   {
      $config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $c->add(ProductPeer::ACTIVE, 1);

      if ($config->get('show_without_price'))
      {
         $c->add(ProductPeer::PRICE, 0, Criteria::GREATER_THAN);
      }

      stEventDispatcher::getInstance()->notify(new sfEvent($this, 'stProductActions.postAddProductCriteria', array('criteria' => $c)));
   }

   protected function getSortColumns($type = null)
   {
      $sort = array(
          'label_names' => array(
              'name' => 'Nazwie',
              'price' => 'Cenie',
              'created_at' => 'Najnowszym'
          ),
          'table_names' => array(
              'name' => ProductI18nPeer::NAME,
              'price' => ProductPeer::PRICE,
              'created_at' => ProductPeer::CREATED_AT,
          ),
      );

      return $type ? $sort[$type] : $sort;
   }

   protected function getViewTypes($type = null)
   {
      $types = array(
          'label_names' => array(
              'long' => 'Pełna lista',
              'short' => 'Skrócona lista',
              'other' => 'Lista alternatywna',
          ),
          'view_names' => array(
              'long' => 'listLongProduct',
              'short' => 'listShortProduct',
              'other' => 'listOther',
          ),
      );

      return $type ? $types[$type] : $types;
   }

}