<?php

/**
 * SOTESHOP/stProduct
 *
 * Ten plik należy do aplikacji stProduct opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stProduct
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: components.class.php 2687 2009-08-20 10:57:02Z krzysiek $
 */

/**
 * Akcje komponentu produktu
 *
 * @author Krzysztof Bebło <krzysztof.beblo@sote.pl>
 *
 * @package     stProduct
 * @subpackage  actions
 */
class stProductComponents extends sfComponents
{

   protected static $category = null;

   /**
    * Wyświetla grupę produktów
    */
   public function executeProductGroup()
   {
      $this->smarty = new stSmarty('stProduct');

      $this->smarty->register_function('st_product_image_tag', 'st_product_smarty_image_tag');

      $this->config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');
      $config_product_group = stConfig::getInstance(sfContext::getInstance(), 'stProductGroup');

      if ($this->params)
      {
         $product_group = $this->params;
      }
      elseif ($this->product_group)
      {
         $product_group = $this->product_group;
      }

      $c = new Criteria();
      $c->add(ProductGroupPeer::PRODUCT_GROUP, $product_group);
      $product_group_object = ProductGroupPeer::doSelectOneCached($c);
      if ($product_group_object)
      {
         $this->group_name = $product_group_object->getName();

         $this->group_id = $product_group_object->getId();

         $this->group_url = $product_group_object->getFriendlyUrl();

         $this->product_limit = $product_group_object->getProductLimit();
      }
      else
      {
         return sfView::NONE;
      }

      if ($this->product_limit)
      {
         $c = new Criteria();

         $c->add(ProductGroupPeer::PRODUCT_GROUP, $product_group);

         $c->addJoin(ProductGroupHasProductPeer::PRODUCT_ID, ProductPeer::ID);

         $c->addJoin(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, ProductGroupPeer::ID);

         $this->addProductCriteria($c);
         
         if ($config_product_group->get('limitation'))
         {
            $this->addCategoryLimitation($c);
         }
         
         if ($this->config->get('show_unique'))
         {
            $stUniqueProduct = stUniqueProduct::getInstance();
            $stUniqueProduct->getCriteria($c);
         }

         $this->addRandomCriteria($c, $this->product_limit);

         $c->setLimit($this->product_limit);

         $this->products = ProductPeer::doSelect($c);

         if (!$this->products)
         {
            return sfView::NONE;
         }

         shuffle($this->products);

         if ($this->config->get('show_unique'))
         {
            $stUniqueProduct->addProducts($this->products);
         }

         $this->product_group = $product_group;
      }
   }

   /**
    * Pokaż boks nowe produkty
    */
   public function executeNew()
   {
      $this->product_group = 'NEW';

      $this->executeProductGroup();

      if (empty($this->products))
      {
         $c = new Criteria();

         $c->add(ProductPeer::CREATED_AT, $this->config->get('new_product_date'), Criteria::GREATER_THAN);

         $this->addCategoryLimitation($c);

         $this->addProductCriteria($c);

         $this->addRandomCriteria($c, $this->product_limit);

         $c->setLimit($this->product_limit);


         if ($this->config->get('show_unique'))
         {
            $stUniqueProduct = stUniqueProduct::getInstance();
            $stUniqueProduct->getCriteria($c);
         }

         $this->products = ProductPeer::doSelect($c);

         if (!$this->products)
         {
            return sfView::NONE;
         }

         shuffle($this->products);

         if ($this->config->get('show_unique'))
         {
            $stUniqueProduct->addProducts($this->products);
         }
      }
   }

   /**
    * Filtrowanie kategorii po producentach
    */
   public function executeProducerFilter()
   {
      $this->smarty = new stSmarty('stProduct');

      $config = stConfig::getInstance(sfContext::getInstance(), 'stProducer');

      $this->show_filter_in_category = $config->get('show_filter_in_category');

      if (!$this->show_filter_in_category)
      {
         return sfView::NONE;
      }

      $this->producers = $this->related_object->getProducers();

      if (empty($this->producers))
      {
         return sfView::NONE;
      }

      $this->selected = $this->getUser()->getAttribute('producer_filter', 0, 'soteshop/stProduct');
   }

   /**
    * Wyświetla kategorie na stronie głównej
    */
   public function executeTreeMain()
   {
      $config = stConfig::getInstance(sfContext::getInstance(), 'stCategory');
      
      $this->show_category_main_menu = $config->get('show_category_main_menu');

      if (!$this->show_category_main_menu)
      {
         return sfView::NONE;
      }
      
      $this->producer_id = stProducer::getSelectedProducerId();

      $c = new Criteria();

      if ($this->producer_id)
      {
         $c->add(ProductPeer::PRODUCER_ID, $this->producer_id);
      }

      $c->add(CategoryPeer::MAIN_PAGE, true);
      
      $c->add(CategoryPeer::DEPTH, 1);

      $this->categories = ProductHasCategoryPeer::doSelectCategories($c);

      if (!$this->categories)
      {
         return sfView::NONE;
      }
      
      $this->smarty = new stSmarty('stProduct');      

      $this->config = $config;  

      $this->last_category = count($this->categories) - 1;
   }

   /**
    * Wyświetla produktu dla drzewka dla opcjonalnego pokazywania kategorii
    */
   public function executeTreeProduct()
   {
      $this->smarty = new stSmarty('stProduct');

      $this->smarty->register_function('st_product_image_tag', 'st_product_smarty_image_tag');

      $config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $c = new Criteria();
      $c->addJoin(ProductHasCategoryPeer::PRODUCT_ID, ProductPeer::ID);
      $c->add(ProductHasCategoryPeer::CATEGORY_ID, $this->id_category);

      if ($config->get('show_unique'))
      {
         $stUniqueProduct = stUniqueProduct::getInstance();
         $stUniqueProduct->getCriteria($c);
      }
      $this->addProductCriteria($c);
      $this->addRandomCriteria($c, 1);
      $this->product = ProductPeer::doSelectOne($c);
      if ($config->get('show_unique'))
      {
         $stUniqueProduct->addProducts($this->product);
      }
      $this->category = CategoryPeer::retrieveByPK($this->id_category);
   }

   /**
    * Dodaj dodatkowe kryteria do wyświetlania dla produktu
    *
    * @param      Criteria    $c
    */
   private function addProductCriteria(Criteria $c)
   {
      $config = stConfig::getInstance(sfContext::getInstance(), array(
                  'show_without_price' => stConfig::BOOL), 'stProduct');
      $config->load();
      $c->add(ProductPeer::ACTIVE, 1);
      if ($config->get('show_without_price'))
      {
         $c->add(ProductPeer::PRICE, 0, Criteria::GREATER_THAN);
      }
      $producer_id = $this->getUser()->getAttribute('id', null, 'soteshop/stProducer');

      if ($producer_id)
      {
         $c->add(ProductPeer::PRODUCER_ID, $producer_id);
      }
      stEventDispatcher::getInstance()->notify(new sfEvent($this, 'stProductComponents.postAddProductCriteria', array('criteria' => $c)));
   }

   /**
    * Ogranicza wyświetlanie produktów dla wybranej kategorii
    *
    * @param      Criteria    $c
    */
   private function addCategoryLimitation(Criteria $c)
   {
      $category = $this->getUser()->getParameter('selected', null, 'soteshop/stCategory');

      if ($category)
      {
         $c->addJoin(ProductHasCategoryPeer::PRODUCT_ID, ProductPeer::ID);
         $c->addJoin(ProductHasCategoryPeer::CATEGORY_ID, CategoryPeer::ID);
         $c->add(CategoryPeer::LFT, CategoryPeer::LFT . ' BETWEEN ' . $category->getLft() . ' AND ' . $category->getRgt(), Criteria::CUSTOM);
         ;
         $c->add(CategoryPeer::SCOPE, $category->getScope());
         $c->addGroupByColumn(ProductPeer::ID);
      }
   }

   /**
    * Pokazuje produkt: zdjęcie, opis skrócony
    */
   public function executeSmallProductInfo()
   {
      $this->smarty = new stSmarty('stProduct');

      $this->config = stConfig::getInstance(sfContext::getInstance(), 'stQuestionBackend');

      if ($this->product_id)
      {
         $this->product = ProductPeer::retrieveByPK($this->product_id);
      }
   }

   public function executeImageGallery()
   {
      $this->smarty = new stSmarty('stProduct');

      $this->images = $this->product->getImages();
      $this->product = $this->product;

      if (empty($this->images))
      {
         return sfView::NONE;
      }

      $this->themeVersion = $this->getController()->getTheme()->getVersion();
   }

   /**
    * Lista produktow z grupy typu sBASKET
    */
   public function executeProductInBasketGroup()
   {
      $c = new Criteria();

      $c->add(ProductGroupPeer::PRODUCT_GROUP, 'BASKET');

      $product_group_object = ProductGroupPeer::doSelectOneCached($c);

      if ($product_group_object)
      {
         $this->product_limit = $product_group_object->getProductLimit();
      }

      if ($this->product_limit)
      {
         $c = new Criteria();
         $this->product_group = $product_group_object;
         $c->addJoin(ProductGroupHasProductPeer::PRODUCT_ID, ProductPeer::ID);
         $c->add(ProductGroupHasProductPeer::PRODUCT_GROUP_ID, $product_group_object->getId());
         $this->addProductCriteria($c);
         $c->addAscendingOrderByColumn('RAND()');
         $this->pager = new stPropelPager('Product', $this->product_limit);
         $this->pager->setCriteria($c);
         $this->pager->init();

         if (!$this->pager->getCntResults())
         {
            return sfView::NONE;
         }
      }
      else
      {
         return sfView::NONE;
      }

      $this->config = stConfig::getInstance(sfContext::getInstance(), 'stProduct');

      $this->smarty = new stSmarty('stProduct');

      $this->smarty->register_function('st_product_image_tag', 'st_product_smarty_image_tag');
   }

   /**
    * Pokazuje wybrane losowo produkty z puli
    *
    * @param criteria $c
    * @param integer  $product_limit
    */
   public function addRandomCriteria($c, $product_limit)
   {
      $count_product = ProductPeer::doCount($c);
      if ($count_product > $product_limit)
      {
         $random_offset = rand(0, $count_product - $product_limit);
         $c->setOffset($random_offset);
      }
   }

}
