<?php
use_helper('stTheme', 'I18N');

function st_product_uom($product)
{
   static $uom = null;
   
   if (null === $uom)
   {
      $uom = __('szt.', null, 'stDepositoryFrontend');
   }
   
   return $product && $product->getUom() ? $product->getUom() : $uom;
}

function st_product_quantity_list($name, Product $product, $value = null, $html_options = array())
{
   $config =  stConfig::getInstance('stBasket');
   
   if (isset($html_options['max']))
   {
      $max = $html_options['max'];
      
      unset($html_options['max']);
   }
   else
   {
      $stock_validated = $product->getIsStockValidated();
      
      $check_stock = null === $stock_validated && $product->getConfiguration()->get('depository_basket') || null !== $stock_validated && $stock_validated;
      
      $stock = $check_stock && $product->getStock() ? $product->getStock() : $config->get('max_quantity');
   
      $max_qty = $product->getMaxQty() ? $product->getMaxQty() : $config->get('max_quantity');
      
      $max = $max_qty < $stock ? $max_qty : $stock;
   }
  
   $options = array();
      
   $has_decimals = $product->getStepQty() != intval($product->getStepQty()) || $product->getMinQty() != intval($product->getMinQty());

   for ($i = $product->getMinQty(); $i <= $max; $i += $product->getStepQty())
   {
      $options[$has_decimals ? number_format($i, 2, '.', '') : (string)$i] = $has_decimals ? st_format_price($i) : $i;
   }
   
   if (!$options)
   {
      $options[] = $product->getStock();
   }
   
   end($options);
   
   $last = key($options);
   
   $value = $has_decimals ? number_format($value, 2, '.', '') : (string)$value;
      
   if ($last < $value)
   {
      $value = $last;
   }
   
   return select_tag($name, options_for_select($options, $value), $html_options);
}

function st_product_link_to($label, $action, $for_link, $for_link_custom = array(), $params = array())
{
    $params['rel'] = 'nofollow';

    return st_link_to($label, _st_product_link_to($action, $for_link, $for_link_custom), $params);
}

function st_product_url_for($action, $for_link, $for_link_custom = array(), $absolute = false)
{
   return st_url_for(_st_product_link_to($action, $for_link, $for_link_custom), $absolute);
}

function _st_product_link_to($action, $for_link, $for_link_custom = array())
{
   if ($for_link_custom)
   {
      $for_link = array_merge($for_link, $for_link_custom);
   }
   
   $for_link['module'] = 'stProduct';
   
   $for_link['action'] = $action;
     
   return $for_link;
}

function st_product_get_attachment_icon($attachment)
{
    $types = array('archive' => true, 'txt' => true, 'image' => true, 'pdf' => true);

    $type = isset($types[$attachment->getType()]) ? $attachment->getType() : 'txt';

    return st_theme_image_tag('attachments/'.$type.'.gif', array('alt' => ''));
}