<?php
use_helper('stProductImage');

st_theme_use_stylesheet('stProduct.css');

$tw = st_asset_thumbnail_setting('width', 'thumb');

$th = st_asset_thumbnail_setting('height', 'thumb');

$photos = array();

foreach ($images as $index => $image)
{
   if($themeVersion < 2)
   {
    $photos[$index]['photo'] = link_to(st_product_image_tag($image, 'thumb'), '@stProductShowImage?folder='. $image->getFolderId() . '&image='.$image->getFilename(), array(
            'rel'   => 'lightbox[product_image_gallery]',
            'style' => 'width:' . $tw . 'px;height:' . $th . 'px',
            'title' => $image->getDescription() ? $image->getDescription() : '&nbsp;',
            'id' => $product->getId().":".$image->getId(),
            ));
   }else{
      $photos[$index]['photo'] = link_to(st_product_image_tag($image, 'thumb'), '@stProductShowImage?folder='. $image->getFolderId() . '&image='.$image->getFilename(), array(
            'rel'   => "{gallery: 'zoom_gallery', smallimage: '".st_product_image_path($image, 'large')."', largeimage: '".st_product_image_path($image, 'big')."'}",
            'style' => 'width:' . $tw . 'px;height:' . $th . 'px',
            'title' => $image->getDescription() ? $image->getDescription() : '&nbsp;',
            'id' => $product->getId().":".$image->getId(),
            ));
   $photos[$index]['desc'] = $image->getDescription(); 
   }

}
if(count($photos)==1)
{
   $photos = array();
}


$smarty->assign('photos', $photos);

$smarty->display('product_image_gallery.html');
?>
<script type="text/javascript" language="javascript">
jQuery(function ($)
{
    $(document).ready(function ()
    {
      $('.photo a').click(function() {

        var data = $(this).attr('id');
        var data = data.split(":");
        var params = $('#st_update_product_options_form').serializeArray();

        jQuery.ajax({url: '<?php echo url_for('stProductOptionsFrontend/changeOptionFromGallery') ?>?product_id='+data[0]+'&image_id='+data[1],data: params, dataType: 'script', type: 'POST'});

      });

    });
});
</script>

