<?php

use_helper('stCurrency', 'stText', 'stProductImage', 'stUrl');

st_theme_use_stylesheet('stProduct.css');

$results = array();

$smarty->assign("show_name", $config->get('show_name_long'));

$smarty->assign("show_image", $config->get('show_image_long'));

$smarty->assign("show_code", $config->get('show_code_long'));

$smarty->assign("show_price", $config->get('show_price_long'));

$smarty->assign("show_old_price", $config->get('show_old_price_long'));

$smarty->assign("show_discount", $config->get('show_discount_long'));

$smarty->assign("show_basket", $config->get('show_basket_long'));

$smarty->assign("price_view", $config->get('price_view_long'));

$photo_max_height = st_asset_thumbnail_setting('height', 'small');

$description_type = $config->get('description_type_long');

$cut_description = $config->get('cut_description_long');

$max_desc_length = $config->get('cut_description_num_long');

$cut_name = $config->get('cut_name_long');

$max_name_length = $config->get('cut_name_num_long');

$cut_code = $config->get('cut_code_long');

$max_code_length = $config->get('cut_code_num_long');

foreach ($product_pager->getResults() as $index => $product)
{
    $product_url = st_url_for('stProduct/show?url=' . $product->getFriendlyUrl());

    $product_name = $product->getName();

    $results[$index]['instance'] = $product;

    if ($cut_name && st_check_strlen($product_name) > $max_name_length)
    {
        $results[$index]['name'] = "<span " . get_tooltip($product_name, 3) . ">" . content_tag('a', st_truncate_text($product_name, $max_name_length, '...'), array('href' => $product_url, 'class' => 'product_name')) . "</span>";
    }
    else
    {
        $results[$index]['name'] = content_tag('a', $product_name, array('href' => $product_url, 'class' => 'product_name'));
    }

    if ($cut_code && st_check_strlen($product->getCode()) > $max_code_length)
    {
        $results[$index]['code'] = "<span " . get_tooltip($product->getCode(), 3) . ">" . content_tag('a', st_truncate_text($product->getCode(), $max_code_length, '...'), array('href' => $product_url, 'class' => 'product_name')) . "</span>";
    }
    else
    {
        $results[$index]['code'] = content_tag('a', $product->getCode(), array('href' => $product_url));
    }

    $results[$index]['id'] = $product->getId();

    $results[$index]['photo'] = content_tag('a', st_product_image_tag($product, 'small'), array('href' => $product_url));

    $results[$index]['photo_max_height'] = $photo_max_height;

    $results[$index]['colors'] = st_get_component('stProductOptionsFrontend', 'colors', array('product' => $product));

    if ($product->isPriceVisible())
    {
        $results[$index]['price'] = st_currency_format($product->getPriceBrutto(true));

        $results[$index]['price_net'] = st_currency_format($product->getPriceNetto(true));

        $old_price_brutto = $product->getOldPriceBrutto(true);

        $results[$index]['check_old_price'] = $old_price_brutto != 0;

        $results[$index]['old_price'] = st_currency_format($old_price_brutto);

        $results[$index]['old_price_net'] = st_currency_format($product->getOldPriceNetto(true));

        $results[$index]['basket'] = st_get_component('stBasket', 'add', array('product' => $product));

        $results[$index]['discount'] = $product->getDiscountInPercent();

        $results[$index]['check_price'] = false;

    }
    else
    {
        $results[$index]['check_price'] = true;
    }

    if ($description_type == 'short')
    {
        if ($cut_description && st_check_strlen($product->getShortDescription()) > $max_desc_length)
        {
            $results[$index]['description'] = st_truncate_text($product->getShortDescription(), $max_desc_length, '...');
        }
        else
        {
            $results[$index]['description'] = $product->getShortDescription();
        }
    }
    elseif ($description_type == 'full')
    {
        if ($cut_description && st_check_strlen($product->getDescription()) > $max_desc_length)
        {
            $results[$index]['description'] = st_truncate_text($product->getDescription(), $max_desc_length, '...');
        }
        else
        {
            $results[$index]['description'] = $product->getDescription();
        }
    }

    $results[$index]['name_without_link'] = $product_name;

    $results[$index]['link'] = st_url_for('stProduct/show?url=' . $product->getFriendlyUrl());
}

$smarty->assign('results', $results);

$smarty->display('product_list_long.html');
?>
