<?php
use_helper('stUrl', 'stProduct');

st_theme_use_stylesheet('stProduct.css');

if ($product_pager->haveToPaginate())
{
   $smarty->assign('current_page', $product_pager->getPage());

   $smarty->assign('last_page', $product_pager->getLastPage());

   $sort_order = $sf_user->hasAttribute('sort_order', 'soteshop/stProduct');

   $custom_for_link = array();
   
   $event = new sfEvent($product_pager, 'stProduct.pagerCustomLink');
   stEventDispatcher::getInstance()->filter($event, array('custom_for_link'=>$custom_for_link));
   $tmp = $event->getReturnValue();
   $custom_for_link = $tmp['custom_for_link'];

   if (!$sort_order)
   {
      $smarty->assign('first_page', _st_product_link_to($action, array('url' => $for_link['url'], 'page' => 1), $custom_for_link));

      $smarty->assign('previous_page_url', _st_product_link_to($action, array('url' => $for_link['url'], 'page' => $product_pager->getPreviousPage()),$custom_for_link));
   }
   else
   {
      $smarty->assign('first_page', _st_product_link_to($action, $for_link, array_merge(array('page' => 1), $custom_for_link)));

      $smarty->assign('previous_page_url', _st_product_link_to($action, $for_link, array_merge(array('page' => $product_pager->getPreviousPage()), $custom_for_link)));
   }

   $links = array();

   foreach ($product_pager->getLinks() as $page)
   {
      if ($page != $product_pager->getPage())
      {
         if (!$sort_order)
         {
            $row['page'] = st_product_link_to($page, $action, array('url' => $for_link['url'], 'page' => $page), $custom_for_link);
         }
         else
         {
            $row['page'] = st_product_link_to($page, $action, $for_link, array_merge(array('page' => $page),$custom_for_link));
         }
      }
      else
      {
         $row['page'] = '<span>' . $page . '</span>';
      }

      $links[] = $row;
   }
   
   if (!$sort_order)
   {
      $smarty->assign('next_page_url', _st_product_link_to($action, array('url' => $for_link['url'], 'page' => $product_pager->getNextPage()), $custom_for_link));

      $smarty->assign('last_page_url', _st_product_link_to($action, array('url' => $for_link['url'], 'page' => $product_pager->getLastPage()), $custom_for_link));
   }
   else
   {
      $smarty->assign('next_page_url', _st_product_link_to($action, $for_link, array_merge(array('page' => $product_pager->getNextPage()),$custom_for_link)));

      $smarty->assign('last_page_url', _st_product_link_to($action, $for_link, array_merge(array('page' => $product_pager->getLastPage()),$custom_for_link)));      
   }
   
   $smarty->assign("links", $links);

   $smarty->display('product_pager.html');
}