<?php
use_helper('stProduct');

if ($smarty->getTheme()->getVersion() >= 2)
{
   $results[0]['url'] = st_product_url_for($action, $for_link, array('producer_filter' => 0));

   $results[0]['label'] = __('Wszyscy producenci', null, 'stProducer');   
   
   foreach ($producers as $producer)
   {
      $id = $producer->getId();

      $results[$id]['label'] = $producer->getName();

      $results[$id]['url'] = st_product_url_for($action, $for_link, array('producer_filter' => $producer->getId()));
   }   
}
else
{
   $results[0]['label'] = __('Wszyscy');

   $results[0]['link'] = st_product_link_to($results[0]['label'], $action, $for_link, array('producer_filter' => 0));

   foreach ($producers as $producer)
   {
      $id = $producer->getId();

      $results[$id]['label'] = $producer->getName();

      $results[$id]['link'] = st_product_link_to($producer->getName(), $action, $for_link, array('producer_filter' => $producer->getId()));
   }
}

$smarty->assign('producers', $results);

$smarty->assign('selected', $selected);

$smarty->display('product_producer_filter.html');
?>