<?php

use_helper('stCurrency', 'stProductImage', 'stText', 'stUrl');

st_theme_use_stylesheet('stProduct.css');


$smarty->assign("show_name", $config->get('show_name_group'));

$smarty->assign("show_image", $config->get('show_image_group'));

$smarty->assign("show_price", $config->get('show_price_group'));

$smarty->assign("show_basket", $config->get('show_basket_long'));

$smarty->assign("show_description", $config->get('show_description_group'));

$smarty->assign("show_old_price", $config->get('show_old_price_group'));

$smarty->assign("show_discount", $config->get('show_discount_group'));

$smarty->assign("price_view", $config->get('price_view_group'));

$smarty->assign("product_group", $product_group);

$smarty->assign('group_name_title', st_link_to($group_name, 'stProduct/groupList?url=' . $group_url));

$smarty->assign('group_name_link', st_url_for('stProduct/groupList?url=' . $group_url));

$description_type = $config->get('description_type_group');

$show_description = $config->get('show_description');

$cut_description = $product_group == 'MAIN_PAGE' ? $config->get('cut_description_group') : false;

$max_desc_length = $config->get('cut_description_num_group');

$cut_name = $product_group == 'MAIN_PAGE' ? $config->get('cut_name_group') : false;

$max_name_length = $config->get('cut_name_num_group');

$results = array();

$i = 0;

foreach ($products as $index => $product)
{
    $product_url = st_url_for('stProduct/show?url=' . $product->getFriendlyUrl());

    $product_name = $product->getName();

    $i++;
    if ($i == 1)
    {
        $results[$index]['class'] = 'st_component-st_product-product_main_box_first';
    }
    elseif ($i == 3)
    {
        $results[$index]['class'] = 'st_component-st_product-product_main_box_last';
        $i = 0;
    }
    else
    {
        $results[$index]['class'] = 'st_component-st_product-product_main_box_middle';
    }

    if ($cut_name && st_check_strlen($product_name) > $max_name_length)
    {
        $results[$index]['name'] = "<span " . get_tooltip($product_name, 3) . ">" . content_tag('a', st_truncate_text($product_name, $max_name_length, '...'), array('href' => $product_url, 'class' => 'product_name')) . "</span>";
    }
    else
    {
        $results[$index]['name'] = content_tag('a', $product_name, array('href' => $product_url, 'class' => 'product_name'));
    }

    $results[$index]['instance'] = $product;

    $results[$index]['id'] = $product->getId();

    $results[$index]['photo'] = content_tag('a', st_product_image_tag($product, 'small'), array('href' => $product_url));

    $results[$index]['point'] = st_theme_image_tag('circle_list_product.gif', array('alt' => '', 'width'=>'11', 'height'=>'11'));

    $results[$index]['colors'] = st_get_component('stProductOptionsFrontend', 'colors', array('product' => $product));

    if ($product->isPriceVisible())
    {
        $results[$index]['price'] = st_currency_format($product->getPriceBrutto(true));

        $results[$index]['price_net'] = st_currency_format($product->getPriceNetto(true));

        $old_price_brutto = $product->getOldPriceBrutto(true);

        $results[$index]['check_old_price'] = $old_price_brutto != 0;

        $results[$index]['old_price'] = st_currency_format($old_price_brutto);

        $results[$index]['old_price_net'] = st_currency_format($product->getOldPriceNetto(true));

        $results[$index]['discount'] = $product->getDiscountInPercent();

        $results[$index]['basket'] = st_get_component('stBasket', 'add', array('product' => $product));

        $results[$index]['check_price'] = false;
    }
    else
    {
        $results[$index]['check_price'] = true;
    }

    if ($show_description)
    {
        if ($description_type == 'short')
        {
            if ($cut_description && st_check_strlen($product->getShortDescription()) > $max_desc_length)
            {
                $results[$index]['description'] = st_truncate_text($product->getShortDescription(), $max_desc_length, '...');
            }
            else
            {
                $results[$index]['description'] = $product->getShortDescription();
            }
        }
        elseif ($description_type == 'full')
        {
            if ($cut_description && st_check_strlen($product->getDescription()) > $max_desc_length)
            {
                $results[$index]['description'] = st_truncate_text($product->getDescription(), $max_desc_length, '...');
            }
            else
            {
                $results[$index]['description'] = $product->getDescription();
            }
        }
    }

    $results[$index]['name_without_link'] = $product->getName();

    $results[$index]['link'] = st_url_for('stProduct/show?url=' . $product->getFriendlyUrl());

    $results[$index]['code'] = $product->getCode();
}

$smarty->assign("results", $results);

if ($product_group == 'MAIN_PAGE')
{
    $smarty->display('product_main.html');
}
else
{
    $smarty->display('product_group.html');
}
