<?php
use_helper('stProduct', 'stUrl');

if ($attachments)
{
   $results = array();

   foreach ($attachments as $index => $attachment)
   {
      $results[$index]['instance'] = $attachment;
      $results[$index]['icon'] = st_product_get_attachment_icon($attachment);
      $results[$index]['name'] = $attachment->getFilename();
      $results[$index]['size'] = $attachment->getFilesize(true);
      $results[$index]['description'] = $attachment->getDescription();
      $results[$index]['link'] = st_link_to(__("Pobierz"), '@stProductDownloadAttachment?folder='.$product->getAssetFolder().'&culture='.$product->getCulture().'&filename='.$attachment->getFilename());
   }

   $smarty->assign('results', $results);

   $smarty->display('product_attachment_list.html');
}
?>
