<?php

use_helper('stCurrency', 'stText', 'stProductImage', 'stUrl');

st_theme_use_stylesheet('stProduct.css');

$results = array();

$smarty->assign("show_name", $config->get('show_name_other'));

$smarty->assign("show_image", $config->get('show_image_other'));

$smarty->assign("show_price", $config->get('show_price_other'));

$smarty->assign("show_old_price", $config->get('show_old_price_other'));

$smarty->assign("show_discount", $config->get('show_discount_other'));

$smarty->assign("price_view", $config->get('price_view_other'));

$photo_max_height = st_asset_thumbnail_setting('height', 'thumb');

$cut_name = $config->get('cut_name_other');

$max_name_length = $config->get('cut_name_num_other');

foreach ($products as $index => $product)
{
    $product_url = st_url_for('stProduct/show?url=' . $product->getFriendlyUrl());

    $product_name = $product->getName();

    $results[$index]['instance'] = $product;

    if ($cut_name && st_check_strlen($product_name) > $max_name_length)
    {
        $results[$index]['name'] = "<span " . get_tooltip($product_name, 3) . ">" . content_tag('a', st_truncate_text($product_name, $max_name_length, '...'), array('href' => $product_url, 'class' => 'product_name')) . "</span>";
    }
    else
    {
        $results[$index]['name'] = content_tag('a', $product_name, array('href' => $product_url, 'class' => 'product_name'));
    }

    $results[$index]['id'] = $product->getId();

    $results[$index]['photo'] = content_tag('a', st_product_image_tag($product, 'thumb'), array('href' => $product_url));

    $results[$index]['photo_max_height'] = $photo_max_height;

    if ($product->isPriceVisible())
    {
        $results[$index]['price'] = st_currency_format($product->getPriceBrutto(true));

        $results[$index]['price_net'] = st_currency_format($product->getPriceNetto(true));

        $old_price_brutto = $product->getOldPriceBrutto(true);

        $results[$index]['check_old_price'] = $old_price_brutto != 0;

        $results[$index]['old_price'] = st_currency_format($old_price_brutto);

        $results[$index]['old_price_net'] = st_currency_format($product->getOldPriceNetto(true));

        $results[$index]['discount'] = $product->getDiscountInPercent();

        $results[$index]['basket'] = st_get_component('stBasket', 'add', array('product' => $product));

        $results[$index]['check_price'] = false;
    }
    else
    {
        $results[$index]['check_price'] = true;
    }

    $results[$index]['name_without_link'] = $product_name;

    $results[$index]['link'] = 'stProduct/show?url=' . $product->getFriendlyUrl();
}

$smarty->assign('results', $results);

$smarty->display('product_recommend_products.html');
?>