<?php
use_helper('stCurrency', 'stProductPrice', 'stTabNavigator','stText','stPhotoGallery', 'stProductImage', 'stUrl', 'stProducerImage', 'stProduct');
st_theme_use_stylesheet('stProduct.css');
st_theme_use_stylesheet('stReview.css');
st_theme_use_stylesheet('stAttachment.css');

$smarty->assign('show_image', $config->get('show_image'));


$th = st_asset_thumbnail_setting('height', 'large');

$smarty->assign('photo_dimension', "style='height:". $th . "px'");

if($themeVersion < 2)
{
   $smarty->assign('photo', link_to(st_product_image_tag($product->getDefaultAssetImage(), 'large', array('id' => 'st_product-default-image')),'@stProductShowImage?folder=' . $product->getOptImageFolderId() . '&image=' . $product->getOptImageFilename(), array('rel' => 'lightbox[product_image_gallery]', 'title' => $product->getOptImageDescription() ? $product->getOptImageDescription() : '&nbsp;',  'id' => 'st_product-default-image-link')));
}
else
{
   if($product->getDefaultAssetImage())
   {
      $smarty->assign('photo', link_to(st_product_image_tag($product->getDefaultAssetImage(), 'large', array('id' => 'st_product-default-image')),'@stProductShowImage?folder=' . $product->getOptImageFolderId() . '&image=' . $product->getOptImageFilename(), array( 'rel' => 'lightbox[product_image_gallery]', 'rel' => 'zoom_gallery', 'title' => $product->getOptImageDescription() ? $product->getOptImageDescription() : '&nbsp;',  'id' => 'st_product-default-image-link', 'class'=>'zoom_image_trigger')));

      use_javascript('photoGallery/stStartGallery.js','last');
   }
   else
   {
      $smarty->assign('photo', st_product_image_tag($product->getDefaultAssetImage(), 'large', array('id' => 'st_product-default-image')),'@stProductShowImage?folder=' . $product->getOptImageFolderId() . '&image=' . $product->getOptImageFilename(), array( 'rel' => 'lightbox[product_image_gallery]', 'rel' => 'zoom_gallery', 'title' => $product->getOptImageDescription() ? $product->getOptImageDescription() : '&nbsp;',  'id' => 'st_product-default-image-link', 'class'=>'zoom_image_trigger'));
   }
}
$smarty->assign('show_galery', $config->get('show_galery'));
$smarty->assign('photos', st_get_component("stProduct", "imageGallery", array("product" => $product)));
$smarty->assign('show_name', $config->get('show_name'));
$smarty->assign('name', $product->getName());
$smarty->assign('id', $product->getId());
$smarty->assign('show_code', $config->get('show_code'));
$smarty->assign('code', $product->getCode());
$smarty->assign('discount_type', $config->get('discount_type'));
$smarty->assign('show_discount', $config->get('show_discount'));
$smarty->assign('show_saved_price', $config->get('show_saved_price'));
$smarty->assign('saved_price_type', 'only_gross_saved');
$smarty->assign('show_discount_name', $config->get('show_discount_name'));
if (($config->get('show_producer') == 'name') ||  ($config->get('show_producer') == 'logo'))
{
  $smarty->assign('show_producer',1);  
}
else
{
   $smarty->assign('show_producer',0);  
}

if($themeVersion < 2)
{
    $smarty->assign('show_review',$config->get('show_review'));  
}

if ($producer)
{ 
    $smarty->assign('producer_instance', $producer);

    $producer_url = st_url_for('stProduct/producerList?url=' . $producer->getFriendlyUrl());

    if (($config->get('show_producer')=='logo') && ($producer->getSfAssetId()))
    {
        $smarty->assign('producer', content_tag('a',st_producer_image_tag($producer, 'thumb'),array('href' => $producer_url)));
    }
    else
    {
        $smarty->assign('producer', content_tag('a', $producer->getName(), array('href' => $producer_url, 'class' => 'product_name')));
    }

    if ($producer->getSfAssetId())
    {
       $smarty->assign('producer_logo', content_tag('a',st_producer_image_tag($producer, 'thumb'),array('href' => $producer_url)));
    }
    
    $smarty->assign('producer_name', content_tag('a', $producer->getName(), array('href' => $producer_url, 'class' => 'producer_name')));
}

$smarty->assign('show_category',$config->get('show_category'));

if ($category)
{
    $smarty->assign('main_category', $category);
}

$smarty->assign('instance', $product);
$smarty->assign('description_long', $product->getDescription());
$smarty->assign('show_short_description',$config->get('show_short_description'));

if ($product->getShortDescription())
{
    $smarty->assign("description", $product->getShortDescription());
}
else
{
    $smarty->assign("description", st_truncate_text($product->getDescription(),500,''));
}

$smarty->assign('depository', st_get_component('stDepositoryFrontend', 'depository', array('product'=>$product)));

if ($product->isPriceVisible())
{
    $smarty->assign('price_brutto', content_tag('span', st_currency_format($product->getPriceBrutto(true)), array('id' => 'st_product_options-price-brutto')));
    $smarty->assign('price_net', content_tag('span', st_currency_format($product->getPriceNetto(true)), array('id' => 'st_product_options-price-netto')));
    $smarty->assign('check_old_price', $product->getOldPriceBrutto() != 0);
    $smarty->assign('old_price_brutto', st_currency_format($product->getOldPriceBrutto(true)));
    $smarty->assign('old_price_net', st_currency_format($product->getOldPriceNetto(true)));
    $smarty->assign('basket', st_get_component('stBasket', 'add', array('product' => $product, 'info' => true)));
    $smarty->assign('check_price', false);

    if($product->hasDiscount())
    {
        $smarty->assign('discount_name', $product->getDiscountName());
        $saved_price_in_percent = $product->getDiscountInPercent();
        $smarty->assign('you_safe', true);
        $smarty->assign('price_discount', content_tag('span', st_currency_format($product->getDiscountNetto(true)), array('id' => 'st_product_options-discount-netto')));
        $smarty->assign('price_discount_percent', $saved_price_in_percent);
        $smarty->assign('price_catalogue', content_tag('span', st_currency_format($product->getPriceNetto(true, false)), array('id' => 'st_product_options-catalogue-netto')));
        $smarty->assign('price_catalogue_brutto', content_tag('span', st_currency_format($product->getPriceBrutto(true, false)), array('id' => 'st_product_options-catalogue-brutto')));
        $smarty->assign('price_discount_brutto', content_tag('span', st_currency_format($product->getDiscountBrutto(true)), array('id' => 'st_product_options-discount-brutto')));
        $smarty->assign('price_discount_percent_brutto', $saved_price_in_percent);
    }

    if ($product->getHasWholesalePrice())
    {
       $smarty->assign('retail_price_netto', st_currency_format($product->getRetailPriceNetto(true)));
       $smarty->assign('retail_price_brutto', st_currency_format($product->getRetailPriceBrutto(true)));
       $smarty->assign('has_wholesale_price', true);
    }
    else
    {
       $smarty->assign('has_wholesale_price', false);
    }
}
else
{
    $smarty->assign('check_price', true);
}

$smarty->assign('show_price',$config->get('show_price'));
$smarty->assign('show_old_price',$config->get('show_old_price') && $product->getOldPriceBrutto() != 0);
$smarty->assign('price_view',$config->get('price_view'));

$smarty->assign('product_list', st_get_tab_navigator($productList));

$smarty->assign('product_description', st_get_tab_navigator($productDescription));
$smarty->assign('show_compare', $config->get('show_compare')); 
$smarty->assignComponent('product_compare', 'stProductsCompareFrontend', 'productCompareButton', array('product' => $product));

if ($config->get('show_review'))
{
    $smarty->assignComponent('product_review', 'stReview', 'showStars', array('product'=> $product));
}

if ($sf_context->getController()->getTheme()->getVersion() >= 2)
{
   $smarty->assignComponent('product_question', 'stQuestionFrontend', 'showQuestion', array('product' => $product));
}
else
{
   $smarty->assignComponent('product_question', 'stQuestionFrontend', 'ask', array('product'=> $product, 'smarty' => $smarty));   
}

$smarty->assignComponent('product_recommend', 'stRecommendProductFrontend', 'showRecommend', array('product' => $product));

$smarty->assignComponent('product_payment_info', 'stPayment', 'showInfoInProduct', array('id' => $product->getId()));

$smarty->assignComponent('product_add_this', 'stAddThisFrontend', 'shareButtons', array('view' => 'product'));

$smarty->assign('show_weight', $config->get('show_weight'));
$smarty->assign('weight', $product->getWeight()); 
$smarty->assign('weight_unit', $config->get('weight_unit'));
$smarty->assign('stock', $product->getStock());

$smarty->display('product_show_default.html');