<?php
use_helper('Validation', 'stCaptchaGD', 'stUrl');

use_javascript('/stCategoryTreePlugin/js/jquery-1.3.2.min.js', 'first'); 
use_javascript('/stCategoryTreePlugin/js/jquery-no-conflict.js', 'first'); 
use_javascript('/js/jquery.rating.js', 'first'); 

st_theme_use_stylesheet('stReview.css');

$smarty->assign('form_start', form_tag('stReview/showAddOverlay', array('id' => 'form_stars')));

$smarty->assign('label_description', label_for('review[description]',__('Recenzja')));

$smarty->assign('input_description', textarea_tag('review[description]',  $sf_params->get('review[description]'), array('id'=>'st_form-review-description','class'=>form_has_error('review{description}') ? 'st_form-error' : '')));

$smarty->assign('label_username', label_for('review[username]',__('Podpis')));

$smarty->assign('error_username', form_error('review[username]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error')));

$smarty->assign('input_username', input_tag('review[username]',  $sf_params->get('review[username]'), array('id'=>'st_form-review-email','class'=>form_has_error('review{username}') ? 'st_form-error' : '')));

if($config->get('captcha_on', stConfig::INT)==1)
{

    $smarty->assign('captcha_on', $config->get('captcha_on', stConfig::INT)==1);

    $smarty->assign('error_captcha', form_error('captcha', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error', 'style'=>'margin-left:100px;padding:0px;')));

    $smarty->assign('get_captcha', get_captcha(328));

    $smarty->assign('label_captcha', label_for('captcha',__('Cyfry z obrazka')));

    $smarty->assign('input_captcha', input_tag('captcha', '', array('id'=>'st_form-review-captcha','class'=>form_has_error('captcha') ? 'st_form-error' : '')));
}

$smarty->assign('review_submit', submit_tag(__('Dodaj recenzję'), array('id'=>'st_button_review_add'))); 

$smarty->assign('is_authenticated', $is_authenticated); 

$smarty->assign('hidden_product_id', input_hidden_tag('product_id', $product_id));

$smarty->assign('my_star_raiting', $my_star_raiting); 


$smarty->display('review_show_add_overlay.html');
?>
<script type="text/javascript" language="javascript">
    jQuery(function ($) {
        $('#form_stars').submit(function() {
            $.post($(this).attr('action'), $(this).serialize(), function(data) { $('#star_raiting_overlay').find('.overlay_content').html(data); });

            return false;
        });

        $(document).ready(function () {
            $('.submit-star').rating({
                callback: function(value, link){

                    //   $(this.form).ajaxSubmit();
                }
            });
        });
    });
</script>

<?php if($close): ?>
    
<script type="text/javascript" language="javascript">
    jQuery(function ($) {
        $('#star_raiting_overlay').overlay().close();
        location.reload('#st_tab_navigator-product_description');

    });

</script>

<?php endif; ?>

