<?php
/** 
 * SOTESHOP/stUser 
 * 
 * Ten plik należy do aplikacji stUser opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stUser
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: components.class.php 617 2009-04-09 13:02:31Z michal $
 * @author      Bartosz Alejski <bartosz.alejski@sote.pl>
 */

/** 
 * Klasa przechowuje metody komponentu użytkownika.
 *
 * @author Bartosz Alejski <bartosz.alejski@sote.pl>
 *
 * @package     stUser
 * @subpackage  actions
 */
class stUserComponents extends sfComponents
{
    /** 
     * Zwraca aktualnego użytkownika
     *
     * @return   stUser
     */
    public function getUser()
    {
        return parent::getUser();
    }
    /** 
     * Wywołanie komponentu sprawdzającego status zalogowania użytkowniak
     */
    public function executeLoginStatus()
    {
        $this->smarty = new stSmarty('stUser');
        
        $this->showLogin = 0;
        
        if($this->getUser()->isAuthenticated())
        {
        
            $content = $this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser');
            if ($content)
            {
                $c = new Criteria();
                $c->add(sfGuardUserPeer::ID, $this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
                $user = sfGuardUserPeer::doSelectOne($c);
    
                if(is_object($user))
                {
                    $login = $user->getUsername();
                    $password = $user->getPassword();
                    
                    if($user->getExternalAccount())
                    {
                       $this->externalAccount = $user->getExternalAccount();
                    }

    
                    if($this->getUser()->checkPassword("anonymous"))
                    {
    
                        $this->showLogin = 1;
                        $this->showLoginNoPassword = $login;
                    }
                    else
                    {
                        $this->showLogin = 1;
                        $this->showLoginWithPassword = $login;
                        $this->showLogOut = 1;
                    }
                }
            }
        
        }
        
    }

    public function executeBasketLoginForm()
    {
         $this->smarty = new stSmarty('stUser');
    }

}