<?php use_helper('Validation', 'stCaptchaGD', 'stUrl'); ?>

<?php st_theme_use_stylesheet('stUser.css') ?>

<?php if(!$send_true) : ?>

    <?php $smarty->assign('not_send_true', !$send_true) ?>
    
    <?php $smarty->assign('form_start', form_tag(st_secure_url_for('stUser/remindPassword'), array('class' => 'st_form'))) ?>
    
    <?php $smarty->assign('label_email', label_for('user[email]',__('E-mail (login)'))) ?>
    
    <?php $smarty->assign('error_email', form_error('user[email]', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error'))) ?>
    
    <?php $smarty->assign('input_email', input_tag('user[email]',$sf_params->get('user[email]'), array('id'=>'st_form-user-password2','class'=>form_has_error('user{email}') ? 'st_form-error' : ''))) ?>
    
    <?php if($config->get('captcha_on', stConfig::INT)==1): ?>
    
        <?php $smarty->assign('captcha_on', $config->get('captcha_on', stConfig::INT)==1) ?>
    
        <?php $smarty->assign('error_captcha', form_error('captcha', array('suffix'=>'', 'prefix'=>'', 'class'=>'st_error'))) ?>
        
        <?php $smarty->assign('get_captcha', get_captcha()) ?>
        
        <?php $smarty->assign('label_captcha', label_for('captcha',__('Cyfry z obrazka'))) ?>
        
        <?php $smarty->assign('input_captcha', input_tag('captcha', '', array('id'=>'st_form-user-password2','class'=>form_has_error('captcha') ? 'st_form-error' : ''))) ?> 
    
    <?php endif; ?>
    
    <?php $smarty->assign('remind_submit', submit_tag(__('Przypomnij'))) ?>                        

<?php else: ?>

    <?php $smarty->assign('email_send_to', __('E-mail z linkiem do utworzenia nowego hasła został wysłany na adres:').'<b>'.$sf_params->get('user[email]').'</b>') ?>

<?php endif; ?>

<?php $smarty->assignPartial('privacy_link', 'stUser', 'privacy'); ?>

<?php $smarty->display('user_remind_password.html') ?>