<?php
/**
 * SOTESHOP/stUser 
 * 
 * Ten plik należy do aplikacji stUser opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stUser
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: actions.class.php 2671 2009-08-19 14:33:54Z bartek $
 */

/**
 * Akcje profili użytkownika 
 *
 * @author Bartosz Alejski <bartosz.alejski@sote.pl>
 *
 * @package     stUser
 * @subpackage  actions
 */
class stUserDataActions extends stActions
{

    public function executeCreateFirstUserData()
    {
        if($this->getUser()->isAuthenticated())
        {
            $this->smarty = new stSmarty($this->getModuleName());

            $user_config = stConfig::getInstance(sfContext::getInstance(), 'stUser');
            $this->show_region = $user_config->get('show_region');


            if ($this->getRequest()->getMethod() == sfRequest::POST)
            {
                $userDataBilling = $this->getRequestParameter('user_data_billing');
                $userDataDelivery = $this->getRequestParameter('user_data_delivery');

                stUser::updateUserData($userDataBilling['id'],$this->getUser()->getGuardUser()->getId(),1,1,$userDataBilling);

                if($this->getRequestParameter('different_delivery'))
                {
                    stUser::updateUserData($userDataDelivery['id'],$this->getUser()->getGuardUser()->getId(),0,1,$userDataDelivery);
                }
                else
                {
                    stUser::updateUserData($userDataDelivery['id'],$this->getUser()->getGuardUser()->getId(),0,1,$userDataBilling);
                }

                $this->redirect('stUserData/userPanel');
            }

            $userDataBilling = $this->getUserDataBillingDefault($this->getUser()->getGuardUser()->getId());
            $this->userDataBilling = $userDataBilling;

            $userDataDelivery = $this->getUserDataDeliveryDefault($this->getUser()->getGuardUser()->getId());
            $this->userDataDelivery = $userDataDelivery;


            $showDeliveryForm['checkbox'] = 0;
            $showDeliveryForm['style0'] = "none";
            $showDeliveryForm['style1'] = "margin-left: 200px;";
            $showDeliveryForm['style2'] = "margin-left: 196px;";
            $showDeliveryForm['style3'] = "width: 325px;";

            $this->showDeliveryForm = $showDeliveryForm;
        }
        else
        {
            stUser::processAuthentication();
        }
    }


    public function getUserDataBillingDefault($user_id)
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);
        $c->add(UserDataPeer::IS_DEFAULT , 1);
        $c->add(UserDataPeer::IS_BILLING , 1);
        if ($userDataBillingDefault = UserDataPeer::doSelectOne($c))
        {
            $this->user_data = $userDataBillingDefault;
        }
        else
        {
            $this->user_data = new UserData();

            $this->user_data->setSfGuardUserId($user_id);
            $this->user_data->setIsBilling(1);
            $this->user_data->setIsDefault(1);
            $this->user_data->setCountriesId(36);
        }

        $userDataBillingDefault = $this->user_data;
        return $userDataBillingDefault;
    }

    public function getUserDataDeliveryDefault($user_id)
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);
        $c->add(UserDataPeer::IS_DEFAULT , 1);
        $c->add(UserDataPeer::IS_BILLING , 0);
        if ($userDataDeliveryDefault = UserDataPeer::doSelectOne($c))
        {
            $this->user_data = $userDataDeliveryDefault;
        }
        else
        {
            $this->user_data = new UserData();

            $this->user_data->setSfGuardUserId($user_id);
            $this->user_data->setIsBilling(1);
            $this->user_data->setIsDefault(1);
            $this->user_data->setCountriesId(36);
        }

        $userDataDeliveryDefault = $this->user_data;
        return $userDataDeliveryDefault;
    }

    public function getUserDataBillingAll($user_id)
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);
        $c->add(UserDataPeer::IS_BILLING , 1);
        $userDataBillingAll = UserDataPeer::doSelect($c);

        return $userDataBillingAll;
    }

    public function getUserDataDeliveryAll($user_id)
    {
        $c = new Criteria();
        $c->add(UserDataPeer::SF_GUARD_USER_ID, $user_id);
        $c->add(UserDataPeer::IS_BILLING , 0);
        $userDataDeliveryAll = UserDataPeer::doSelect($c);

        return $userDataDeliveryAll;
    }

    public function executeUserPanel()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        if($this->getUser()->isAuthenticated())
        {

            $userDataBilling = $this->getUserDataBillingDefault($this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
            $this->userDataBilling = $userDataBilling;

            $userDataDelivery = $this->getUserDataDeliveryDefault($this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
            $this->userDataDelivery = $userDataDelivery;

        }
        else
        {
            stUser::processAuthentication();
        }
    }

    public function executeTest()
    {
        $this->getUser()->setAuthenticated(false);
        $this->redirect('stUserData/userPanel');
    }

    public function executeEditProfile()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        if($this->getUser()->isAuthenticated())
        {

            $userDataId = $this->getRequestParameter('userDataId');
            $userData = $this->getRequestParameter('user_data');
            $userDataType = $this->getRequestParameter('userDataType');
            $showEditProfileForm = $this->getRequestParameter('showEditProfileForm');
            $this->isMyUserData($userDataId);

            if(!$showEditProfileForm)
            {
                $showEditProfileForm == false;
            }

            $this->userDataId = $userDataId;
            $this->userDataType = $userDataType;
            $this->showEditProfileForm = $showEditProfileForm;

        }
        else
        {
            stUser::processAuthentication();
        }
    }

    public function executeSaveProfile()
    {
        if($this->getUser()->isAuthenticated())
        {

            $userDataId = $this->getRequestParameter('userDataId');
            $userData = $this->getRequestParameter('user_data');
            $userDataType = $this->getRequestParameter('userDataType');
            $showEditProfileForm = $this->getRequestParameter('showEditProfileForm');
           
            if($userDataType=="billing")
            {
                $isBilling = 1;
            }
            else 
            {
                $isBilling = 0;
            }
            
            if($this->hasRequestParameter('user_data_delivery'))
            {
                $userData['country'] = $this->getRequestParameter('user_data_delivery[country]');
            }
          
                        
                $c = new Criteria();
                $c->add(UserDataPeer::SF_GUARD_USER_ID, $this->getUser()->getGuardUser()->getId());
                $c->add(UserDataPeer::IS_BILLING, $isBilling);
                $c->add(UserDataPeer::IS_DEFAULT, 1);
                
                if(!UserDataPeer::doSelectOne($c))
                {
                    $userData['isDefault']=1;
                }
                
            
            if($userData['isDefault']==1)
            {
                $this->setDefaultUserData($userData['id'], $userData['isBilling']);
            }
            stUser::updateUserData($userData['id'],$this->getUser()->getGuardUser()->getId(),$userData['isBilling'],$userData['isDefault'],$userData);

            if(!$showEditProfileForm)
            {
                $showEditProfileForm == false;
            }

            $this->userDataId = $userDataId;
            $this->userDataType = $userDataType;
            $this->showEditProfileForm = $showEditProfileForm;

            $this->redirect('stUserData/editProfile?userDataType='.$userDataType.'&userDataId='.$userDataId.'&showEditProfileForm='.$showEditProfileForm);

        }
        else
        {
            stUser::processAuthentication();
        }
    }


    /**
     * Usuwanie profilu
     */
    public function executeCreateProfile()
    {

        if($this->getUser()->isAuthenticated())
        {
            $userDataType = $this->getRequestParameter('userDataType');

            $userData = stUser::updateUserData('',$this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'),$this->getUserDataTypeNumericValue($userDataType),0);

            $this->redirect('stUserData/editProfile?userDataType='.$userDataType.'&userDataId='.$userData->getId().'&showEditProfileForm=true');
        }
        else
        {
            stUser::processAuthentication();
        }
    }

    /**
     * Usuwanie profilu
     */
    public function executeDeleteProfile()
    {
        if($this->getUser()->isAuthenticated())
        {

            $userDataType = $this->getRequestParameter('userDataType');

            $c = new Criteria();
            $c->add(UserDataPeer::ID, $this->getRequestParameter('userDataId'));
            $c->add(UserDataPeer::SF_GUARD_USER_ID, $this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
            UserDataPeer::doDelete($c);

            if($this->getUserDataTypeNumericValue($userDataType)==1)
            {
                $userData = $this->getUserDataBillingDefault($this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
            }
            else
            {
                $userData = $this->getUserDataDeliveryDefault($this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
            }

            $this->redirect('stUserData/editProfile?userDataType='.$userDataType.'&userDataId='.$userData->getId());

        }
        else
        {
            stUser::processAuthentication();
        }
    }


    /**
     */
    public function setDefaultUserData($userDataId, $isBilling)
    {
        if($this->getUser()->isAuthenticated())
        {

            $con = Propel::getConnection();
            $c1 = new Criteria();
            $c1->add(UserDataPeer::SF_GUARD_USER_ID , $this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));

            if($isBilling == 1)
            {
                $c1->add(UserDataPeer::IS_BILLING, 1);
            }
            else
            {
                $c1->add(UserDataPeer::IS_BILLING, 0);
            }

            $c1->add(UserDataPeer::IS_DEFAULT, 1);

            $c2 = new Criteria();
            $c2->add(UserDataPeer::IS_DEFAULT, 0);

            BasePeer::doUpdate($c1, $c2, $con);

            $c = new Criteria();
            $c->add(UserDataPeer::SF_GUARD_USER_ID, $this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
            $c->add(UserDataPeer::ID, $userDataId);

            $userData = UserDataPeer::doSelectOne($c);

            $userData->setIsDefault(1);
            $userData->save();

        }
        else
        {
            stUser::processAuthentication();
        }
    }

    /**
     */
    public function executeSetDefaultProfile()
    {
        if($this->getUser()->isAuthenticated())
        {

            $userDataId = $this->getRequestParameter('userDataId');
            $userDataType = $this->getRequestParameter('userDataType');

            $this->setDefaultUserData($userDataId, $this->getUserDataTypeNumericValue($userDataType));

            $this->redirect('stUserData/editProfile?userDataType='.$userDataType.'&userDataId='.$userDataId);
        }
        else
        {
            stUser::processAuthentication();
        }
    }

    /**
     */
    public function getUserDataTypeNumericValue($userDataType)
    {
        if($userDataType == "billing")
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }



    /**
     * Uchwyt do walidatora tworzenia konta.
     *
     * @return   string
     */
    public function handleErrorCreateFirstUserData()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        $this->updateUserDataFromRequest();
        return sfView::SUCCESS;
    }

    protected function updateUserDataFromRequest()
    {

        $this->smarty = new stSmarty($this->getModuleName());

        $userDataBilling = new UserData();
        $userDataDelivery = new UserData();

        $userDataBillingFromRequest = $this->getRequestParameter('user_data_billing');
        $userDataDeliveryFromRequest = $this->getRequestParameter('user_data_delivery');

        $differentDelivery = $this->getRequestParameter('different_delivery');
        $createAccount = $this->getRequestParameter('create_account');
        $this->createAccount = $createAccount;

        $userDataBilling->setId($userDataBillingFromRequest['id']);
        $userDataDelivery->setId($userDataDeliveryFromRequest['id']);

        if (isset($userDataBillingFromRequest['full_name']))
        {
            $userDataBilling->setFullName($userDataBillingFromRequest['full_name']);
        }

        if (isset($userDataBillingFromRequest['address']))
        {
            $userDataBilling->setAddress($userDataBillingFromRequest['address']);
        }

        if (isset($userDataBillingFromRequest['address_more']))
        {
            $userDataBilling->setAddressMore($userDataBillingFromRequest['address_more']);
        }

        if (isset($userDataBillingFromRequest['region']))
        {
            $userDataBilling->setRegion($userDataBillingFromRequest['region']);
        }

        if (isset($userDataBillingFromRequest['code']))
        {
            $userDataBilling->setCode($userDataBillingFromRequest['code']);
        }

        if (isset($userDataBillingFromRequest['town']))
        {
            $userDataBilling->setTown($userDataBillingFromRequest['town']);
        }

        if (isset($userDataBillingFromRequest['country']))
        {
            $userDataBilling->setCountriesId($userDataBillingFromRequest['country']);
        }

        if (isset($userDataBillingFromRequest['phone']))
        {
            $userDataBilling->setPhone($userDataBillingFromRequest['phone']);
        }

        if (isset($userDataBillingFromRequest['company']))
        {
            $userDataBilling->setCompany($userDataBillingFromRequest['company']);
        }

        if (isset($userDataBillingFromRequest['vatNumber']))
        {
            $userDataBilling->setVatNumber($userDataBillingFromRequest['vatNumber']);
        }

        if (isset($userDataDeliveryFromRequest['full_name']))
        {
            $userDataDelivery->setFullName($userDataDeliveryFromRequest['full_name']);
        }

        if (isset($userDataDeliveryFromRequest['address']))
        {
            $userDataDelivery->setAddress($userDataDeliveryFromRequest['address']);
        }

        if (isset($userDataDeliveryFromRequest['address_more']))
        {
            $userDataDelivery->setAddressMore($userDataDeliveryFromRequest['address_more']);
        }

        if (isset($userDataDeliveryFromRequest['region']))
        {
            $userDataDelivery->setRegion($userDataDeliveryFromRequest['region']);
        }

        if (isset($userDataDeliveryFromRequest['code']))
        {
            $userDataDelivery->setCode($userDataDeliveryFromRequest['code']);
        }

        if (isset($userDataDeliveryFromRequest['town']))
        {
            $userDataDelivery->setTown($userDataDeliveryFromRequest['town']);
        }

        if (isset($userDataDeliveryFromRequest['country']))
        {
            $userDataDelivery->setCountriesId($userDataDeliveryFromRequest['country']);
        }

        if (isset($userDataDeliveryFromRequest['phone']))
        {
            $userDataDelivery->setPhone($userDataDeliveryFromRequest['phone']);
        }

        if (isset($userDataDeliveryFromRequest['company']))
        {
            $userDataDelivery->setCompany($userDataDeliveryFromRequest['company']);
        }


        $this->userDataBilling = $userDataBilling;
        $this->userDataDelivery = $userDataDelivery;



        if($differentDelivery == 1)
        {
            $showDeliveryForm['checkbox'] = 1;
            $showDeliveryForm['style0'] = "block";
            $showDeliveryForm['style1'] = "margin-left: 40px;";
            $showDeliveryForm['style2'] = "margin-left: 40px;";
            $showDeliveryForm['style3'] = "width: 675px;";

                        
            $this->showDeliveryForm = $showDeliveryForm;
        }
        else
        {
            $showDeliveryForm['checkbox'] = 0;
            $showDeliveryForm['style0'] = "none";
            $showDeliveryForm['style1'] = "margin-left: 200px;";
            $showDeliveryForm['style2'] = "margin-left: 200px;";
            $showDeliveryForm['style3'] = "width: 325px;";

            $this->showDeliveryForm = $showDeliveryForm;

        }
        
        if($createAccount == 1)
        {
            $showCreateAccount['checkbox'] = 1;
            $showCreateAccount['style0'] = "block";
                                    
            $this->showCreateAccount = $showCreateAccount;
        }
        else
        {
            $showCreateAccount['checkbox'] = 0;
            $showCreateAccount['style0'] = "none";
            
            $this->showCreateAccount = $showCreateAccount;

        }

    }


    public function validateCreateFirstUserData()
    {
        $error_exists = false;

        $i18n = $this->getContext()->getI18N();

        $billing = $this->getRequestParameter('user_data_billing', array());       
              
        if ($this->getRequest()->getMethod() == sfRequest::POST)
        {
            
                        
            if ($billing['company'] || $billing['vatNumber'])
            {
                if (!$billing['company']) 
                {
                    $this->getRequest()->setError('user_data_billing{company}', $i18n->__('Brak firmy.'));
                    $error_exists = true;
                }
                
                if (!$billing['vatNumber'])
                {
                    $this->getRequest()->setError('user_data_billing{vatNumber}', $i18n->__('Brak nipu.'));
                    $error_exists = true;
                }
            }
            
            if (!$billing['company'] && !$billing['vatNumber'] && !$billing['full_name'] )
            {
                $this->getRequest()->setError('user_data_billing{message}', $i18n->__('Musisz podać imię i nazwisko lub dane firmowe.'));
                $this->getRequest()->setError('user_data_billing{full_name}','');
                $this->getRequest()->setError('user_data_billing{company}','');
                $this->getRequest()->setError('user_data_billing{vatNumber}','');
                $error_exists = true;
            }
            
    
            if ($this->hasRequestParameter('different_delivery'))
            {
                $delivery = $this->getRequestParameter('user_data_delivery', array());
    
                $validator = new sfStringValidator();
                $validator->initialize($this->getContext(), array(
                'max' => 255,
                'max_error' => $i18n->__('Przekroczono dozwoloną liczbę znaków.'),
    
                ));
    
                
                if (!$delivery['company'] && !$delivery['full_name'])
                {
                    $this->getRequest()->setError('user_data_delivery{message}', $i18n->__('Musisz podać imię i nazwisko lub nazwę firmy.'));
                    $this->getRequest()->setError('user_data_delivery{full_name}','');
                    $this->getRequest()->setError('user_data_delivery{company}','');
                    $error_exists = true;
                }
    
                if (!$delivery['address'])
                {
                    $this->getRequest()->setError('user_data_delivery{address}', $i18n->__('Brak adresu.'));
                    $error_exists = true;
                }
       
                if (!$delivery['code'])
                {
                    $this->getRequest()->setError('user_data_delivery{code}', $i18n->__('Brak kodu.'));
                    $error_exists = true;
                }
    
                if (!$delivery['town'])
                {
                    $this->getRequest()->setError('user_data_delivery{town}', $i18n->__('Brak miasta.'));
                    $error_exists = true;
                }
    
                if (!$delivery['phone'])
                {
                    $this->getRequest()->setError('user_data_delivery{phone}', $i18n->__('Brak telefonu.'));
                    $error_exists = true;
                }
    
                if (!$validator->execute($delivery['full_name'], $error))
                {
                    $this->getRequest()->setError('user_data_delivery{full_name}', $error);
                    $error_exists = true;
                }
    
                if (!$validator->execute($delivery['address'], $error))
                {
                    $this->getRequest()->setError('user_data_delivery{address}', $error);
                    $error_exists = true;
                }
    
                if (!$validator->execute($delivery['code'], $error))
                {
                    $this->getRequest()->setError('user_data_delivery{code}', $error);
                    $error_exists = true;
                }
    
                if (!$validator->execute($delivery['town'], $error))
                {
                    $this->getRequest()->setError('user_data_delivery{town}', $error);
                    $error_exists = true;
                }
    
                if (!$validator->execute($delivery['phone'], $error))
                {
                    $this->getRequest()->setError('user_data_delivery{phone}', $error);
                    $error_exists = true;
                }
    
                if (!$validator->execute($delivery['vatNumber'], $error))
                {
                    $this->getRequest()->setError('user_data_delivery{vatNumber}', $error);
                    $error_exists = true;
                }
    
                if (!$validator->execute($delivery['company'], $error))
                {
                    $this->getRequest()->setError('user_data_delivery{company}', $error);
                    $error_exists = true;
                }
            }
        
        }
        

        return !$error_exists;
    }

    public function validateAddBasketUser()
    {
        $error_exists = false;

        
        $i18n = $this->getContext()->getI18N();

        $billing = $this->getRequestParameter('user_data_billing', array());
        $password1 = $this->getRequestParameter('password1');
        $password2 = $this->getRequestParameter('password2');
        $create_account = $this->getRequestParameter('create_account');      
        
        if($billing)
        {
            $c = new Criteria();
        
            $c->add(sfGuardUserPeer::USERNAME, $billing['email']);    
            $user = sfGuardUserPeer::doSelectOne($c);

            if($user)
            {           
                if(stUser::isFullAccount($billing['email']) && $user->getIsConfirm()==1 && !empty($create_account))
                {
                    $this->getRequest()->setError('user_data_billing{email}', $i18n->__('Taki adres już istnieje w bazie danych.'));
                    $error_exists = true;
                }
            }


            if (!$billing['company'] && !$billing['vatNumber'] && !$billing['full_name'] && $billing['radio_customer_type']==2)
            {
                $this->getRequest()->setError('user_data_billing{message}', $i18n->__('Musisz podać imię i nazwisko lub dane firmowe.'));
                $this->getRequest()->setError('user_data_billing{full_name}','');
                $this->getRequest()->setError('user_data_billing{company}','');
                $this->getRequest()->setError('user_data_billing{vatNumber}','');
                $error_exists = true;

                
            }

            if (!$billing['company'] && !$billing['vatNumber'] && !$billing['full_name'] && $billing['radio_customer_type']==1)
            {
                $this->getRequest()->setError('user_data_billing{message}', $i18n->__('Musisz podać imię i nazwisko.'));
                $this->getRequest()->setError('user_data_billing{full_name}','');
                $this->getRequest()->setError('user_data_billing{company}','');
                $this->getRequest()->setError('user_data_billing{vatNumber}','');
                $error_exists = true;
            }

            if (!$billing['full_name'] && $billing['radio_customer_type']==1)
            {
                $this->getRequest()->setError('user_data_billing{message}', $i18n->__('Musisz podać imię i nazwisko.'));
                $this->getRequest()->setError('user_data_billing{full_name}','');
                $error_exists = true;
            }

            if ($billing['company'] || $billing['vatNumber'])
            {
                if (!$billing['company'])
                {
                    $this->getRequest()->setError('user_data_billing{company}', $i18n->__('Brak firmy.'));
                    $error_exists = true;
                }

                if (!$billing['vatNumber'])
                {
                    $this->getRequest()->setError('user_data_billing{vatNumber}', $i18n->__('Brak nipu.'));
                    $error_exists = true;
                }
            }

                           
            if($this->hasRequestParameter('create_account'))
            {
            
                if($password1 != $password2)
                {
                    $this->getRequest()->setError('password1', $i18n->__('Hasła nie są takie same.'));
                    $error_exists = true;
                }
            
                if(!$password1)
                {
                    $this->getRequest()->setError('password1', $i18n->__('Brak hasła.'));
                    $error_exists = true;
                }
                
                if(!$password2)
                {
                    $this->getRequest()->setError('password2', $i18n->__('Brak hasła.'));
                    $error_exists = true;
                }
            }
             
        }
        else
        {
            $error_exists = true;
        }

        if ($this->hasRequestParameter('different_delivery'))
        {
            $delivery = $this->getRequestParameter('user_data_delivery', array());

            $validator = new sfStringValidator();
            $validator->initialize($this->getContext(), array(
            'max' => 255,
            'max_error' => $i18n->__('Przekroczono dozwoloną liczbę znaków.'),

            ));

                       
            if (!$delivery['company'] && !$delivery['full_name'])
            {
                $this->getRequest()->setError('user_data_delivery{message}', $i18n->__('Musisz podać imię i nazwisko lub nazwę firmy.'));
                $this->getRequest()->setError('user_data_delivery{full_name}','');
                $this->getRequest()->setError('user_data_delivery{company}','');
                $error_exists = true;
            }
            
            if (!$delivery['address'])
            {
                $this->getRequest()->setError('user_data_delivery{address}', $i18n->__('Brak adresu.'));
                $error_exists = true;
            }

            if (!$delivery['code'])
            {
                $this->getRequest()->setError('user_data_delivery{code}', $i18n->__('Brak kodu.'));
                $error_exists = true;
            }

            if (!$delivery['town'])
            {
                $this->getRequest()->setError('user_data_delivery{town}', $i18n->__('Brak miasta.'));
                $error_exists = true;
            }

            if (!$delivery['phone'])
            {
                $this->getRequest()->setError('user_data_delivery{phone}', $i18n->__('Brak telefonu.'));
                $error_exists = true;
            }

            if (!$validator->execute($delivery['full_name'], $error))
            {
                $this->getRequest()->setError('user_data_delivery{full_name}', $error);
                $error_exists = true;
            }


            if (!$validator->execute($delivery['address'], $error))
            {
                $this->getRequest()->setError('user_data_delivery{address}', $error);
                $error_exists = true;
            }

            if (!$validator->execute($delivery['region'], $error))
            {
                $this->getRequest()->setError('user_data_delivery{region}', $error);
                $error_exists = true;
            }

            if (!$validator->execute($delivery['code'], $error))
            {
                $this->getRequest()->setError('user_data_delivery{code}', $error);
                $error_exists = true;
            }

            if (!$validator->execute($delivery['town'], $error))
            {
                $this->getRequest()->setError('user_data_delivery{town}', $error);
                $error_exists = true;
            }

            if (!$validator->execute($delivery['phone'], $error))
            {
                $this->getRequest()->setError('user_data_delivery{phone}', $error);
                $error_exists = true;
            }

            if (!$validator->execute($delivery['company'], $error))
            {
                $this->getRequest()->setError('user_data_delivery{company}', $error);
                $error_exists = true;
            }

        }

        $validator = new stCaptchaGDValidator();

        $validator->initialize($this->getContext(), array('captcha_error' => 'Wprowadzono zły numer.'));

        $captcha = $this->getRequestParameter('captcha');

        if (!$validator->execute($captcha, $error))
        {
            $this->getRequest()->setError('captcha', $error);
            $error_exists = true;
        }


        return !$error_exists;
    }

    public function validateCheckBasketUser()
    {
        $error_exists = false;

        $i18n = $this->getContext()->getI18N();
        
        $billing = $this->getRequestParameter('user_data_billing', array());   
        
        $delivery = $this->getRequestParameter('user_data_delivery', array());   
                               
            if ($billing['company'] || $billing['vatNumber'])
            {
                if (!$billing['company']) 
                {
                    $this->getRequest()->setError('user_data_billing{company}', $i18n->__('Brak firmy.'));
                    $error_exists = true;
                }
                
                if (!$billing['vatNumber'])
                {
                    $this->getRequest()->setError('user_data_billing{vatNumber}', $i18n->__('Brak nipu.'));
                    $error_exists = true;
                }
            }
            
            if (!$billing['company'] && !$billing['vatNumber'] && !$billing['full_name'])
            {
                $this->getRequest()->setError('user_data_billing{message}', $i18n->__('Musisz podać imię i nazwisko lub dane firmowe.'));
                $this->getRequest()->setError('user_data_billing{full_name}','');
                $this->getRequest()->setError('user_data_billing{company}','');
                $this->getRequest()->setError('user_data_billing{vatNumber}','');
                $error_exists = true;
            }
            
                           
                       
            if (!$delivery['company'] && !$delivery['full_name'])
            {
                $this->getRequest()->setError('user_data_delivery{message}', $i18n->__('Musisz podać imię i nazwisko lub nazwę firmy.'));
                $this->getRequest()->setError('user_data_delivery{full_name}','');
                $this->getRequest()->setError('user_data_delivery{company}','');
                $error_exists = true;
            }

        return !$error_exists;
    }
    
    public function validateSaveProfile()
    {
        
        $error_exists = false;

        $i18n = $this->getContext()->getI18N();

        $user_data = $this->getRequestParameter('user_data', array());
        
        
        if($user_data['isBilling']==1)
        {
                        
          if ($user_data['company'] || $user_data['vatNumber'])
          {
             if (!$user_data['company'])
             {
                 $this->getRequest()->setError('user_data{company}', $i18n->__('Brak firmy.'));
                 $error_exists = true;
             }

             if (!$user_data['vatNumber'])
             {
                 $this->getRequest()->setError('user_data{vatNumber}', $i18n->__('Brak nipu.'));
                 $error_exists = true;
             }
          }
        }       
               
        if (!$user_data['company'] && !$user_data['vatNumber'] && !$user_data['full_name'])
        {
            $this->getRequest()->setError('user_data{message}', $i18n->__('Musisz podać imię i nazwisko lub dane firmowe.'));
            $this->getRequest()->setError('user_data{full_name}', '');
            $this->getRequest()->setError('user_data{company}', '');
            $this->getRequest()->setError('user_data{vatNumber}', '');
            $error_exists = true;
        }
                
        return !$error_exists;
    }


    /**
     * Usuwanie profilu
     */
    public function executeAddBasketUser()
    {
        if ($this->getRequest()->getMethod() == sfRequest::POST)
        {
            $this->forward('stOrder', 'confirm');
        }
    }

    /**
     * Usuwanie profilu
     */
    public function executeCheckBasketUser()
    {
        if ($this->getRequest()->getMethod() == sfRequest::POST)
        {
            $this->forward('stOrder', 'confirm');
        }
    }



    /**
     * Uchwyt do walidatora tworzenia konta.
     *
     * @return   string
     */
    public function handleErrorAddBasketUser()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        $this->updateUserDataFromRequest();
        return $this->forward('stBasket', 'index');
    }

    /**
     * Uchwyt do walidatora tworzenia konta.
     *
     * @return   string
     */
    public function handleErrorCheckBasketUser()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        return $this->forward('stBasket', 'index');
    }

    /**
     * Uchwyt do walidatora tworzenia konta.
     *
     * @return   string
     */
    public function handleErrorSaveProfile()
    {
        $this->smarty = new stSmarty($this->getModuleName());

        return $this->forward('stUserData', 'editProfile');
    }


    public function isMyUserData($userDataId)
    {
        $c = new Criteria();
        $c->add(UserDataPeer::ID, $userDataId);
        $c->add(UserDataPeer::SF_GUARD_USER_ID , $this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));
        $userData = UserDataPeer::doSelectOne($c);


        if (!$userData)
        {
            $this->forward404();
        }

    }

    public function executeAjaxProfileUpdate()
    {
        $id = $this->getRequestParameter('id');

        $type = $this->getRequestParameter('type');
        
        $params = array('defaultUserProfile' => $id);

        if ($type == 'billing')
        {
            $this->setDefaultUserData($id,$this->getUserDataTypeNumericValue($type));

            $this->responseUpdateElement('st_user-basket_billing_login_form', array('module' => 'stUserData', 'component' => 'basketLoginUserBillingForm', 'params' => $params));
        }
        else
        {
            $this->setDefaultUserData($id,$this->getUserDataTypeNumericValue($type));
            
            $this->responseUpdateElement('st_user-basket_delivery_login_form', array('module' => 'stUserData', 'component' => 'basketLoginUserDeliveryForm', 'params' => $params));
        }
        
        return $this->renderResponse(); 
    }

}
