<?php
/**
* SOTESHOP/stUser
*
* Ten plik należy do aplikacji stUser opartej na licencji (Professional License SOTE).
* Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
* Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
* oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
*
* @package     stUser
* @subpackage  actions
* @copyright   SOTE (www.sote.pl)
* @license     http://www.sote.pl/license/sote (Professional License SOTE)
* @version     $Id: components.class.php 617 2009-04-09 13:02:31Z michal $
*/

/**
* Akcje dla komponentu profili użytkownika
*
* @author Bartosz Alejski <bartosz.alejski@sote.pl>
*
* @package     stUser
* @subpackage  actions
*/
class stUserDataComponents extends sfComponents
{

    public function executeBasketUserDataProfile()
    {
        $this->smarty = new stSmarty('stUserData');

        $this->userDataType = $this->getUserDataTypeNumericValue($this->type);

        $delivery = stDeliveryFrontend::getInstance(stBasket::getInstance($this->getUser()));

        $c = new Criteria();

        if (!$this->userDataType)
        {
            if ($delivery->getDefaultDeliveryCountry())
            {
                $c->add(UserDataPeer::COUNTRIES_ID, $delivery->getDefaultDeliveryCountry()->getId());
            }
            if ($this->getUser()->getUserDataDefaultDelivery())
            {
                $this->defaultUserData =  $this->getUser()->getUserDataDefaultDelivery()->getId();
            }
        }
        else
        {
            if ($this->getUser()->getUserDataDefaultBilling())
            {
                $this->defaultUserData =  $this->getUser()->getUserDataDefaultBilling()->getId();
            }
        }

        $c->add(UserDataPeer::SF_GUARD_USER_ID, $this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'));

        $c->add(UserDataPeer::IS_BILLING, $this->userDataType);

        $c->add(UserDataPeer::FULL_NAME, null, Criteria::ISNOTNULL);



        $user_data = UserDataPeer::doSelect($c);

        $select_options = array();

        $has_default = false;

        foreach ($user_data as $ud)
        {
            $select_options[$ud->getId()] = $ud->getProfileName();

            if ($ud->getId() == $this->defaultUserProfile)
            {
                $has_default = true;
            }
        }

        if (!$has_default)
        {
            $select_options = array('' => '---') + $select_options;
        }



        $this->select_options = $select_options;


    }

    /**
    */
    public function getUserDataTypeNumericValue($userDataType)
    {
        if($userDataType == "billing")
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }


    /**
    * Zwraca obiekt zarzadzajacy zdarzeniami
    *
    * @return   stEventDispatcher
    */
    public function getDispatcher()
    {
        return stEventDispatcher::getInstance();
    }

    /**
    * Wyświetla menu panelu
    *
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    */
    public function executeUserPanelMenu()
    {
        $this->smarty = new stSmarty('stUserData');

        $this->panel_navigator = stTabNavigator::getInstance($this->getContext(), null, null, false);
        $this->panel_navigator->addTab('Moje konto', 'stUserData', 'userPanel', null, 'userPanel');
        $this->panel_navigator->addTab('Dane logowania', 'stUser', 'editAccount', null, 'editAccount');
        $this->panel_navigator->setTab($this->getActionName());
        $this->getDispatcher()->notify(new sfEvent($this, 'stUserDataComponents.postExecuteUserPanelMenu'));
    }

    public function updateUserLoginForm($user_data, $request_parameter)
    {
        $user_request = $this->getRequestParameter($request_parameter);

        if (isset($user_request['full_name']))
        {
            $user_data->setFullName($user_request['full_name']);
        }

        if (isset($user_request['address']))
        {
            $user_data->setAddress($user_request['address']);
        }

        if (isset($user_request['address_more']))
        {
            $user_data->setAddressMore($user_request['address_more']);
        }

        if (isset($user_request['region']))
        {
            $user_data->setRegion($user_request['region']);
        }

        if (isset($user_request['code']))
        {
            $user_data->setCode($user_request['code']);
        }

        if (isset($user_request['town']))
        {
            $user_data->setTown($user_request['town']);
        }

        if (isset($user_request['country']))
        {
            $user_data->setCountriesId($user_request['country']);
        }

        if (isset($user_request['phone']))
        {
            $user_data->setPhone($user_request['phone']);
        }

        if (isset($user_request['company']))
        {
            $user_data->setCompany($user_request['company']);
        }

        if (isset($user_request['vatNumber']))
        {
            $user_data->setVatNumber($user_request['vatNumber']);
        }
    }



    /**
    * Formularz billingu w koszyku dla zalogowanego użytkownika
    */
    public function executeBasketLoginUserBillingForm()
    {

        $delivery = stDeliveryFrontend::getInstance(stBasket::getInstance($this->getUser()));
        $this->smarty = new stSmarty('stUserData');

        $user_config = stConfig::getInstance(sfContext::getInstance(), 'stUser');
        $this->show_region = $user_config->get('show_region');

        if($this->getUser()->isAuthenticated())
        {
            if ($this->getRequest()->getMethod() == sfRequest::POST && $this->getRequestParameter('submit_save'))
            {
                $userDataBilling = new UserData();

                $this->updateUserLoginForm($userDataBilling, 'user_data_billing');
                
                $this->defaultUserProfile = $this->getRequestParameter('user_data_billing[id]');
            }
            else
            {

                $userDataBilling = $this->getUser()->getUserDataDefaultBilling();

                if (!$userDataBilling)
                {
                    $userDataBilling = new UserData();

                    $userDataBilling->setIsDefault(true);

                    $userDataBilling->setIsBilling(true);

                    $userDataBilling->setCountriesId($delivery->getDefaultDeliveryCountry()->getId());
                }

                if (!$this->defaultUserProfile)
                {
                    $this->defaultUserProfile = $userDataBilling->getId();
                }

            }
            $this->userDataBilling = $userDataBilling;

        }
        else
        {
            stUser::processAuthentication();
        }
    }


    /**
    * Formularz dostaw w koszyku dla zalogowanego użytkownika
    */
    public function executeBasketLoginUserDeliveryForm()
    {
        $this->smarty = new stSmarty('stUserData');

        $user_config = stConfig::getInstance(sfContext::getInstance(), 'stUser');
        $this->show_region = $user_config->get('show_region');

        if($this->getUser()->isAuthenticated())
        {

            if ($this->getRequest()->getMethod() == sfRequest::POST && $this->getRequestParameter('submit_save'))
            {
                $userDataDelivery = new UserData();

                $this->updateUserLoginForm($userDataDelivery, 'user_data_delivery');
                
                $this->defaultUserProfile = $this->getRequestParameter('user_data_delivery[id]');
            }
            else
            {
                $delivery = stDeliveryFrontend::getInstance(stBasket::getInstance($this->getUser()));


                $userDataDelivery = $this->getUser()->getUserDataDefaultDelivery();

                if(!$userDataDelivery || $delivery->getDefaultDeliveryCountry() && $delivery->getDefaultDeliveryCountry()->getId() != $userDataDelivery->getCountriesId())
                {
                    $userDataDelivery = new UserData();

                    $userDataDelivery->setIsDefault(true);

                    $userDataDelivery->setCountriesId($delivery->getDefaultDeliveryCountry()->getId());
                }

                if (!$this->defaultUserProfile)
                {
                    $this->defaultUserProfile = $userDataDelivery->getId();
                }

            }
            $this->userDataDelivery = $userDataDelivery;

        }
        else
        {
            stUser::processAuthentication();
        }
    }

    /**
    * Pobranie obejktu z danymi użytkownika
    */
    public function executeBasketUserDataForm()
    {
        $this->smarty = new stSmarty('stUserData');

        $basket = stBasket::getInstance($this->getUser());

        $delivery = stDeliveryFrontend::getInstance($basket);
        $c = new Criteria();
        $c->add(WebpagePeer::ID, 4);
        $this->webpage = WebpagePeer::doSelectOne($c);

        $this->config = stConfig::getInstance($this->getContext(), 'stSecurityBackend');

        $user_config = stConfig::getInstance(sfContext::getInstance(), 'stUser');
        $this->show_region = $user_config->get('show_region');

        if ($this->getRequest()->getMethod() == sfRequest::POST && $this->getRequestParameter('submit_save'))
        {
            $userDataBilling = new UserData();
            $userDataDelivery = new UserData();
            $user = stUser::addEmptyUser();

            $userDataBillingFromRequest = $this->getRequestParameter('user_data_billing');
            $userDataDeliveryFromRequest = $this->getRequestParameter('user_data_delivery');

            

            $userDataBilling->setId($userDataBillingFromRequest['id']);
            $userDataDelivery->setId($userDataDeliveryFromRequest['id']);

            if (isset($userDataBillingFromRequest['email']))
            {
                $user->setUsername($userDataBillingFromRequest['email']);
            }

            if (isset($userDataBillingFromRequest['full_name']))
            {
                $userDataBilling->setFullName($userDataBillingFromRequest['full_name']);
            }

            if (isset($userDataBillingFromRequest['address']))
            {
                $userDataBilling->setAddress($userDataBillingFromRequest['address']);
            }

            if (isset($userDataBillingFromRequest['address_more']))
            {
                $userDataBilling->setAddressMore($userDataBillingFromRequest['address_more']);
            }

            if (isset($userDataBillingFromRequest['region']))
            {
                $userDataBilling->setRegion($userDataBillingFromRequest['region']);
            }

            if (isset($userDataBillingFromRequest['code']))
            {
                $userDataBilling->setCode($userDataBillingFromRequest['code']);
            }

            if (isset($userDataBillingFromRequest['town']))
            {
                $userDataBilling->setTown($userDataBillingFromRequest['town']);
            }

            if (isset($userDataBillingFromRequest['country']))
            {
                $userDataBilling->setCountriesId($userDataBillingFromRequest['country']);
            }

            if (isset($userDataBillingFromRequest['phone']))
            {
                $userDataBilling->setPhone($userDataBillingFromRequest['phone']);
            }

            if (isset($userDataBillingFromRequest['company']))
            {
                $userDataBilling->setCompany($userDataBillingFromRequest['company']);
            }

            if (isset($userDataBillingFromRequest['vatNumber']))
            {
                $userDataBilling->setVatNumber($userDataBillingFromRequest['vatNumber']);
            }

            if (isset($userDataDeliveryFromRequest['full_name']))
            {
                $userDataDelivery->setFullName($userDataDeliveryFromRequest['full_name']);
            }

            if (isset($userDataDeliveryFromRequest['address']))
            {
                $userDataDelivery->setAddress($userDataDeliveryFromRequest['address']);
            }

            if (isset($userDataDeliveryFromRequest['address_more']))
            {
                $userDataDelivery->setAddressMore($userDataDeliveryFromRequest['address_more']);
            }

            if (isset($userDataDeliveryFromRequest['region']))
            {
                $userDataDelivery->setRegion($userDataDeliveryFromRequest['region']);
            }

            if (isset($userDataDeliveryFromRequest['code']))
            {
                $userDataDelivery->setCode($userDataDeliveryFromRequest['code']);
            }

            if (isset($userDataDeliveryFromRequest['town']))
            {
                $userDataDelivery->setTown($userDataDeliveryFromRequest['town']);
            }

            if (isset($userDataDeliveryFromRequest['country']))
            {
                $userDataDelivery->setCountriesId($userDataDeliveryFromRequest['country']);
            }

            if (isset($userDataDeliveryFromRequest['phone']))
            {
                $userDataDelivery->setPhone($userDataDeliveryFromRequest['phone']);
            }

            if (isset($userDataDeliveryFromRequest['company']))
            {
                $userDataDelivery->setCompany($userDataDeliveryFromRequest['company']);
            }

            if (isset($userDataDeliveryFromRequest['vatNumber']))
            {
                $userDataDelivery->setVatNumber($userDataDeliveryFromRequest['vatNumber']);
            }

            $this->userDataBilling = $userDataBilling;
            $this->userDataDelivery = $userDataDelivery;
            $this->user = $user;

            $this->password1 = $this->getRequestParameter('password1');
            $this->password2 = $this->getRequestParameter('password2');


            
            


            if ($userDataBillingFromRequest['radio_customer_type']==2)
            {
                $this->display_type = "display:block";
                $this->radio_type1_checker = 0;
                $this->radio_type2_checker = 1;
            }
            else
            {
                $this->display_type = "display:none";
                $this->radio_type1_checker = 1;
                $this->radio_type2_checker = 0;
            }
            


            $this->create_account =  $this->getRequestParameter('create_account');

            $this->different_delivery = $this->getRequestParameter('different_delivery');


        }
        else
        {

            $userDataBilling = stUser::addEmptyUserData(1,1);
            $this->userDataBilling = $userDataBilling;

            $userDataDelivery = stUser::addEmptyUserData(0,1);
            $this->userDataDelivery = $userDataDelivery;

            $user = stUser::addEmptyUser();
            $this->user = $user;

            $this->password1 = "";
            $this->password2 = "";

            $this->create_account = null;

            $this->display_type = "display:none";
            $this->radio_type1_checker = 1;
            $this->radio_type2_checker = 0;

            if ($delivery->getDefaultDeliveryCountry() && $delivery->getDefaultDeliveryCountry()->getId() != $userDataDelivery->getCountriesId())
            {
                $this->different_delivery = true;
                $userDataDelivery->setCountriesId($delivery->getDefaultDeliveryCountry()->getId());

            }
        }
    }



        /**
    * Pobranie obejktu z danymi użytkownika
    */
        public function getUserData($id)
        {
            $c = new Criteria();
            $c->add(UserDataPeer::ID , $id);
            $userData = UserDataPeer::doSelectOne($c);

            if(!$userData)
            {
                return false;
            }

            return $userData;
        }

        /**
    */
        public function executeEditProfileForm()
        {
            $this->smarty = new stSmarty('stUserData');

            $user_config = stConfig::getInstance(sfContext::getInstance(), 'stUser');
            $this->show_region = $user_config->get('show_region');

            $userDataId = $this->getRequestParameter('userDataId');
            $showEditProfileForm = $this->getRequestParameter('showEditProfileForm');
            $userDataType = $this->getRequestParameter('userDataType');

            $userData = $this->getUserData($userDataId);



            $userDataFromRequest = $this->getRequestParameter('user_data');

            $userDataDeliveryFromRequest = $this->getRequestParameter('user_data_delivery');


            if($userDataFromRequest)
            {

                $userData->setId($userDataFromRequest['id']);

                if (isset($userDataFromRequest['full_name']))
                {
                    $userData->setFullName($userDataFromRequest['full_name']);
                }

                if (isset($userDataFromRequest['address']))
                {
                    $userData->setAddress($userDataFromRequest['address']);
                }

                if (isset($userDataFromRequest['address_more']))
                {
                    $userData->setAddressMore($userDataFromRequest['address_more']);
                }

                if (isset($userDataFromRequest['region']))
                {
                    $userData->setRegion($userDataFromRequest['region']);
                }

                if (isset($userDataFromRequest['code']))
                {
                    $userData->setCode($userDataFromRequest['code']);
                }

                if (isset($userDataFromRequest['town']))
                {
                    $userData->setTown($userDataFromRequest['town']);
                }

                if (isset($userDataFromRequest['country']))
                {
                    $userData->setCountriesId($userDataFromRequest['country']);
                }

                if (isset($userDataDeliveryFromRequest['country']))
                {
                    $userData->setCountriesId($userDataDeliveryFromRequest['country']);
                }

                if (isset($userDataFromRequest['phone']))
                {
                    $userData->setPhone($userDataFromRequest['phone']);
                }

                if (isset($userDataFromRequest['company']))
                {
                    $userData->setCompany($userDataFromRequest['company']);
                }
            }

            $this->userData = $userData;
            $this->showEditProfileForm = $showEditProfileForm;
            $this->userDataType = $userDataType;


        }

        /**
    */
        public function executeEditProfileList()
        {
            $this->smarty = new stSmarty('stUserData');

            if($this->getUser()->isAuthenticated())
            {

                $userDataType = $this->getRequestParameter('userDataType');
                $showEditProfileForm = $this->getRequestParameter('showEditProfileForm');

                if($userDataType=="delivery")
                {
                    $is_billing = 0;
                }
                else
                {
                    $is_billing = 1;
                }

                $userDataAll = stUser::getUserDataAll($this->getUser()->getAttribute('user_id', null, 'sfGuardSecurityUser'),$is_billing);

                $this->userDatas = $userDataAll;
                $this->userDataType = $userDataType;
                $this->showEditProfileForm = $showEditProfileForm;

            }
            else
            {
                stUser::processAuthentication();
            }
        }

        public function executeDeliveryCountriesSelect()
        {
            $basket = stBasket::getInstance($this->getUser());
            $delivery = stDeliveryFrontend::getInstance($basket);
            $this->delivery_countries = $delivery->getDeliveryCountries(true);

            if ($this->force_default_country_id)
            {
                $this->default_delivery_country_id = $this->force_default_country_id;
            }
            else
            {
                $this->default_delivery_country_id = $delivery->getDefaultDeliveryCountry() ? $delivery->getDefaultDeliveryCountry()->getId() : $this->user_data_delivery->getCountriesId();
            }
        }



    }