<?php
/**
 * Address parser
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 * 
 * @example
 * // require_once ("stAddressParser.class.php"); // commented for Symfony, because of autoload
 * $aparser = new stAddressParser('ul. Polna 1a/2');
 * $result  = $aparser->getAddress();
 * print_r($result);
 * 
 * Array
 * (
 *     [s1] => ul. Polna 
 *     [n1] => 1a
 *     [n2] => 2
 * )
 */

/**
 * Address parser
 */
class stAddressParser
{    
    var $result=NULL;
    
    public function __construct($address)
    {
        $this->address=trim($address);
    }
    
    /**
     * Parse address
     * @param string $address
     * @return NULL
     */
    protected function parse($address)
    {   
        preg_match_all("#([0-9]+\s?[a-z]?)\s?[/|m|m\.]\s?([0-9]+\s?[a-z]?)?$#i",$address,$matches);
        if (sizeof($matches)==3)
        {
            $result=array();
            if (isset($matches[0][0])) $all=$matches[0][0]; else $all=NULL;
            $result['s1']=substr($address,0,strlen($address)-strlen($all));
            if (isset($matches[1][0])) $result['n1']=$matches[1][0]; 
            else 
            {
                preg_match("#([0-9]+\s?[a-z]?[\s]*)$#i",$result['s1'],$matches_number);
                if (! empty($matches_number[1])) 
                { 
                    $result['n1']=$matches_number[1];
                    $result['s1']=substr($result['s1'],0,strlen($result['s1'])-strlen($result['n1']));
                }
                else $result['n1']='-';
            }
            if (isset($matches[2][0])) $result['n2']=$matches[2][0];
            

            $this->result=$result;
        } else {
            $this->result['s1']=$address;
            $this->result['n1']='-';
        }
        
        return NULL;
    }
        
    /**
     * Get address
     * @return array('s1'=>street,'n1'=>street nr, 'n2'=>'house number')
     */
    public function getAddress()
    {                       
        $this->parse($this->address);
        return $this->result;            
    }    
    
}