<?php
/** 
 * SOTESHOP/stUpdate 
 * 
 * This file is the part of stUpdate application. License: (Open License SOTE) Open License SOTE. 
 * Do not modify this file, system will overwrite it during upgrade.
 * 
 * @package     stUpdate
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Open License SOTE
 * @version     $Id: stCleanInstallerCache.class.php 10048 2010-12-29 16:37:55Z michal $
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */
 
sfLoader::loadHelpers('Helper');
use_helper('I18N','Url', 'Tag'); 
use_helper('stProgressBar','Partial');
    
/** 
 * After installation configuragtion system. Progress bar class.
 *
 * @package     stUpdate
 * @subpackage  libs
 */
class stCleanInstallerCache
{   
    
    /**
     * Progress bar message
     */
    var $msg='';
    
    public function step($step)
    {           
        $opt = new stActionsFinder();
        $urls=$opt->getActionsURL('frontend','unique');
                
        if (! empty($urls[$step])) 
        {
            $this->cachePage($urls[$step]);
            $this->msg=__('Optymalizuje', null, 'stInstallerWeb').': '.$urls[$step];
            return $step+1;           
        }                           
    }       
    
    public function getMessage()
    {                
          return $this->msg;      
    }          

    public function getTitle()
    {
          return __('Konfiguracja i optymalizacja systemu', null, 'stInstallerWeb');
    }             
    
    public function close() {

        sfLoader::loadHelpers('Tag');
        sfLoader::loadHelpers('Javascript');

        $this->msg.="<script type=\"text/javascript\">document.getElementById('stSetup-install_actions').style.visibility=\"visible\";</script>";
    }                                                                                                                                            
    
    static public function getSteps()
    {
    
        $opt = new stActionsFinder();
        $urls=$opt->getActionsURL('frontend','unique');
        $actions_steps=sizeof($urls);
        return $actions_steps;
    }            
        
    /** 
     * Cache frontend pages.
     */
    private function cachePage($page)
    {                                                 
        $hostname=sfContext::getInstance()->getRequest()->getHost();
        $b = new sfWebBrowser();
        $b->get($page);
        // $res = $b->getResponseText();
    }
}
