<?php
/** 
 * SOTESHOP/stUpdate 
 * 
 * This file is the part of stUpdate application. License: (Open License SOTE) Open License SOTE. 
 * Do not modify this file, system will overwrite it during upgrade.
 * 
 * @package     stUpdate
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Open License SOTE
 * @version     $Id: stStepsInstaller.class.php 16358 2011-12-02 11:12:06Z michal $
 */
 
/** 
 * stInstallerFrontendWeb PEAR Frontend class
 *
 * @package     stUpdate
 * @subpackage  libs
 */
require_once (sfConfig::get('sf_app_module_dir').DIRECTORY_SEPARATOR.'stInstallerWeb'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'stInstallerFrontendWeb.class.php');

/** 
 * Klasa stStepsInstaller
 *
 * @author Michal Prochowski <michal.prochowski@sote.pl>
 *
 * @package     stUpdate
 * @subpackage  libs
 */
class stStepsInstaller
{
    /** 
    * Message.
    * @var string
    */
	protected $msg = "";

    /** 
    * Get packages list.
    *
    * @return   string
    */
	static public function getPackagesListFilename()
	{
		return sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."install".DIRECTORY_SEPARATOR."db".DIRECTORY_SEPARATOR.".packages.reg";
	}

    /** 
    * Get number of progress bar steps.
    *
    * @return   integer
    */
	public static function getSteps()
	{
		$file = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."install".DIRECTORY_SEPARATOR."db".DIRECTORY_SEPARATOR.".packages.reg";

		if (file_exists($file)){
			$packageList = unserialize(file_get_contents($file));
			if(is_array($packageList)) return count($packageList);
		} else {
			$stStepsInstaller = new stStepsInstaller();
			$stStepsInstaller->init();
			 
			$packageList = unserialize(file_get_contents($file));
			if(is_array($packageList)) return count($packageList);
		}
		return 0;
	}

    /** 
     * Init progress bar.
     */
	public function init()
	{
		if (! file_exists($this->getPackagesListFilename()))
		{
			$upgradeType = $this->getUpgradeType();

			$peari = stPearInfo::getInstance();
			$channel = $peari->getDefaultChannel();
            

			if ((isset($upgradeType['type'])) && ($upgradeType['type'] == "package"))
			{
				$stChiaraPearServer = new stChiaraPearServer($channel);
				$stChiaraPearServer->setOption('dependency', 'latest');
				$deps = $stChiaraPearServer->getDeps($upgradeType['package'], $upgradeType['version']);
			} else {
				ob_start();
				$installer_web = new stInstallerFrontendWeb();
				$installer_web->command('list-upgrades');
				$content = ob_get_clean();
				$content = stPearFrontendWeb::getPearResult($content);
				$deps = array();

				foreach($content as $package)
				{
					$version = explode(" ", $package['version']);
					$deps[$package['name']] = $version[0];
				}

				$deps = $this->getDepsFor($deps, $channel);
			}
			
			ob_start();
            $installer_web = new stInstallerFrontendWeb();            
            $installer_web->command('list');
            $installedApps = ob_get_clean(); 
            $installedAppsArray = stPearFrontendWeb::getPearResult($installedApps);
                        
            $newDeps = $deps;            
            
            foreach ($deps as $name => $version)
            {
                foreach($installedAppsArray as $iName => $iVersion)
                {
                    if ($name == $iName && $version == $iVersion)
                    {
                        unset($newDeps[$name]);
                    }
                }
            }

            if (! empty($newDeps))
            {
			    file_put_contents($this->getPackagesListFilename(),serialize($newDeps));
		    } else
		    {
		        // called get packages with no available packages
		        // do nothing (don't create .package.reg file, because it block install and rescure actions)
		    }
		}
	}
	
	/**
	 * Check $this->getPackagesListFilename() and unlock downloads.
	 * If lock file is empty or all applications are installed unlock it (force).
	 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl> 
	 * @return      NULL
	 */
	static public function unlockPackagesListFile()
	{
	    $packagesreg=stStepsInstaller::getPackagesListFilename();
	    if (! file_exists($packagesreg)) return NULL;
	    
	    $dataraw=file_get_contents($packagesreg);
	    $data=unserialize($data);$unlock=false;
	    if (is_array($data))
	    {
            if (empty($data)) $unlock=true;
            else
            {
                $unlock=true;
	            foreach ($data as $package=>$installed)
	            {
	                if ($installed!='installed') $unlock=false;
	            }
            }
	    } else 
	    {
	        $unlock=true;
	    }
	    
	    if ($unlock) unlink($packagesreg);
	    return NULL;
	}

	public function getDepsFor($packages = array(), $channel = '') {
		$content = "deps=".serialize($packages);
		$ch = curl_init();
		
		if (stDevelState::isBeta()) $depsphp='deps_beta.php';
		else $depsphp="deps_stable.php";
		
		curl_setopt($ch, CURLOPT_URL, "http://".$channel."/".$depsphp);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $content);
		$data = curl_exec($ch);
		curl_close($ch);
		return unserialize($data);
	}

    /** 
     * Funkcja kończąńca działanie paska postępu
     */
    public function close()
    {
        unlink($this->getPackagesListFilename());
        $i18n = sfContext::getInstance()->getI18N();     
        $message1="Aktualizaje zostały pobrane";
        $message2=$this->activationButton();

        $this->msg = $i18n->__($message1, null, 'stInstallerWeb').$message2;
	}
	
	/**
	 * Activation button
	 * @return string HTML with button
	 */
	protected function activationButton()
	{
        $i18n = sfContext::getInstance()->getI18N();
        $request=sfContext::getInstance()->getRequest();
        $hostname = $request->getHost();
        if ($request->isSecure()) $protocol='https';
        else $protocol='http';

        if (SF_ENVIRONMENT=='dev') $update_script=$protocol.'://'.$hostname.'/update_dev.php';
            else $update_script=$protocol.'://'.$hostname.'/update.php';
	    $message2='<div style="float: right">
                     <ul style="float:right" class="st_admin-actions">         
                         <li class="st_admin-action-add">
                            <div>
                               <div>
                                  <form method="post" class="button_to" action="'.$update_script.'/installerweb/syncList">
                                     <div>
                                         <input style="background-image: url(/images/update/icons/add.png)" value="'.$i18n->__('Instaluj pobrane aktualizacje', null, 'stInstallerWeb').'" type="submit" />
                                     </div>
                                  </form>
                               </div>
                             </div>
                         </li>           
                     </ul>
                     <br class="st_clear_all" />                    
                 </div>';
        return $message2;
	}

    /** 
    * Install package.
    *
    * @param                   $step       int                 krok
    * @return  integer     numer kolejnego kroku
    */
    public function install($step = 0)
    {                   
        // if (! stRegisterUpdate::check()) return $step+1;
    
    	$packageArray = $this->getPackageForStep($step);
    	if ($packageArray !== null)
    	{
            list($package, $version) = $packageArray;
        
            $peari = stPearInfo::getInstance();
            $channel = $peari->getDefaultChannel();
        
            ob_start();
            $installer_web = new  stInstallerFrontendWeb();
            // $installer_web->command('upgrade',array("$channel/$package-$version"), array('forced' => true, 'nodeps' => true));
            $installer_web->command('upgrade',array("$channel/$package-$version"), array('nodeps' => true));
            $content1 = ob_get_clean();
            $content2 = stPearFrontendWeb::getPearResult($content1,'raw');
            if (is_array($content2))
            {
                $content2=print_r($content_2,true);
            }
        
            $logFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."log".DIRECTORY_SEPARATOR."webinstaller.log";
            $fh = fopen($logFile, 'a+');
            fwrite($fh, date('Y/m/d H:i:s').' '."$channel/$package-$version ".$content1."\n");
            fwrite($fh, date('Y/m/d H:i:s').' '."$channel/$package-$version ".$content2."\n");
            fclose($fh);
        
        
            $i18n = sfContext::getInstance()->getI18N();
            $nextPackageArray = $this->getNextPackage();
            if ($nextPackageArray !== null)
    		{
    			list($nextPackage, $nextVersion) = $nextPackageArray;
            	$this->msg = $i18n->__('Pobieranie', null, 'stInstallerWeb').': '.$nextPackage.' '.$nextVersion;
    		} else {
    			$this->msg = $i18n->__('Kończenie pobierania plików', null, 'stInstallerWeb');
    		}
        
            // $this->mvPearData2Root($package);
            $this->setInstalled($package);   		

    		return $step+1;
    	} else {
    		return $this->getSteps();
    	}
    }

    /** 
    * Get package information.
    *
    * @param   $step       int                 numer kroku
    * @return   array
    */
	private function getPackageForStep($step)
	{
		$packageList = unserialize(file_get_contents($this->getPackagesListFilename()));

		foreach ($packageList as $package => $version)
		{
			if ($version != "installed") return array($package, $version);
		}
		return null;
	}
	
    /** 
    * Get package information.
    *
    * @param   $step       int                 numer kroku
    * @return   array
    */
	private function getNextPackage()
	{
		$packageList = unserialize(file_get_contents($this->getPackagesListFilename()));

		$next = false;
		foreach ($packageList as $package => $version)
		{
			if ($version != "installed" && $next == true) return array($package, $version); 
			if ($version != "installed") $next = true;
		}
		return null;
	}	

    /** 
    * Message. Step title.
    *
    * @return   string
    */
	public function getMessage()
	{                           
        // if (stRegisterUpdate::check())
        // {        
		return $this->msg;
        // } else {
            // return stRegisterUpdate::getMessage();
        // }
	}
	
    /** 
     * Get title for progress bar.
     *
     * @return   string
     */
    public function getTitle()
    {
         $i18n = sfContext::getInstance()->getI18N();
         // return $i18n->__('Pobieranie aktualizacji').': ';
         return ' ';
    }
    
    /** 
     * Move PEAR (role=data) files from install/src/stAppName/stAppname to install/src/stAppName/*
     *
     * @param   $package    package             name eg. stAppName
     * @deprecated 
     */
    protected function mvPearData2Root($package)
    {            
        return true;
    }
    

    /** 
    * Set package as installed.
    *
    * @param   string      $package            package name
    */
	public function setInstalled($package)
	{
		$packageList = unserialize(file_get_contents($this->getPackagesListFilename()));
		$packageList[$package] = "installed";
		file_put_contents($this->getPackagesListFilename(),serialize($packageList));
		
	}

    /** 
    * Set upgrade type.
    *
    * @param   $upgradeType all|package
    * @param   $package    nazwa               pakietu np. stBase
    * @param   $version    wersja              pakietu np. 1.0.20
    */
	public static function setUpgradeType($upgradeType, $package = '', $version = '')
	{
		$file = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."install".DIRECTORY_SEPARATOR."db".DIRECTORY_SEPARATOR.".upgrade_type.reg";

		if ($upgradeType == "package" && (empty($package) || empty($version)))
		{
			throw new Exception("You must set package and version.");
		}

		$content = array('type' => $upgradeType, 'package' => $package, 'version' => $version);

		file_put_contents($file, serialize($content));
	}

    /** 
    * Get information about upgrade type.
    *
    * @see $this->setUpgradeType
    * @return   array
    */
	public static function getUpgradeType()
	{
		$file = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."install".DIRECTORY_SEPARATOR."db".DIRECTORY_SEPARATOR.".upgrade_type.reg";
		$content = array();

		if (file_exists($file))
		{
			$content = unserialize(file_get_contents($file));
			unlink($file);
		}
		
		return $content;
	}
}
