<?php
/**
 * SOTESHOP/stUpdate
 *
 * This file is the part of stUpdate application. License: (Open License SOTE) Open License SOTE.
 * Do not modify this file, system will overwrite it during upgrade.
 *
 * @package     stUpdate
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Open License SOTE
 * @version     $Id: stStepsSetup.class.php 11116 2011-02-17 11:28:53Z marek $
 */

/**
 * Setup
 *
 * @package     stUpdate
 * @subpackage  libs
 */
class stStepsSetup extends stStepsInstaller {

	public function close() {

		parent::close();

		sfLoader::loadHelpers('Tag');
		sfLoader::loadHelpers('Javascript');

		$this->msg.="<script type=\"text/javascript\">document.getElementById('stSetup-download_actions').style.visibility=\"visible\";</script>";

	}


    public function getTitle()
    {
        $i18n = sfContext::getInstance()->getI18N();
        return $i18n->__('Pobieranie aplikacji', null, 'stInstallerWeb').': ';
    }

    public function getFatalMessage()
    {
    	sfLoader::loadHelpers('Tag');
    	sfLoader::loadHelpers('I18N');
    	sfLoader::loadHelpers('Url');
        sfLoader::loadHelpers('stUpdate');
    	
    	return __('Wystąpił błąd podczas pobierania oprogramowania', null, 'stSetup').' '.st_program_name().', '.__('większość problemów można rozwiązać korzystając z', null, 'stSetup').
    		' <strong>'.link_to(__('podręcznika instalacji', null, 'stSetup'), __('http://www.sote.pl/trac/wiki/doc/soteshop_installation', null, 'stSetup'),array('target'=>'_blank')).'</strong>';
    }
    
	/**
	 * Activation button
	 * @return string HTML with button
	 */
	protected function activationButton()
	{
	    // do not show activation button in installation
	    return NULL;
    }
    
}