<?php
/** 
 * SOTESHOP/stUpdate 
 * 
 * This file is the part of stUpdate application. License: (Open License SOTE) Open License SOTE. 
 * Do not modify this file, system will overwrite it during upgrade.
 * 
 * @package     stUpdate
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Open License SOTE
 * @version     $Id: stUpdateConfig.class.php 3160 2010-01-26 13:30:27Z marek $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/** 
 * Configuration.
 *
 * @package     stUpdate
 * @subpackage  libs
 */
class stUpdateConfig
{
    /** 
     * Bool
     */
    const BOOL = false;

    /** 
     * Integer
     */
    const INT = 0;

    /** 
     * String
     */
    const STRING = '';

    protected $moduleName = '';
    protected $vars = array();
    protected $config = array();
    
    /** 
     * Instance of class sfContext
     * @var sfContext
     */
    protected $context = null;
    
    /** 
     * Instance of class stBasket
     * @var stBasket object
     */
    protected static $instance = null;

    /** 
     * Return object instance:
     * Example:
     * stConfig::getInstance($this->getContext(), array('param1'=>stConfig::INT_TYPE, 'param2' => stConfig::BOOL_TYPE))
     *
     * @param   string      $context            Instance of class sfContext
     * @param   array       $vars               Parameter list saved in configuration (deprecated)
     * @param   string      $module_name        Module name. If doesn't provided, set module name which initialized stConfig.
     * @return   stConfig
     */
    public static function getInstance($context, $vars = null, $module_name = null)
    {
        // temporary hack - compatibility with previous versions
        if (is_string($vars))
        {
            $module_name = $vars;
            $vars = null;
        }

        if (is_null($module_name))
        {
            $module_name = $context->getModuleName();
        }

        if (!isset(self::$instance[$module_name]))
        {
            $class = __CLASS__;
            self::$instance[$module_name] = new $class();
        }

        self::$instance[$module_name]->initialize($context, $vars, $module_name);

        return self::$instance[$module_name];
    }

    /** 
     * Configuration initialization.
     *
     * @param   string      $context            Instance of class sfContext
     * @param   array       $vars               Parameter list saved in configuration (deprecated)
     * @param   string      $module_name        Module name. If doesn't provided, set module name which initialized stConfig.
     */
    public function initialize($context, $vars = null, $module_name = null)
    {
        $this->context = $context;

        if ($vars)
        {
            $this->vars = $vars;
        }

        $this->moduleName = $module_name;

        $this->load();
    }

    /** 
     * Save configuration.
     */
    public function save()
    {
        $module_config_file = sfConfig::get('sf_data_dir') . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . '__' . $this->moduleName . '.yml';

        $this->config = $this->fixYaml($this->config);

        $config_data['all']['.auto_generated']['config']['last_modified'] = date('Y/m/d H:i:s');
        $config_data['all']['.auto_generated']['config']['fields'] = $this->config;

        file_put_contents($module_config_file, sfYaml::dump($config_data));
    }

    public function fixYaml($data = array())
    {
        foreach ($data as $var => $value)
        {
            if (is_array($value))
            {
                $data[$var] = $this->fixYaml($value);
            }
            else
            {
                $data[$var] = '"' . $value . '"';
            }
        }

        return $data;
    }

    /** 
     * Read configurations and return them in array data type.
     *
     * @deprecated beta-2
     * @return   array
     */
    public function load()
    {
        if ($this->isEmpty())
        {
            $module_config_file = sfConfig::get('sf_data_dir') . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . '__' . $this->moduleName . '.yml';

            $config = sfYaml::load($module_config_file);

            $this->config = isset($config['all']) && is_array($config['all']['.auto_generated']['config']['fields']) ? $config['all']['.auto_generated']['config']['fields'] : array();

        }

        return $this->config;
    }

    /** 
     * Configuration parameters not set.
     *
     * @return   bool
     */
    public function isEmpty()
    {
        return empty($this->config);
    }

    /** 
     * Set parameter in configuration.
     *
     * @param   string      $var                Parameter name.
     * @param                mixed       $value              Value
     * @return  bool        If parameter is set return 'true', if not return 'false'
     */
    public function set($var, $value)
    {
        $this->config[$var] = $value;
    }

    /** 
     * Get parameter from configuration.
     *
     * @param   string      $var                Parameter name.
     * @param   const       $type               Value in proper type.
     * @return  mixed       if parameter is not set return 'null'.
     */
    public function get($var, $type = null)
    {
        if (isset($this->config[$var]) && !empty($this->config[$var]))
        {
            return $this->config[$var];
        }

        if (is_null($type) && isset($this->config[$var]) && is_numeric($this->config[$var]))
        {
            $type = self::INT;
        }
        elseif (is_null($type))
        {
            $type = self::STRING;
        }

        return $type;
    }

    /** 
     * Overwrite configuration with parameters from request.
     *
     * @param            string      $parameter          Parameter.
     */
    public function setFromRequest($parameter)
    {
        $request = $this->context->getRequest();

        $data = $request->getParameter($parameter, array());

        $vars = array_merge($this->config, $data);

        foreach ($vars as $key => $value)
        {
            $this->set($key, isset($data[$key]) ? $data[$key] : '');
        }
    }

    /** 
     * Read configuration form provided application/module.
     *
     * @deprecated beta-2
     * @param   string      $module_name        Module name/application name.
     * @return  array       Configuration data array.
     */
    public static function getConfig($module_name)
    {
        include (sfConfigCache::getInstance()->checkConfig(sfConfig::get('sf_data_dir') . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . $module_name . '.yml'));

        /** 
         * @todo hack, refactoring needed
         */
        $config = sfConfig::get('st_module_config');
        sfConfig::set('st_module_config', null);
        sfConfig::set($module_name, $config['fields']);

        return $config['fields'];
    }
}