<?php
/**
 * SOTESHOP/stUpdate
 *
 * This file is the part of stUpdate application. License: (Open License SOTE) Open License SOTE.
 * Do not modify this file, system will overwrite it during upgrade.
 *
 * @package     stUpdate
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Open License SOTE
 * @version     $Id: actions.class.php 14918 2011-09-01 12:53:50Z michal $
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */

// define ("ST_MIN_EXECUTION_TIME",20);       // minimalny czas potrzebny do wykonania aktualizacji
// define ("ST_MIN_EXECUTION_TIME_APP",0.1);  // minimalny dodatkowy czas aktualizacji 1 pakietu

/**
 * stInstallerWeb actions.
 *
 * @author Marek Jakubowicz <marek.jakubowicz@sote.pl>
 *
 * @package     stUpdate
 * @subpackage  actions
 */
class stInstallerWebActions extends sfActions
{

	/**
	 * Executes index action
	 */
	public function executeIndex()
	{
		$server = new stNewServer();
		if ($server->newServer())
		{
			$this->redirect('installerweb/newServer');
		} else
		{
			$this->redirect('installerweb/news');
		}
	}

	/**
	 * Execute newServer action
	 */
	public function executeNewServer()
	{
		$pakeweb = new stPakeWeb();
		$pakeweb->run('cc');
		$server = new stNewServer();
		$server->update();
	}

	/**
	 *  List of installed applications.
	 */
	public function executeList()
	{
		$regsync = new stRegisterSync();
		$this->content=$regsync->getSynchronizedApps();
	}

	/**
	 * List of PEAR installer applications.
	 */
	public function executeListpear()
	{
		ob_start();

		$installer_web = new stInstallerFrontendWeb();
		$installer_web->command('list');

		$content = ob_get_clean();
		$this->content = stPearFrontendWeb::getPearResult($content);


	}

	// /**
	//  * Executes install action
	//  * @deprecated
	//  */
	// public function executeInstall()
	// {
	//     $this->tests = new stCheckRequirements();
	//     if (!$this->tests->testAll()) {$this->redirect('stInstallerWeb/requirements');}
	//  stRegisterSync::fixmd5sum();
	//
	//     $channel=$this->getRequestParameter('channel');
	//     $package=$this->getRequestParameter('package');
	//
	//     ob_start();
	//
	//     $installer_web = new stInstallerFrontendWeb();
	//     $installer_web->command('install',array("$channel/$package"));
	//
	//     $content = ob_get_clean();
	//     $content=stPearFrontendWeb::getPearResult($content);
	//
	//     // fix bledu PEAR : in PEAR result <div> is not closed, fix it
	//     if (ereg("\<div\>$",$content)) $content=preg_replace("/\<div\>$/","</div>",$content);
	//
	//     $this->content=$content;
	// }

	public function executeRequirements() {
		$this->tests = new stCheckRequirements();
		$this->testsPassed = $this->tests->testAll();
		$this->testsStatus = $this->tests->getTest();
		$this->hasWarning = false;
	}

	/**
	 * Executes updatelist action
	 * If list contain stUpdate, show only stUpdate.
	 */
	public function executeUpgradeList()
	{
		// check if this action is embeded
		$ajax=$this->getRequestParameter('ajax');
		if (! empty($ajax))
		{
			$this->ajax_num=0;
			$this->setLayout(false);
			$this->setTemplate('upgradeListAjax');
		}

		if (!$this->getRequest()->hasParameter('ajax')) {
			$this->tests = new stCheckRequirements();
			if (!$this->tests->testAll()) {$this->redirect('stInstallerWeb/requirements');}
		}

		ob_start();

		$installer_web = new stInstallerFrontendWeb();
		$installer_web->command('list-upgrades');

		$content = ob_get_clean();
		$content=stPearFrontendWeb::getPearResult($content);

		if (is_array($content)) $this->upgrade=true;
		else
		{
			$this->content=array();
			$this->upgrade=false;
		}

		// $this->upgrade=true; // tmp

		// jesli jednym z apkietow jest stUpdate, to nie pokazuj innych
		$this->installerweb=false;    // czy w pakietach do aktualizacji jest stWebInstallerPlugin
		$installer_web=false;
		if ($this->upgrade==true)
		{
			foreach ($content as $id=>$data)
			{
				if ($data['name']=='stUpdate')
				{
					$installer_web=true;
					$installer_id=$id;
				}
			}

			if ($installer_web)
			{
				$this->installerweb=true;
				$content=array(0=>$content[$installer_id]);
			}
			// end

			if (! empty($ajax))
			{
				$this->ajax_num=sizeof($content);
			}
		}

			

		$this->content=$content;


		// apps which are waiting for sync
		$regsync = new stRegisterSync();
		$apps_sync=$regsync->getAppsToSync();
		$this->sync_apps=$apps_sync['all'];

		// if stUpdate is one the sync list, don't show other upgrades on the list
		$installer_web_sync=false;
		foreach ($apps_sync['all'] as $id=>$name)
		{
			if ($name=='stUpdate')
			{
				$installer_web_sync=true;
			}
		}
			
		if ($installer_web_sync)
		{
			$this->content=array();
		}

	}

	/**
	 * Executes upgrade action
	 *
	 * @param   bool        $all                true - upgrade all available packages, false - upgrade packages dependency for 1 package
	 */
	public function executeUpgrade($all=false)
	{
		stRegisterSync::fixmd5sum();                  // 5.0.1 fix dodaje baze md5sum
		$app_download='__DOWNLOAD__';
		$app_updated='__UPDATED__';
		$app_nothing2upgrade='__NOTHING2UPGRADE__';

		$channel=$this->getRequestParameter('channel');
		$package=$this->getRequestParameter('package');

		ob_start();

		$installer_web = new stInstallerFrontendWeb();
		if ($all)    $installer_web->command('upgrade-all',array("$channel/$package"));         // upgrade all available packages
		else         $installer_web->command('upgrade',array("-fn","$channel/$package"));       // upgrade 1 package
			
		$content = ob_get_clean();
		$content = stPearFrontendWeb::getPearResult($content,'raw');

		// prese PEAR messages
		$messages=preg_split("/\n/",$content); $apps=array(); $result='';
		foreach ($messages as $line)
		{
			if (ereg("Starting to download",$line))  $apps[]=ereg_replace('Starting to download',$app_download,$line);
			if (ereg("upgrade ok",$line)) $result=$app_updated;
			if (ereg("Nothing to upgrade",$line)) $result=$app_nothing2upgrade;
		}
		$this->apps=$apps;
		$this->result=$result;
	}

	/**
	 * Upgrade all available packages.
	 */
	public function executeUpgradeAll()
	{
		$this->executeUpgrade(true);
	}

	/**
	 * Application list for synchronization.
	 */
	public function executeSyncList()
	{
		// check if this action is embeded
		$ajax=$this->getRequestParameter('ajax');
		if (! empty($ajax))
		{
			$this->setLayout(false);
			$this->setTemplate('syncListAjax');
		}

		if (!$this->getRequest()->hasParameter('ajax')) {
			$this->tests = new stCheckRequirements();
			if (!$this->tests->testAll()) {$this->redirect('stInstallerWeb/requirements');}
		}

		$regsync = new stRegisterSync();
		$apps_sync=$regsync->getAppsToSync();
		$this->apps=$apps_sync;
		$this->ajax_num=sizeof($this->apps['all']); // menu info


		$this->linkToDownloadPackage = false;
		if (!$this->checkPackageRegFile())
		{
			$this->linkToDownloadPackage = true;
			$this->ajax_num=0; // menu info
		}
	}

	/**
	 * Reboot.
	 *
	 * @param   bool        $check              true - verify number packahes for upgrade, false - do not verify
	 */
	public function executeReboot($check=true)
	{
		$this->tests = new stCheckRequirements();
		if (!$this->tests->testAll()) {$this->redirect('stInstallerWeb/requirements');}
			
		// Zweryfikuj czas potrezbny do wykonania akcji
		// Pobierz ilosc aplikacji do instalacji
		$regsync = new stRegisterSync();
		$apps_sync=$regsync->getAppsToSync();
		$npkg=sizeof($apps_sync['all']);
		if ((! $npkg>0) && ($check)) $this->redirect('installerweb');

		// deprecated
		// $time = new stServerExecutionTime();
		// $time->setMax(($npkg*ST_MIN_EXECUTION_TIME_APP)+ST_MIN_EXECUTION_TIME);
		// if ($time->check())
		// {
		//     $this->time=true;
		// } else {
		//     $this->time=false;
		//     $this->time_server=$time->getServerTime();
		//     $this->time_min=$time->getMax();
		// }
		$this->time=true;  // added for previous versions of template

		$this->linkToDownloadPackage = false;
		if (!$this->checkPackageRegFile()) $this->linkToDownloadPackage = true;
	}

	/**
	 * Rescue.
	 */
	public function executeRescue()
	{
		$this->tests = new stCheckRequirements();
		if (!$this->tests->testAll()) {$this->redirect('stInstallerWeb/requirements');}

		// force unlock downloads
		stStepsInstaller::unlockPackagesListFile();

		if (stLockUpdate::isLocked())
		{
			$this->executeReboot(false);
			$this->setTemplate('reboot');
		} else
		{
			$this->redirect('stInstallerWeb/news');
		}
		// $this->executeReboot(false);
		// $this->setTemplate('reboot');
	}

	/**
	 * Rescure Reboot.
	 */
	public function executeRescueReboot()
	{
		$this->tests = new stCheckRequirements();
		if (!$this->tests->testAll()) {$this->redirect('stInstallerWeb/requirements');}

		// if (stLockUpdate::isLocked())
		//      {
		$this->executeReboot(false);
		$this->setTemplate('reboot');
		// } else
		// {
		// $this->redirect('stInstallerWeb/news');
		// }
	}

	/**
	 * Synchronize downloaded applications.
	 */
	public function executeSync()
	{
		$regsync = new stRegisterSync();
		$apps_sync=$regsync->getAppsToSync();

		// application list for synchronization
		$this->apps=$apps_sync;

		$installer = new stInstaller('web');
		$ui = new stInstallerOutputWeb();
		$installer->setOutputObject($ui);


		if (! empty($apps_sync['all']))
		{

			// synchornize
			$installer->sync($apps_sync['all'],'Synchronization ('.sizeof($apps_sync['all']).')');
		}
		else {
			// nothing to do
		}
	}

	/**
	 * Code verification.
	 * Find user unautorized modifications.
	 */
	public function executeVerify()
	{
		$this->tests = new stCheckRequirements();
		if (!$this->tests->testAll()) {$this->redirect('stInstallerWeb/requirements');}

		$regsync = new stRegisterSync();
		$apps_sync=$regsync->getAppsToSync();

		$this->apps=array_merge($apps_sync['changed'],$apps_sync['added']);

		$npkg_all=sizeof($apps_sync['all']);
		$npkg_changed=sizeof($this->apps);
		$npkg_del=sizeof($apps_sync['deleted']);

		$this->npkg=$npkg_changed;

		if (! $npkg_all>0) {
			$this->redirect('installerweb');
		}

		$this->linkToDownloadPackage = false;
		if (!$this->checkPackageRegFile()) $this->linkToDownloadPackage = true;
	}

	/**
	 * Symfony Web task execution.
	 */
	public function executeTask()
	{
		$this->task=$this->getRequestParameter('task');
		$this->content='';
		$this->error='';

		if (! empty($this->task))
		{
			$pakeweb = new stPakeWeb();
			$pakeweb->run($this->task);
			$this->content=$pakeweb->content;
			$this->error=$pakeweb->error;
		}

	}

	/**
	 * Symfony cc
	 */
	public function executeCc()
	{
		$pakeweb = new stPakeWeb();
		$pakeweb->run('cc');
		$this->content=$pakeweb->content;
		$this->error=$pakeweb->error;
	}

	/**
	 * Upgrade provided Applications.
	 */
	public function executeUpgradeBySteps()
	{
		if (!$this->getRequestParameter('package') || !$this->getRequestParameter('version'))
		{
			$this->redirect('stInstallerWeb/upgradeList');
		} else {
			$package = $this->getRequestParameter('package');
			$version = $this->getRequestParameter('version');
			stStepsInstaller::setUpgradeType('package', $package, $version);
		}
	}

	/**
	 * Upgrade all applications.
	 */
	public function executeUpgradeAllBySteps()
	{
		stStepsInstaller::setUpgradeType('all');
	}

	public function executeListUpgrade()
	{
		ob_start();
		$installer_web = new stInstallerFrontendWeb();
		$installer_web->command('list-upgrades');

		$this->packages = ob_get_clean();
		$this->packages = stPearFrontendWeb::getPearResult($content);
	}

	public function executeUploadDev()
	{

	}

	/**
	 * Package upload.
	 */
	public function executeUpload()
	{
		stRegisterSync::fixmd5sum();

		$this->error = '';
		$this->notice = '';
		$this->content = '';
		if ($this->getRequest()->getMethod() == sfRequest::POST && $this->hasRequestParameter('upload')) {

			$upload = $this->getRequestParameter('upload');
			$upload['file'] = $this->getRequest()->getFileName('upload[file]');

			if (!isset($upload['file']) || (isset($upload['file']) && empty($upload['file']))) {
				$this->error = 'Brak pakietu do instalacji.';
				return sfView::SUCCESS;
			}

			$fileDir = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'install'.DIRECTORY_SEPARATOR.'cache';
			$filePath = $fileDir.DIRECTORY_SEPARATOR.$upload['file'];

			$this->getRequest()->moveFile('upload[file]', $filePath);

			if (isset($upload['forced']) && $upload['forced'] == 1) $forced = true; else $forced = false;
			if (isset($upload['nodeps']) && $upload['nodeps'] == 1) $nodeps = true; else $nodeps = false;

			list($name, $versionWithExt) = explode('-', $upload['file']);

			switch(stWebStore::checkPackage($name, (isset($upload['code']) ? $upload['code'] : ''))) {
				case 0:
					if (!preg_match('/^st|sm/', $name)) {
						$this->error = 'Brak połączenia z serwerem sote.pl.';
						return sfView::SUCCESS;
					}
				case 1:
					break;
				case 2:
					$this->error = 'Nieprawidłowy kod aktywacji.';
					return sfView::SUCCESS;
				case 3:
					$this->error = 'Kod aktywacji został już wykorzystany.';
					return sfView::SUCCESS;
			}

			ob_start();

			$installer_web = new stInstallerFrontendWeb();
			if ($forced) $command = 'force-install'; else $command = 'upgrade';
			$installer_web->command($command, array("$filePath"), array('forced' => $forced, 'nodeps' => $nodeps));

			$this->content = ob_get_clean();

			if (preg_match('/Invalid tgz file/', $this->content)) {
				$this->error = 'Niepoprawny format pliku.';
				return sfView::SUCCESS;
			}

			if (preg_match('/PEAR_RESULT/', $this->content)) {
				if (preg_match('/install ok/', $this->content) || preg_match('/upgrade ok/', $this->content)) {
					$this->notice = 'Plik został wgrany.';
					stWebStore::activatePackage($name, (isset($upload['code']) ? $upload['code'] : ''));
				} else $this->error = 'Błąd podczas wgrywania pliku.'; 
				return sfView::SUCCESS;
			}
		}
	}

	/**
	 * Page not found message.
	 */
	public function executePageNotFound()
	{

	}

	/**
	 * Upgrade history.
	 */
	public function executeHistory()
	{
		$history = new stInstallerHistory();
		$this->history_apps = array_reverse($history->getHistory());
	}

	/**
	 * RSS upgrade.
	 */
	public function executeRss()
	{

	}

	/**
	 * Expert tools.
	 */
	public function executeTools()
	{
		// Check if optimization can be executed
		$regsync = new stRegisterSync();
		$apps_sync=$regsync->getAppsToSync();
		$this->optimization=true;
		if (! empty($apps_sync['all'])) $this->optimization=false; // there are apps in install/src
		if (stLockUpdate::isLocked()) $this->optimization=false;   // install process is executed
	}

	/**
	 * Verify all code.
	 */
	public function executeVerifyall()
	{
		$peari = new stPearInfo();
		$packages = $peari->getPackages();
		$this->count=sizeof($packages);
	}


	public function executeOptimization()
	{
		$this->executeCc();
	}

	/**
	 * Symfony pear clear-cache
	 */
	public function executePearcc()
	{
		ob_start();

		$installer_web = new stInstallerFrontendWeb();
		$installer_web->command('clear-cache',array()); // pear clear-cache
		$this->content = ob_get_clean();
	}

	/**
	 * Symfony pear config-set preferred_state
	 */
	public function executePearstate()
	{
		$this->hasStable=false;
		$this->hasBeta=false;

		if ($this->getRequest()->getMethod() == sfRequest::POST)
		{
			if ($this->getRequest()->hasParameter('pear[state]'))
			{
				$state=$this->getRequest()->getParameter('pear[state]');
				if ($state=='stable') $this->hasStable=true;
				else $this->hasBeta=true;

				if (($state=='beta') || ($state=='stable'))
				{
					ob_start();
					$installer_web = new stInstallerFrontendWeb();
					$installer_web->command('config-set',array('preferred_state',$state,'user'));
					$this->content = ob_get_clean();
				}
			}

			// if ($this->hasBeta==true)
			// {
			//     stDevelState::setStateBeta();
			// } else
			// {
			//     stDevelState::unsetStateBeta();
			// }

		} else
		{
			ob_start();
			$installer_web = new stInstallerFrontendWeb();
			$installer_web->command('config-get',array('preferred_state'));
			$result = ob_get_clean();
			$this->result=$result;
			preg_match("/stable/",$result,$matches);
			if (! empty($matches))
			{
				$this->hasStable=true;
			} else $this->hasBeta=true;
		}
	}

	public function executeNews()
	{
		// News Action
		$this->showNews = true;
		if ($this->getUser()->getCulture() == 'en_US') $this->showNews = false;
	}

	/**
	 * Show information about changelog.
	 * If any application has important message or required confirmation this action show it.
	 */
	public function executeChangelog()
	{
		$changelog = new stChangelog();
		if (! $changelog->isAnyActive())
		{
			// $this->redirect('installerweb/news'); // @todo usunac to i wstawic verify ponizej
			$this->redirect('installerweb/verify');
			$this->active="NOT ACTIVE"; // debug value
			return;
		} else
		{
			$this->active="ACTIVE";      // debug value
		}

		$this->files   = $changelog->getAllFiles();
		$this->apps    = $changelog->getPearUpgrades();
		$this->new     = $changelog->getSyncUpgrades();
		$this->active_contents = $changelog->getActiveContents();

		if (empty($this->active_contents))
		{
			$this->redirect('installerweb/verify');
			return;
		}

		$this->result    = $changelog->getResult();

		$this->smarty_changed = $changelog->isSmartyChanged();
		$this->smarty_theme   = $changelog->getSmartyTheme();

		$this->confirmation=false;
		foreach ($this->result as $priority=>$content)
		{
			if ($priority=="P1") $this->confirmation=true;
			foreach ($content as $app=>$content2)
			{
				$ret[$priority][$app]=$changelog->getUpdateContent($app,$content2,$priority);
			}
		}
		$this->output=$ret;

		if ($this->smarty_changed)
		{
			$smarty_changelog   = stChangelogSmarty::getInstance();
			$this->backup_token = $smarty_changelog->doBackup();
			$this->smarty_files = $smarty_changelog->getAllFiles();
		}
	}

	/**
	 * Download backup
	 */
	public function executeBackup()
	{
		$token  = $this->getRequestParameter('token');
		$this->token=$token;
		$this->raw_content=NULL;
		if (! empty($token))
		{
			$backup = stUpdateBackup::getInstance();
			$backup_file = $backup->getBackupFile($token);
			if (! empty($backup_file))
			{
				$raw_content=file_get_contents(sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.$backup_file);

				$this->setLayout(false);
				$response = $this->getContext()->getResponse();
				$response->setContentType("application/octet-stream");
				$response->setHttpHeader('Content-Disposition', 'attachment; filename="'.basename($backup_file).'"');
				return $this->renderText($raw_content);

			}
		}
	}

	/**
	 * Check .packages.reg file
	 */
	protected function checkPackageRegFile()
	{
		$file = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."install".DIRECTORY_SEPARATOR."db".DIRECTORY_SEPARATOR.".packages.reg";

		if(file_exists($file))
		{
			$packages = unserialize(file_get_contents($file));

			if (empty($packages)) $unlink = true;
			else {
				$unlink = true;
				foreach ($packages as $package => $status) if ($status != 'installed') $unlink = false;
			}

			if ($unlink) unlink($file);

			return $unlink;
		}
		return true;
	}
}