<?php
/** 
 * SOTESHOP/stUpdate 
 * 
 * This file is the part of stUpdate application. License: (Open License SOTE) Open License SOTE. 
 * Do not modify this file, system will overwrite it during upgrade.
 * 
 * @package     stUpdate
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Open License SOTE
 * @version     $Id: stPearFrontendWeb.class.php 11065 2011-02-16 10:38:27Z marek $
 */
                 
/** 
 * PEAR Frontend Web.
 *
 * @author Marek jakubowicz <marek.jakubowicz@sote.pl>
 *
 * @package     stUpdate
 * @subpackage  libs
 */
class stPearFrontendWeb extends PEAR_Frontend_CLI 
{   
    
     
    public function PEAR_Frontend_Web()
    {
        parent::PEAR();
        $this->config = &$GLOBALS['_PEAR_Frontend_Web_config'];
    }

    function setConfig(&$config)
    {
        $this->config = &$config;
    }
    
    /** 
     * Display human-friendly output formatted depending on the
     * $command parameter.
     * This should be able to handle basic output data with no command
     * @abstract
     *
     * @param   mixed       $data               data structure containing the information to display
     * @param   string      $command            command from which this method was called
     */
    public function outputData($data, $command = '_default')
    {      
       $this->symfonylog($data,$command); // add logs
       switch ($command)
       {
           case "list":    
               $this->_list($data);
               break;
           case "list-upgrades":
               $this->_listUpgrades($data);
               break;    
           case "install":
               $this->_install($data);
               break; 
           case "upgrade":
               $this->_upgrade($data);
               break;
           default:                          
               $this->_default($data);
               break;
       }
    }   
    
    /**
     * Log PEAR results for command.
     *
     * @param moxed  $data
     * @param string $command
     */
    protected function symfonylog($data,$command)
    {
        if (sfConfig::get('sf_debug') && sfConfig::get('sf_logging_enabled')) 
        {
            $log_file=sfConfig::get('sf_log_dir').DIRECTORY_SEPARATOR.'pearweb.log';
            $current_logs=file_get_contents($log_file);
            $log=$current_logs."\n"."PEAR web command: $command\n";
            if (is_array($data))
            {
                $log.=print_r($data,true);
                } else
                {
                    $log.=$data."\n";
                }
                file_put_contents($log_file,$log);
            }
    }                  
    
     /** 
      * Show application list.
      *
      * @param     array
      * @return   STDOUT
      */
     private function _list($data)
     {
        if (! empty($data['data'])) {
            $list=array();     

            foreach ($data['data'] as $key=>$app)
            {                              
                $name=$app[0];
                $version=$app[1];               
                $list[$name]=$version;                               
            }
            // show template
            // include_once (ST_TMPL_PEAR.'pear_list.php');                         
            $this->printResult(serialize($list));            
        }        
     }      
     
     /** 
      * Show messages after installation.
      *
      * @param     array
      * @return   STDOUT
      */
     private function _install($data)
     {
         $this->printResult(serialize(array($data)));
     }
     
      /** 
       * Show list upgrades.
       *
       * @param     array
       */
      private function _listUpgrades($data)
      {          
         if (! empty($data['data'])) {
             $list=array();     

             foreach ($data['data'] as $key=>$app)
             {                              
                 $channel=$app[0];
                 $name=$app[1];               
                 $version=$app[3];
                 $size=$app[4];
                 $list[]=array('channel'=>$channel,'name'=>$name,'version'=>$version,'size'=>$size);                             
             }
             // wyswietl szablon  
             $this->printResult(serialize($list));
         }        
      }
            
      /** 
       * Show upgrade result. 
       *
       * @param     mixed
       * @return   STDOUT string
       */
      private function _upgrade($data)
      {                  
          $this->printResult($data['data']);                                      
      }
                 
     
      /** 
       * Show PEAR messages.
       *
       * @param        string      $data
       * @return   STDOUT
       */
      private function _default($data) 
      {   
          $this->printResult(serialize($data));
      }          
      
      /** 
       * Return printed data.
       *
       * @param        string      $data
       * @return   STDOUT
       */
      private function printResult($data)
      {
          print "<PEAR_RESULT>".$data."</PEAR_RESULT>";
      }
      
      /** 
       * Get data from $this->print()
       *
       * @param                 string      $data               PEAR_RESULT
       * @param                 string      $mode               unserialize|raw
       * @return  string      | serialized string | NULL
       */
      static public function getPearResult($data,$mode='unserialize')
      {          
          $x=preg_split('/\<PEAR_RESULT\>/',$data,2);
          if (! empty($x[1]))
          {
              $data2=$x[1];
              $x2=preg_split('/\<\/PEAR_RESULT\>/',$data2,2);
              if (! empty($x2[0]))
              {
                  $result=$x2[0];
                  if ($mode=='unserialize') 
                  {
                      $data=@unserialize($result);
                      if (is_array($data)) return $data;
                      else return $result;
                  }
                  else return $result;
              }
          }
          return NULL;
      }
  
}       

