<?php
/**
 * SOTESHOP/stUpdate
 *
 * Ten plik należy do aplikacji stUpdate opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stUpdate
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 16204 2011-11-23 14:13:48Z michal $
 * @author      Piotr Halas <piotr.halas@sote.pl>
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa stSetupActions
 *
 * @package     stUpdate
 * @subpackage  actions
 */
class stSetupActions extends sfActions
{
	/**
	 * Wyświetlanie informacji ogólnych
	 */
	public function executeIndex()
	{
		$request = $this->getRequest();
		if ($request->hasParameter('language') && $request->getParameter('language') == 'pl') $this->getUser()->setCulture('pl_PL');
		if ($request->hasParameter('language') && $request->getParameter('language') == 'en') $this->getUser()->setCulture('en_US');

		$pakeweb = new stPakeWeb();
		$pakeweb->run('pear-update-config');

		$this->error = true;

		$this->license = $request->getParameter('license', null);

		$licenseChecked = false;

		if ($request->getMethod() == sfRequest::POST) {
			if ($request->hasParameter('license') && !empty($this->license)) {
				$stLicense = new stLicense($this->license);
				if ($stLicense->check()) {
					$licenseChecked = true;
				} elseif (preg_match('/^([^@\s]+)@((?:[-a-z0-9]+\.)+[a-z]{2,})$/i', $this->license)) {
					$stLicense = new stLicense();
					$this->license = $stLicense->getLicenseByEmail($this->license);
					if ($this->license == false) {
						$this->errorMsg = 'Brak połączenia z serwerem sote.pl.';
						return sfView::SUCCESS;
					}
					$stLicense->setLicense($this->license);
					$licenseChecked = true;
				} else {
					$this->errorMsg = 'Podana wartość jest nieprawidłowa. Proszę podać numer licencji lub adres email.';
					return sfView::SUCCESS;
				}
			} else {
				$this->errorMsg = 'Proszę podać numer licencji lub adres email.';
				return sfView::SUCCESS;
			}

			if ($licenseChecked) {
				$this->getUser()->setAttribute('licenseType', $stLicense->getType(), 'soteshop/stSetup');

				$file = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."install".DIRECTORY_SEPARATOR."db".DIRECTORY_SEPARATOR.".license.reg";
				if (file_exists($file)) @unlink($file);
				file_put_contents($file, $this->license);

				$stLicense->startInSote();
				$this->redirect('stSetup/license');
			}
		}

		$this->error = false;
	}

	/**
	 * Wyświetlanie licencji
	 */
	public function executeLicense()
	{
		switch($this->getUser()->getAttribute('licenseType', null, 'soteshop/stSetup'))
		{
			case stLicense::LICENSE_TYPE_COMMERCIAL:
				$this->partial = 'license_commercial';
				break;
			case stLicense::LICENSE_TYPE_OPEN:
				$this->partial = 'license_open';
				break;
			default:
				$this->partial = 'license_commercial';
				break;
		}

		if ($this->getUser()->getCulture() == 'en_US') $this->partial.= '_en';

		$installCustomPath = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'install'.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'install_custom.yml';
		if (file_exists($installCustomPath)){
			$installCustom = sfYaml::load($installCustomPath);
			if (isset($installCustom['package']) && $installCustom['package'] == 'soteshop_international') $this->partial = 'license_osl';
		}

		$this->notAccepted = false;

		if ($this->getRequest()->getMethod() == sfRequest::POST)
		{
			if ($this->getRequestParameter('accept')) $this->redirect('stSetup/require');
			$this->notAccepted = true;
		}
	}

	/**
	 * Wyświetlanie wymagań
	 */
	public function executeRequire()
	{
		$this->tests = new stSetupRequirements();
		$this->testsPassed = $this->tests->testAll();
		$this->testsStatus = $this->tests->getTest();
		$this->hasWarning = false;
	}

	/**
	 * Wyświetlanie konfiguracji bazy danych
	 */
	public function executeDatabase()
	{
		$this->dbUsername = $this->getRequestParameter('username');
		$this->dbPassword = $this->getRequestParameter('password');
		$this->dbHost = $this->getRequestParameter('host');
		$this->dbDatabase = $this->getRequestParameter('database');

		$this->dbError = true;
		$this->dbErrorMsg = '';

		if ($this->getRequest()->getMethod() == sfRequest::POST)
		{
			$con = @mysql_connect($this->dbHost,$this->dbUsername, $this->dbPassword);
			if ($con && mysql_select_db($this->dbDatabase,$con))
			{
				$res = mysql_query('SHOW VARIABLES LIKE "collation_database"', $con);
				$data = mysql_fetch_array($res);

				if ($data[1]!="utf8_unicode_ci") {
					mysql_free_result($res);
					$this->dbErrorMsg = 'Złe kodowanie bazy danych, proszę zmienić na utf8_unicode_ci.';
					return sfView::SUCCESS;
				}

				$res = mysql_query('SHOW TABLES', $con);

				if (!mysql_num_rows($res))
				{
					mysql_free_result($res);
					$setupFile = sfConfig::get('sf_config_dir').DIRECTORY_SEPARATOR.'__st_setup.yml';

					$database = array( 'database' => array (
                                       'username' => $this->dbUsername,
                                       'password' => $this->dbPassword,
                                       'host' => $this->dbHost,
                                       'database' => $this->dbDatabase
					));
					if (!file_put_contents($setupFile,sfYaml::dump($database)))
					{
						$this->dbErrorMsg = 'Nie mogę zapisać pliku konfiguracyjnego.';
						return sfView::SUCCESS;
					}
					$this->redirect('stSetup/download');
				} else {
					mysql_free_result($res);
					$this->dbErrorMsg = 'Baza danych nie jest pusta.';
					return sfView::SUCCESS;
				}
			} else {
				$this->dbErrorMsg = 'Nie można połączyć się z bazą danych, sprawdz dane i spróbuj ponownie.';
				return sfView::SUCCESS;
			}
		}
		$this->dbError = false;
	}

	/**
	 * Wyświetlanie ściągania pakietów
	 */
	public function executeDownload()
	{
		if (stInstallMethod::getWebInstall())
		{
			$this->forward('stSetup','dbdata');
			return;
		} else
		{
			$dbFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."install".DIRECTORY_SEPARATOR."db".DIRECTORY_SEPARATOR.".packages.reg";

			$dir = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR."install".DIRECTORY_SEPARATOR."config".DIRECTORY_SEPARATOR;
			$install = sfYaml::load($dir."install.yml");
			if (file_exists($dir.'install_custom.yml'))
			{
				$install = sfYaml::load($dir."install_custom.yml");
			}

			$pear = stPearInfo::getInstance()->getDefaultChannel();
			$appUrl = 'http://'.$pear.'/Chiara_PEAR_Server_REST/r/'.strtolower($install['package']).'/latest.txt';
			$appVersion = $this->getUrlResponse($appUrl);
			$package = array($install['package'] => $appVersion);

			$deps = $this->getDepsFor($package,$pear);
			file_put_contents($dbFile, serialize($deps));
		}
	}

	public function executeDbdata()
	{
		// new server update config
		$pakeweb = new stPakeWeb();
		$pakeweb->run('cc');
		$server = new stNewServer();
		$server->update();

		// copy index.php from backup
		$from=sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'install'.DIRECTORY_SEPARATOR.'tmp'.DIRECTORY_SEPARATOR.'index_frontend.php';
		$to=sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'index.php';
		if (! copy($from,$to))
		{
			throw new Exception ("Unable copy $from->$to");
		}
	}

	// /**
	//  * Build SQL from dump
	//  */
	// public function executeDbdata()
	// {
	//         /*
	//         ---
	//         all:
	//           propel:
	//             class: sfPropelDatabase
	//             param:
	//               phptype: mysql
	//               host: localhost
	//               database: database
	//               username: user
	//               encoding: utf8
	//               password: pass
	//         */
	//
	//         // check dump
	//         $dump = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'install'.DIRECTORY_SEPARATOR.'sql'.DIRECTORY_SEPARATOR.'soteshop.mysql';
	//         if (file_exists($dump))
	//         {
	//             $dump_sql = file_get_contents($dump);
		//             $this->sqlresult=$this->parseDump($dump_sql);
		//         } else throw new Execpetion("Dump SQL $dump not found");
		//
	//         $data=sfYaml::load(sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'databases.yml');
	//         $this->dbHost = $data['all']['propel']['param']['host'];
	//         $this->dbUsername = $data['all']['propel']['param']['username'];
	//         $this->dbPassword = $data['all']['propel']['param']['password'];
	//         $this->dbDatabase = $data['all']['propel']['param']['database'];
	//
	//  $this->dbError       = true;
	//         $this->reportMessage = '';
	//  $this->dbErrorMsg    = '';
	//
	//         $con = mysql_connect($this->dbHost,$this->dbUsername, $this->dbPassword);
	//         if ($con && mysql_select_db($this->dbDatabase,$con))
	//         {
	//             foreach ($this->sqlresult as $sql)
	//             {
	//                 echo "sql: <pre>".$sql. "</pre><hr />\n";
	//                 $res = mysql_query($sql, $con);
	//                 if ($res)
	//                 {
	//                     $this->reportMessage = '...ok<br>';
	//                 } else {
	//                     $this->dbErrorMsg=mysql_error();
		//                 }
		//             }
		//         } else {
		//             $this->dbErrorMsg = 'Nie można połączyć się z bazą danych, sprawdz dane i spróbuj ponownie.';
			//             return sfView::SUCCESS;
			//         }
			//
			//  $this->dbError = false;
			//
			// }

			// /**
			//  * Parse mysqldump file info mysql_quesry commands
			//  * @param string $dump_sql raw sqldump:
			//  *    mysqldump --complete-insert --skip-add-drop-table --skip-add-locks --skip-comments --user soteshop --password= soteshop_pear2 > soteshop.mysql
			//      * @return string sql from mysql_query
			//  */
			// protected function parseDump($dump_sql)
			// {
			//         $lines=preg_split("/\n/",$dump_sql);
				//         $sql='';$create=false;
				//         foreach ($lines as $line)
				//         {
				//
	//             // /*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
	//             if (preg_match("/^\/\*\!/",$line))
	//             {
	//                 preg_match("/^\/\*\![0-9]+\s{1}(.*)\*\/\;$/",$line,$matches);
	//                 if (! empty($matches[1]))
	//                 {
	//                     $sql=$matches[1];
	//                     $allsql[]=$sql;
	//                 }
	//             } elseif (preg_match("/^CREATE TABLE/",$line))
	//             {
	//                 $sql=$line."\n";
	//                 $create=true;
	//             } elseif ($create==true)
	//             {
	//                 if (preg_match("/^\) ENGINE=MyISAM/",$line))
	//                 {
	//                     $sql.=$line."\n";
	//                     $create=false;
	//                     $allsql[]=$sql;
	//                 } else {
	//                     $sql.=$line."\n";
	//                 }
	//             } else
	//             {
	//                 $sql=$line;
	//                 if ((! preg_match("/^[\s]+$/",$line)) && (! empty($line)))
	//                 {
	//                     $allsql[]=$line;
	//                 }
	//             }
	//         }
	//
	//         // echo "<pre>";print_r($allsql);echo "</pre>";
	//         return $allsql;
	// }

	/**
	 * Wyświetlanie instalacji
	 */
	public function executeInstall() {}

	/**
	 * Wyświetlanie konfiguracji i optymalizacji
	 */
	public function executeConfigure() {
		if (!file_exists(sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'install'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'.settings.reg')) return $this->forward('stSetup', 'settings');

		// włącz fastcache dla nowych instalacji
		$fastCacheEnabled = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'fast_cache_enabled';
		if (!file_exists($fastCacheEnabled)) touch($fastCacheEnabled);
	}

	/**
	 * Wyświetlenie informacji końcowych
	 */
	public function executeFinish()
	{
		$hostname = $this->getRequest()->getHost();

		$this->frontend = "http://$hostname";
		$this->backend = "http://$hostname/backend.php";
		$this->update = "http://$hostname/update.php";

		$file = sfConfig::get('sf_app_dir').DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'stSetup'.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'security.yml';
		$data = array();
		$data['all']['is_secure'] = 'on';
		file_put_contents($file, sfYaml::dump($data));

		$pakeweb = new stPakeWeb();
		if (!$pakeweb->run('cc')) throw new Exception($pakeweb->error);
	}

	/**
	 * Wyświetlenie rekonfiguracji bazy danych
	 */
	public function executeReconfigure()
	{
		$pakeweb = new stPakeWeb();
		$pakeweb->run('pear-update-config');

		$this->dbUsername = $this->getRequestParameter('username');
		$this->dbPassword = $this->getRequestParameter('password');
		$this->dbHost = $this->getRequestParameter('host');
		$this->dbDatabase = $this->getRequestParameter('database');

		$this->newServer = $this->getRequestParameter('newServer', false);

		$stRegisterConfig = stConfig::getInstance($this->getContext(), 'stRegister');
		$this->license = $stRegisterConfig->get('license');
		$i18n = $this->getContext()->getI18N();

		$this->dbError = true;
		$this->dbErrorMsg = '';

		if ($this->getRequest()->getMethod() == sfRequest::POST) {

			$con = @mysql_connect($this->dbHost,$this->dbUsername, $this->dbPassword);
			if ($con && mysql_select_db($this->dbDatabase,$con)) {

				$setupFile = sfConfig::get('sf_config_dir').DIRECTORY_SEPARATOR.'__st_setup.yml';

				$database = array('database'=>array(
                       'username'=>$this->dbUsername,
                       'password'=>$this->dbPassword,
                       'host'=>$this->dbHost,
                       'database'=>$this->dbDatabase
				));
				if (!file_put_contents($setupFile,sfYaml::dump($database))) {
					$this->dbErrorMsg = 'Nie mogę zapisać pliku konfiguracyjnego.';
					return sfView::SUCCESS;
				}

				if ($this->newServer)
				{
					$this->license = $this->getRequest()->getParameter('license');

					if(!$this->license)
					{
						$this->dbErrorMsg = $i18n->__('Proszę uzupełnić pole "Numer licencji".');
						return sfView::SUCCESS;
					}

					if (strlen($this->license) != 29)
					{
						$this->dbErrorMsg = $i18n->__('Proszę sprawdzić czy numer licencji oraz jego format są poprawne.<br/>Numer licencji powinien zawierać 29 znaków w formacie xxxx-xxxx-xxxx-xxxx-xxxx-xxxx.');
						return sfView::SUCCESS;
					}

					$stLicense = new stLicense($this->license);

					if (!$stLicense->checkInSote())
					{
						$this->dbErrorMsg = $i18n->__('Numer licencji jest nieprawidłowy.');
						return sfView::SUCCESS;
					}

					$stRegisterConfig->set('license', trim($this->license));
					$stRegisterConfig->save();

					$stLicense->activateInSote();
				}

				$pakeweb->run('setup-update');
				return $this->forward('stSetup', 'reconfigureFinish');

			} else {
				$this->dbErrorMsg = 'Nie można połączyć się z bazą danych, sprawdz dane i spróbuj ponownie.';
				return sfView::SUCCESS;
			}
		}
		$this->dbError = false;
	}

	/**
	 * Wyświetlenie podsumowania rekonfiguracji bazy danych
	 */
	public function executeReconfigureFinish()
	{
		$this->dbUsername = $this->getRequestParameter('username');
		$this->dbPassword = $this->getRequestParameter('password');
		$this->dbHost = $this->getRequestParameter('host');
		$this->dbDatabase = $this->getRequestParameter('database');
	}

	/**
	 * Ściąganie danych o pakietach
	 *
	 * @param string $url
	 */
	private function getUrlResponse($url)
	{
		$c = curl_init();
		curl_setopt($c, CURLOPT_URL,  $url);
		curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
		$ret = curl_exec($c);
		curl_close($c);

		return $ret;
	}

	/**
	 * Pobireanie zależności pakietów 
	 * @param $packages
	 * @param $channel
	 */
	private function getDepsFor($packages = array(), $channel = '')
	{
		$content = "deps=".serialize($packages);
		$ch = curl_init();

		if (stDevelState::isBeta()) $depsphp='deps_beta.php';
		else $depsphp="deps_stable.php";

		curl_setopt($ch, CURLOPT_URL, "http://".$channel."/".$depsphp);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $content);
		$data = curl_exec($ch);
		curl_close($ch);
		return unserialize($data);
	}


	public function executeSettings()
	{
		/**
		 * Themes
		 */
		$themeFiles = glob(sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'packages'.DIRECTORY_SEPARATOR.'*'.DIRECTORY_SEPARATOR.'theme.yml');

		$licenseType = $this->getUser()->getAttribute('licenseType', null, 'soteshop/stSetup');

		$this->themes = array();
		foreach($themeFiles as $themeFile)
		{
			$themeYaml = sfYaml::load($themeFile);

			if ($licenseType == stLicense::LICENSE_TYPE_COMMERCIAL || ($licenseType == stLicense::LICENSE_TYPE_OPEN && $themeYaml['theme']['type'] == 'open'))
			$this->themes[$themeYaml['theme']['package']] = array('name' => $themeYaml['theme']['name'], 'fixtures' => $themeYaml['theme']['fixtures']);
			unset($themeYaml);
		}

		/**
		 * Currency
		 */
		$currencies = sfYaml::load(sfConfig::get('sf_plugins_dir').DIRECTORY_SEPARATOR.'stCurrencyPlugin'.DIRECTORY_SEPARATOR.'data'.DIRECTORY_SEPARATOR.'fixtures'.DIRECTORY_SEPARATOR.'stCurrencyPlugin.yml');
		unset($currencies['CurrencyStandard']);

		if ($this->getUser()->getCulture() == 'pl_PL') $this->defaultCurrency = 'PLN';
		else $this->defaultCurrency = 'USD';

		$this->currency = array();
		foreach ($currencies['Currency'] as $id => $c)
		{
			$this->currency[$c['shortcut']] = $c['name'];
			if ($this->getUser()->getCulture() != 'pl_PL')
			{
				foreach($currencies['CurrencyI18n'] as $cI18n)
				{
					if ($id == $cI18n['id'])
					{
						$this->currency[$c['shortcut']] = $cI18n['name'];
						break;
					}

				}
			}
		}
		unset($currencies);
		asort($this->currency);

		/**
		 * Country
		 */
		$countries = sfYaml::load(sfConfig::get('sf_data_dir').DIRECTORY_SEPARATOR.'fixtures'.DIRECTORY_SEPARATOR.'stCountriesDefine.yml');

		if ($this->getUser()->getCulture() == 'pl_PL') $this->defaultCountry = 'POL';
		else $this->defaultCountry = 'USA';

		$this->countries = array();
		foreach ($countries['Countries'] as $id => $c)
		{
			$this->countries[$c['iso_a3']] = $c['name'];
			if ($this->getUser()->getCulture() != 'pl_PL')
			{
				foreach($countries['CountriesI18n'] as $cI18n)
				{
					if ($id == $cI18n['id'])
					{
						$this->countries[$c['iso_a3']] = $cI18n['name'];
						break;
					}

				}
			}
		}
		unset($countries);
		asort($this->countries);

		/**
		 * Languages
		 */
		$languages = sfYaml::load(sfConfig::get('sf_data_dir').DIRECTORY_SEPARATOR.'fixtures'.DIRECTORY_SEPARATOR.'stLanguagePlugin.yml');
		$translationFiles = glob(sfConfig::get('sf_data_dir').DIRECTORY_SEPARATOR.'fixtures'.DIRECTORY_SEPARATOR.'stTranslation*Plugin.yml');

		foreach($translationFiles as $translationFile)
		{
			$tmp = sfYaml::load($translationFile);
			$languages = array_merge_recursive($languages, $tmp);
			unset($tmp);
		}

		$this->languagePanel = array();
		$this->language = array();
		foreach ($languages['Language'] as $id => $l)
		{
			if ($this->getUser()->getCulture() != 'pl_PL')
			{
				foreach($languages['LanguageI18n'] as $lI18n)
				{
					if ($id == $lI18n['id'])
					{
						$l['name'] = $lI18n['name'];
						break;
					}
				}
			}

			$this->language[$l['language']] = $l['name'];
			if (isset($l['is_translate_panel']) && $l['is_translate_panel']) $this->languagePanel[$l['language']] = $l['name'];
			if ($l['language'] == $this->getUser()->getCulture()) $this->defaultLanguage = $l['language'];
		}

		if (stSoteshopVersion::getVersion() == stSoteshopVersion::ST_SOTESHOP_VERSION_INTERNATIONAL) unset($this->languagePanel['pl_PL']);
		unset($languages);
		asort($this->language);
		asort($this->languagePanel);

		/**
		 * Save POST
		 */
		if ($this->getRequest()->getMethod() == sfRequest::POST)
		{
			$settings = $this->getRequest()->getParameter('settings');
			$themePackage = $settings['theme'];
			$settings['theme'] = $this->themes[$themePackage]['name'];
			$settings['fixtures_name'] = $this->themes[$themePackage]['fixtures'];

			file_put_contents(sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'install'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'.settings.reg', sfYaml::dump($settings));

			return $this->forward('stSetup', 'configure');
		}
	}
}