<?php use_helper('stUpdate');?>
<?php use_stylesheet('/css/update/stInstallerWebPlugin.css');?>
<?php echo form_tag('stSetup/settings');?>
    <div id="sf_admin_container">
        <div class="stSetup-left_menu">
            <?php include_component('stSetup', 'leftMenu', array('step'=>'settings'));?>
        </div>
        <div id="stSetup-right_menu">
            <h1><?php echo __("Domyślne ustawienia");?></h1>
            <fieldset>
                <div class="st_fieldset-content">
                    <div class="form-row">
                        <div class="frame-themes-name"><?php echo __('Domyślny temat graficzny');?></div>
                        <div id="frame-themes">
                            <?php $radio = false; $i = 1;?>
                            <?php foreach($themes as $package => $theme):?>
                                <div class="box-theme"<?php if ($i <= 5) echo ' style="padding-bottom: 20px;"';?>>
                                    <a href="/images/update/themes/<?php echo $package;?>_large.png" title="" target="_blank">
                                        <img src="/images/update/themes/<?php echo $package;?>.png" alt="" title=""/>
                                    </a>
                                    <div class="box-theme-name">
                                        <?php if ($theme['name'] == 'default2') $radio = true;?>
                                        <?php echo radiobutton_tag('settings[theme]', $package, $radio);?><?php echo $theme['name'];?>
                                    </div>
                                </div>
                                <?php $radio = false; $i++;?>
                            <?php endforeach;?>
                        </div>
                    </div> 
                    <div class="form-row">
                        <label><?php echo __('Załaduj przykładowe dane');?></label>
                        <div class="content">
                            <?php echo checkbox_tag('settings[load_fixtures]', 1, true);?>
                        </div>
                    </div>
                    <div class="form-row label-select">
                        <label><?php echo __('Waluta');?></label>
                        <div class="content">
                            <?php echo select_tag('settings[currency]', options_for_select($currency, $defaultCurrency), array());?>
                        </div>
                    </div>
                    <div class="form-row label-select">
                        <label><?php echo __('Domyślny kraj');?></label>
                        <div class="content">
                            <?php echo select_tag('settings[country]', options_for_select($countries, $defaultCountry), array());?>
                        </div>
                    </div>
                    <div class="form-row label-select">
                        <label><?php echo __('Wersja językowa panelu sklepu');?></label>
                        <div class="content">
                            <?php echo select_tag('settings[language_panel]', options_for_select($languagePanel, $defaultLanguage), array());?>
                        </div>
                    </div>
                    <div class="form-row label-select">
                        <label><?php echo __('Wersja językowa sklepu');?></label>
                        <div class="content">
                            <?php echo select_tag('settings[language]', options_for_select($language, $defaultLanguage), array());?>
                        </div>
                    </div>
                </div>
            </fieldset>
        </div>
    </div>
    <div class="stSetup-actions" id='stSetup-install_actions'>
        <?php echo st_get_update_actions_head('style="float:right"');?>
            <?php echo st_get_update_action('next', __('Przejdź do konfiguracji'), null);?>
        <?php echo st_get_update_actions_foot();?>
    </div>
</form>