
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- st_gift_card
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_gift_card`;


CREATE TABLE `st_gift_card`
(
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`status` VARCHAR(1) default 'A',
	`amount` DECIMAL(10,2)  NOT NULL,
	`code` VARCHAR(64)  NOT NULL,
	`valid_to` DATE,
	`currency_id` INTEGER  NOT NULL,
	PRIMARY KEY (`id`),
	UNIQUE KEY `code_idx` (`code`),
	KEY `status_idx`(`status`),
	INDEX `st_gift_card_FI_1` (`currency_id`),
	CONSTRAINT `st_gift_card_FK_1`
		FOREIGN KEY (`currency_id`)
		REFERENCES `st_currency` (`id`)
		ON DELETE CASCADE
)Engine=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
