
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- st_news
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_news`;


CREATE TABLE `st_news`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`active` INTEGER,
	`opt_name` VARCHAR(255),
	`opt_description` TEXT,
	`opt_long_description` TEXT,
	PRIMARY KEY (`id`)
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_news_group_has_news
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_news_group_has_news`;


CREATE TABLE `st_news_group_has_news`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`news_group_id` INTEGER  NOT NULL,
	`news_id` INTEGER  NOT NULL,
	PRIMARY KEY (`id`),
	INDEX `st_news_group_has_news_FI_1` (`news_group_id`),
	CONSTRAINT `st_news_group_has_news_FK_1`
		FOREIGN KEY (`news_group_id`)
		REFERENCES `st_news_group` (`id`)
		ON DELETE RESTRICT,
	INDEX `st_news_group_has_news_FI_2` (`news_id`),
	CONSTRAINT `st_news_group_has_news_FK_2`
		FOREIGN KEY (`news_id`)
		REFERENCES `st_news` (`id`)
		ON DELETE RESTRICT
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_news_group
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_news_group`;


CREATE TABLE `st_news_group`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`group_news` VARCHAR(255),
	`opt_name` TEXT,
	PRIMARY KEY (`id`)
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_news_i18n
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_news_i18n`;


CREATE TABLE `st_news_i18n`
(
	`id` INTEGER  NOT NULL,
	`culture` VARCHAR(7)  NOT NULL,
	`name` VARCHAR(255),
	`description` TEXT,
	`long_description` TEXT,
	PRIMARY KEY (`id`,`culture`),
	CONSTRAINT `st_news_i18n_FK_1`
		FOREIGN KEY (`id`)
		REFERENCES `st_news` (`id`)
		ON DELETE CASCADE
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_news_group_i18n
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_news_group_i18n`;


CREATE TABLE `st_news_group_i18n`
(
	`id` INTEGER  NOT NULL,
	`culture` VARCHAR(7)  NOT NULL,
	`name` TEXT,
	PRIMARY KEY (`id`,`culture`),
	CONSTRAINT `st_news_group_i18n_FK_1`
		FOREIGN KEY (`id`)
		REFERENCES `st_news_group` (`id`)
		ON DELETE CASCADE
)Engine=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
