
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- st_recommend_send
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_recommend_send`;


CREATE TABLE `st_recommend_send`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`sf_guard_user_id` INTEGER  NOT NULL,
	`product_id` INTEGER  NOT NULL,
	`recommend_from` TEXT,
	`friend_email` TEXT,
	`recommend_link` TEXT,
	`visited` INTEGER default 0,
	`uniqid` VARCHAR(255),
	`recommend_content` TEXT,
	`additional_info` TEXT,
	`product_name` TEXT,
	PRIMARY KEY (`id`),
	INDEX `st_recommend_send_FI_1` (`sf_guard_user_id`),
	CONSTRAINT `st_recommend_send_FK_1`
		FOREIGN KEY (`sf_guard_user_id`)
		REFERENCES `sf_guard_user` (`id`)
		ON DELETE CASCADE,
	INDEX `st_recommend_send_FI_2` (`product_id`),
	CONSTRAINT `st_recommend_send_FK_2`
		FOREIGN KEY (`product_id`)
		REFERENCES `st_product` (`id`)
		ON DELETE CASCADE
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_recommend_shop_send
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_recommend_shop_send`;


CREATE TABLE `st_recommend_shop_send`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`sf_guard_user_id` INTEGER  NOT NULL,
	`recommend_from` TEXT,
	`friend_email` TEXT,
	`recommend_shop_link` TEXT,
	`visited` INTEGER,
	`uniqid_shop` VARCHAR(255),
	`recommend_shop_content` TEXT,
	`additional_shop_info` TEXT,
	PRIMARY KEY (`id`),
	INDEX `st_recommend_shop_send_FI_1` (`sf_guard_user_id`),
	CONSTRAINT `st_recommend_shop_send_FK_1`
		FOREIGN KEY (`sf_guard_user_id`)
		REFERENCES `sf_guard_user` (`id`)
		ON DELETE CASCADE
)Engine=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
