
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- st_searched_words
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_searched_words`;


CREATE TABLE `st_searched_words`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`word` VARCHAR(255)  NOT NULL,
	`results` INTEGER default 0 NOT NULL,
	`searched` INTEGER default 0 NOT NULL,
	`swap` VARCHAR(255),
	`url` VARCHAR(255),
	PRIMARY KEY (`id`),
	KEY `searched_words_searched`(`word`),
	KEY `searched_words_swap`(`swap`)
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_product_search_index
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_product_search_index`;


CREATE TABLE `st_product_search_index`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL,
	`culture` VARCHAR(7)  NOT NULL,
	`name` TEXT,
	`simple_search` TEXT,
	`advanced_search` TEXT,
	`advanced_name` TEXT,
	PRIMARY KEY (`id`,`culture`),
	CONSTRAINT `st_product_search_index_FK_1`
		FOREIGN KEY (`id`)
		REFERENCES `st_product` (`id`)
		ON DELETE RESTRICT
)Engine=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
