
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

#-----------------------------------------------------------------------------
#-- st_theme_layout
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_theme_layout`;


CREATE TABLE `st_theme_layout`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`theme_id` INTEGER  NOT NULL,
	`sf_guard_user_id` INTEGER,
	`container` VARCHAR(255),
	`blocks` TEXT,
	PRIMARY KEY (`id`),
	INDEX `st_theme_layout_FI_1` (`theme_id`),
	CONSTRAINT `st_theme_layout_FK_1`
		FOREIGN KEY (`theme_id`)
		REFERENCES `st_theme` (`id`)
		ON DELETE CASCADE,
	INDEX `st_theme_layout_FI_2` (`sf_guard_user_id`),
	CONSTRAINT `st_theme_layout_FK_2`
		FOREIGN KEY (`sf_guard_user_id`)
		REFERENCES `sf_guard_user` (`id`)
		ON DELETE CASCADE
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_theme
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_theme`;


CREATE TABLE `st_theme`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`base_theme_id` INTEGER,
	`theme` VARCHAR(255)  NOT NULL,
	`active` INTEGER default 0,
	`opt_color_scheme` VARCHAR(32),
	`version` INTEGER,
	`is_system_default` INTEGER default 0 NOT NULL,
	PRIMARY KEY (`id`),
	INDEX `st_theme_FI_1` (`base_theme_id`),
	CONSTRAINT `st_theme_FK_1`
		FOREIGN KEY (`base_theme_id`)
		REFERENCES `st_theme` (`id`)
		ON DELETE SET NULL
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_theme_css
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_theme_css`;


CREATE TABLE `st_theme_css`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`theme_id` INTEGER  NOT NULL,
	`css_head_id` VARCHAR(255),
	`css_content` TEXT,
	PRIMARY KEY (`id`),
	INDEX `st_theme_css_FI_1` (`theme_id`),
	CONSTRAINT `st_theme_css_FK_1`
		FOREIGN KEY (`theme_id`)
		REFERENCES `st_theme` (`id`)
		ON DELETE RESTRICT
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_theme_color_scheme
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_theme_color_scheme`;


CREATE TABLE `st_theme_color_scheme`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL AUTO_INCREMENT,
	`theme_id` INTEGER  NOT NULL,
	`name` VARCHAR(255),
	`is_default` INTEGER default 0,
	PRIMARY KEY (`id`),
	INDEX `st_theme_color_scheme_FI_1` (`theme_id`),
	CONSTRAINT `st_theme_color_scheme_FK_1`
		FOREIGN KEY (`theme_id`)
		REFERENCES `st_theme` (`id`)
		ON DELETE RESTRICT
)Engine=MyISAM;

#-----------------------------------------------------------------------------
#-- st_theme_config
#-----------------------------------------------------------------------------

DROP TABLE IF EXISTS `st_theme_config`;


CREATE TABLE `st_theme_config`
(
	`created_at` DATETIME,
	`updated_at` DATETIME,
	`id` INTEGER  NOT NULL,
	`parameters` TEXT,
	PRIMARY KEY (`id`),
	CONSTRAINT `st_theme_config_FK_1`
		FOREIGN KEY (`id`)
		REFERENCES `st_theme` (`id`)
		ON DELETE CASCADE
)Engine=MyISAM;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
