<?php
if (version_compare($version_old, '1.0.4.20', '<'))
{
    $databaseManager = new sfDatabaseManager();

    $databaseManager->initialize();

    $deliveries = DeliveryPeer::doSelect(new Criteria());

    $c = new Criteria();

    $c->add(PaymentTypePeer::ACTIVE, true);

    $payments = PaymentTypePeer::doSelect($c);

    $countries = CountriesPeer::doSelect(new Criteria());

    $c = new Criteria();

    $c->add(TaxPeer::VAT, 22);

    $tax = TaxPeer::doSelectOne($c);

    if ($tax == null)
    {
        $tax = new Tax();

        $tax->setVat(22);

        $tax->setVatName('22%');

        $tax->save();
    }

    CountriesAreaPeer::doDeleteAll();

    $country_area = new CountriesArea();

    $country_area->setName('Domyślna');

    $country_area->setIsActive(true);

    $country_area->save();

    foreach($countries as $country)
    {
        $cahc = new CountriesAreaHasCountries();

        $cahc->setCountriesId($country->getId());

        $cahc->setCountriesAreaId($country_area->getId());

        $cahc->save();
        
        $country->setCulture('pl_PL');

        $country->setIsActive(true);

        if ($country->getName() == 'Azejberdżan')
        {
            $country->setName('Azerbejdżan');
        }

        if ($country->getName() == 'Polska')
        {
            $country->setIsDefault(true);
        }

        $country->save();
    }

    DeliveryHasPaymentTypePeer::doDeleteAll();

    foreach($deliveries as $dk => $delivery)
    {
        $dss = $delivery->getDeliverySectionss();

        foreach ($dss as $ds)
        {
            $netto = stCurrency::extractNettoFromBrutto($ds->getAmount(), 22);

            $ds->setAmount($netto);

            $ds->save();
        }

        foreach ($payments as $pk => $payment)
        {
            $dhp = new DeliveryHasPaymentType();

            $dhp->setPaymentTypeId($payment->getId());

            $dhp->setDeliveryId($delivery->getId());

            $dhp->setIsActive(true);

            if ($pk == 0)
            {
                $dhp->setIsDefault(true);
            }

            $dhp->save();
        }

        $netto = stCurrency::extractNettoFromBrutto($delivery->getDefaultCost(), 22);

        if (empty($dss))
        {
            $delivery->setDefaultCost($netto);
        }
        else
        {
            $delivery->setDefaultCost(0);

            $ds = new DeliverySections();

            $ds->setDeliveryId($delivery->getId());

            $ds->setAmount($netto);

            $ds->setFrom(0);

            $ds->save();

            $delivery->setSectionCostType('ST_BY_ORDER_WEIGHT');
        }

        $delivery->setTaxId($tax->getId());

        $delivery->setIsSystemDefault(false);

        if ($dk == 0)
        {
            $delivery->setIsDefault(true);
        }

        $delivery->setCountriesAreaId($country_area->getId());

        $delivery->save();
    }
}
