<?php
/** 
 * SOTESHOP/stFrontend
 * 
 * Ten plik należy do aplikacji stFrontend opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stFrontend
 * @subpackage  helper
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: fc_users_online.php 6078 2010-07-06 13:42:51Z marek $
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */  

define ('ST_ONLINE_USERS_FILE',SF_ROOT_DIR.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'prod'.DIRECTORY_SEPARATOR.'users_online_temporary.reg');
define ('ST_ONLINE_USERS_REFRESH',300); // 300 - 5 min

/**
 * Get number of the on-line users.
 * @return int 
 * Modes: fast cache
 */
function fc_get_online_users()
{    
    // start: check session
    // Symfony mode:
    // $context  = sfContext::getInstance();        
    // $sf_user  = $context->getUser();
    // $users_online = $sf_user->getAttribute('users_online');
    
    // Fast cache mode:     
    $fc_context   = fcContext::getInstance();
    $fc_user      = $fc_context->getUser();
    $users_online = $fc_user->getAttribute('users_online');
    // end:
    
    $dat=array();
    if (file_exists(ST_ONLINE_USERS_FILE)) 
    {
        $dat=unserialize(file_get_contents(ST_ONLINE_USERS_FILE));
        if (! is_array($dat)) $dat=array();           
    }
    
    $current_users_online=sizeof($dat);
    if (! $current_users_online>0) $current_users_online=1;

    // read users on-line all the time
    if (! empty($users_online)) {        
        return $current_users_online;
    }  
    
    // add client only if it is allowed browser
    $userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);    
    $allowed=false;    
    $allowed_browsers=array(
        'chrome',
        'firefox',
        'internet explorer',
        'konqueror',
        'lynx',
        'mozilla',
        'netscape',
        'opera',
        'safari',
        );        
    foreach ($allowed_browsers as $id=>$browser)
    {
        if (ereg($browser,$userAgent))
        {
            $allowed=true;
        }
    }
    
    if (! $allowed) return $current_users_online;
    
    // add user, only first time in session
    $dat[time()]=1;         
    
    // delete old records
    foreach ($dat as $time=>$null) 
    {       
        $t1=$time+(ST_ONLINE_USERS_REFRESH);
        $t2=time();
        if ($t1<$t2) unset($dat[$time]);            
    }
    
    file_put_contents(ST_ONLINE_USERS_FILE,serialize($dat));
    
    $users_online=sizeof($dat);
    // $sf_user->setAttribute('users_online', $users_online);    
    $fc_user->setAttribute('users_online', $users_online);
   
    return intval($users_online);
}