<?php
/**
 * Execute fastcache. Part of index.php
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */

if (!file_exists(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'fast_cache_debug'))
{
	error_reporting(0);
	ini_set('display_errors',0);
} else {
	error_reporting(E_ALL);
	ini_set('display_errors',1);
}
// Fast cache base lib dir
$fast_cache_lib_dir  = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'lib';
define ('FC_LIB_DIR',$fast_cache_lib_dir);
require_once ($fast_cache_lib_dir.DIRECTORY_SEPARATOR.'fcActivation.class.php');

// When symfony web/index.php script is executed system execute sfSupercacheFilter
// This filter works only when hash code is ok. Filter is executed at the end of the process
// so we need another verification at the begining. This verification set rest of execution in fast_cache mode.
// If any module isn't set for fast_cache saving, system will generate fast_cache_code but without saving.
require_once ($fast_cache_lib_dir.DIRECTORY_SEPARATOR.'helper'.DIRECTORY_SEPARATOR.'stFastCacheHelper.php');
require_once ($fast_cache_lib_dir.DIRECTORY_SEPARATOR.'helper'.DIRECTORY_SEPARATOR.'stSymfonyFastCacheHelper.php');

// Start session
require_once ($fast_cache_lib_dir.DIRECTORY_SEPARATOR.'fcSessionStorage.class.php');
require_once ($fast_cache_lib_dir.DIRECTORY_SEPARATOR.'fcContext.class.php');
require_once ($fast_cache_lib_dir.DIRECTORY_SEPARATOR.'fcUser.class.php');
require_once (SF_ROOT_DIR.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'stFastCacheManager.class.php');
$fcsession = fcSessionStorage::getInstance();

$fast_cache_host     = $_SERVER['HTTP_HOST'];
if (! defined('FASTCACHE_URI')) define ('FASTCACHE_URI','index.php');
$request_uri=str_replace("/".FASTCACHE_URI."/",'',$_SERVER['REQUEST_URI']); 
if (($request_uri=='/'.FASTCACHE_URI) || ($request_uri=='/')) $request_uri='/index.html'; 
$int_hash=st_int_hash_number($fast_cache_host.$request_uri);
$dbFile = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'cache.db.'.$int_hash;

$sqlite_exists=false;           
if (! st_hash_verification() && fcActivation::isActive() && class_exists('PDO') && 
	file_exists($dbFile)&&
	file_exists(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'fast_cache_enabled'))
{      
    
    $sqlite_exists=true;
      
	$logFile = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'log'.DIRECTORY_SEPARATOR.'fastcache.log';	   
    $languages = st_get_all_languages();    
   
    // set uri for language version
    $change_language=false;
    if ($request_uri=="/index.html") 
    {
        
        // session can't be started for action symfony
        $fcsession = fcSessionStorage::getInstance();
        $language_current=$fcsession->read("fastcache_lang");
        fcSessionStorage::close();

        $request_uri=st_change_language_uri($languages, $language_current, $request_uri);    
        $change_language=true;
        
        $int_hash=st_int_hash_number($fast_cache_host.$request_uri);
        
        $dbFile = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'cache.db.'.$int_hash;
        $sqlite_lock_journal=$dbFile.'-journal'; $sqlite_lock_wal=$dbFile.'-wal';
        if (file_exists($dbFile) && (! file_exists($sqlite_lock_journal)) && (! file_exists($sqlite_lock_wal)))
        {
            $sqlite_exists=true;
        } else {
            $sqlite_exists=false;
        }     
    }
        
        
    if ($sqlite_exists)
    {            
         $cache_time_file = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'fast_cache_time';
         $cache_time = 7;
         if (file_exists($cache_time_file)) {
         	$cache_time = intval(file_get_contents($cache_time_file));
            if ($cache_time==0) $cache_time = 7;
         }
    	
         // Select page from cache
         try {
             $db = new PDO('sqlite:'. $dbFile);
         }  catch (PDOException $e) {
             file_put_contents($logFile, $e->getMessage(), FILE_APPEND);
         }
		           
        $sth = $db->prepare("SELECT content, language, modified, currency FROM cache WHERE host = ? AND url = ?");
        if ($sth===false) {
            file_put_contents($logFile, implode(',',$db->errorInfo()), FILE_APPEND);
        }    
        $xuri=ltrim($request_uri,'/');
        $sth->execute(array($fast_cache_host, $xuri));
        $data = $sth->fetch();          

        // Check if page exists in database
        if ($data!==false) 
        {
        	if (is_null($fcsession->read('fastcache_lang')) || $fcsession->read('fastcache_lang') == $data['language'])
        	{
	        	//sprawdz czy wpis nie jest za stary        
	        	if ($data['modified'] > time() - $cache_time * 86400)
	        	{
					if ($change_language) $data['language']=$language_current;		            
		
		            $fcsession = fcSessionStorage::getInstance();
		            $fcsession->write('fastcache_lang',$data['language']);         // set current lang               
		            $fcsession->write('fastcache_currency',$data['currency']);         // set current lang
	        		
		            ob_start("ob_gzhandler");
		            eval('?>'.$data['content'].'<?');      
		
		            define ("ST_FAST_CACHE_MATCH",1);
					include (SF_ROOT_DIR.DIRECTORY_SEPARATOR."fastcache".DIRECTORY_SEPARATOR."lib".DIRECTORY_SEPARATOR."fcTimer.php");
		            ob_end_flush();
		            exit;
	        	} else {
	        		stFastCacheManager::clearCache();
	        	} 
        	}
        } else {
            file_put_contents($logFile, implode(',',$sth->errorInfo()), FILE_APPEND);
        }
    } // end if sqlite_exists
} 
session_write_close();

if (st_hash_verification())
{
    // this constant mean that process is executed in fast_cache mode and will be saved in fast_cache file
    if ((! empty($_REQUEST['default'])) and ($_REQUEST['default']==1))
    {
        define ("ST_FAST_CACHE_SAVE_MODE",0);
        define ("ST_FAST_CACHE_DEFAULT_MODE",1);      
    } else
    {
        define ("ST_FAST_CACHE_SAVE_MODE",1);   
        define ("ST_FAST_CACHE_DEFAULT_MODE",0);      
    }
} else 
{
    // standard mode
    define ("ST_FAST_CACHE_DEFAULT_MODE",0);
    define ("ST_FAST_CACHE_SAVE_MODE",0);
}




