<?php
/**
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */
 
/**
 * Simple session manager
 */
class fcSessionStorage
{
    protected static
        $instance          = null;
        
    public static function getInstance()
    {
       if (!isset(self::$instance))
       {
         $class = __CLASS__;
         self::$instance = new $class();
         self::$instance->initialize();
       }

       return self::$instance;
    }
        
    public function initialize()
    {
        // set session name
        $sessionName = 'soteshop';
        
        session_name($sessionName);

        $use_cookies = (boolean) ini_get('session.use_cookies');        

        /**
         * cookieDefaults=Array
         * (
         *    [lifetime] => 0
         *    [path] => /
         *    [domain] => 
         *    [secure] => 
         *    [httponly] => 
         * )
         */
        $cookieDefaults = session_get_cookie_params();
        $lifetime = 0;
        $path     = '/';
        $domain   = NULL;
        $secure   = NULL;
        $httpOnly = NULL;
        if (version_compare(phpversion(), '5.2', '>='))
        {
            session_set_cookie_params($lifetime, $path, $domain, $secure, $httpOnly);
        }
        else
        {
            session_set_cookie_params($lifetime, $path, $domain, $secure);
        }       
        
        session_start();        
    }
    
    /**
     * Read data from current session.
     */
    public function & read($key)
    {
       $retval = null;

       if (isset($_SESSION[$key]))
       {
         $retval =& $_SESSION[$key];
       }

       return $retval;
    }
    
    /**
     * Writes data to this storage.
     *
     * The preferred format for a key is directory style so naming conflicts can be avoided.
     *
     * @param string A unique key identifying your data
     * @param mixed  Data associated with your key
     *
     */
    public function write($key, &$data)
    {
      $_SESSION[$key] =& $data;
    }
    
    /**
     * Close current session
     */
    static public function close()
    {
        session_write_close();
    }
}

/**
 * Get data from session. The fastest method.
 *
 * @param string $key
 * @return mixed || null
 */
function fc_get_session_storage($key)
{
    $fc_context   = fcContext::getInstance();
    $fc_user      = $fc_context->getUser();
    $value        = $fc_user->getAttribute($key);    
    $lang         = fc_get_language();
    
    if (! empty($value)) return $value;
    else
    {
        $path=SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'default'.DIRECTORY_SEPARATOR.$lang;
        $file=$path.DIRECTORY_SEPARATOR.$key.'.html';
        if (file_exists($file)) return file_get_contents($file);
        return null;
    }
}

/**
 * Get languege for FC
 */
function fc_get_language()
{
    // get currenct language
    $fcsession = fcSessionStorage::getInstance();
    $lang = $fcsession->read("fastcache_lang");
    $languages_db=SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'languages.db';
    if (file_exists($languages_db))
    {
        $raw_data=file_get_contents($languages_db);
        $data=unserialize($raw_data);      
    } else return null;
    
    if (empty($lang)) return $data['default'];
    else return $lang;
}