<?php
/**
 * Fast Cache helpers. Part of the index.php in standard mode or fast cache saving mode.
 * These functions are defined and called before symfony class including. Write code in plain php!
 * 
 * This helpers are not available in fast cache mode.
 * @author      Marek Jakubowicz <marek.jakubowicz@sote.pl>
 */
 
/**
 * Param verification.
 * Param are privided by GET or by URI.
 *
 * @param string $required_param required param
 * @param string $required_value required value
 * @return true if $required_param = $required_value, false if not
 */
function st_param_verification($required_param,$required_value)
{    
    $value=NULL;
    
    if (! empty($_GET[$required_param]))
    {
        $value=$_GET[$required_param];
    } else
    {
        $request_uri=$_SERVER['REQUEST_URI'];     
        $dat=split('/',$request_uri);
        if (! empty($dat))
        {
            $size=sizeof($dat);
            for($i=0;$i<$size;$i++)
            {
                if ($dat[$i]==$required_param)
                {
                    if (! empty($dat[$i+1])) 
                    {
                        // hash code in URI is ok
                        $value=$dat[$i+1];
                    } 
                }    
            }
        }
    }
    if ($value==NULL) return false;
    if ($value==$required_value)
    {
        return true;
    } else {
        return false;
    }
}

/**
 * Hash verification. 
 * Check hash. If hash is correct means that cache can be generated.
 * 
 * @return bool, true - script is executed with FC, false - FC is disabled for current request
 */
function st_hash_verification()
{
	if (! defined('FASTCACHE_URI')) define ('FASTCACHE_URI','index.php');
	$request_uri=str_replace("/".FASTCACHE_URI."/",'',$_SERVER['REQUEST_URI']); 
    if (strpos($request_uri,'?')!==false) $request_uri = substr($request_uri,0,strpos($request_uri,'?'));
    
    if (empty($request_uri)) $request_uri='/';
        
    return st_param_verification('hash',md5($request_uri));
}

/**
 * Default mode verification
 * @return true - hash verification ok, and default=1 
 */
function st_default_verification()
{	
	if (! defined('FASTCACHE_URI')) define ('FASTCACHE_URI','index.php');
	$request_uri=str_replace("/".FASTCACHE_URI."/",'',$_SERVER['REQUEST_URI']); 
    if (strpos($request_uri,'?')!==false) $request_uri = substr($request_uri,0,strpos($request_uri,'?'));
    
    if (empty($request_uri)) $request_uri='/';
    
    if (st_param_verification('hash',md5($request_uri))) 
    {
        return st_param_verification('default',1);
    } else return false;
}


/**
 * Get data for current languages
 * Get data from cache/functions/shared/stLanguagePlugin
 * @return array
 */
function st_get_all_languages()
{
    $language_db=SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'languages.db';
    if (file_exists($language_db))
    {
       $languages=unserialize(file_get_contents($language_db));
       return $languages;
    } else
    {
        // there are no language data, critical error, disable FC for this session & continue work in symfony mode
        fcActivation::disable();
        return array();
    }
}

/**
 * 1. Check if language_current has any domain in configuration. 
 * 2. Yes, do nothing
 * 3. No, Add language uri /lang/en etc.
 * 
 * @param array  $languages unserialized data fastcche/db/language.db
 * @param string $language_current current language culture: pl_PL, en_US, ...
 * @param string $request_uri current uri
 * @return string modified uri
 */
function st_change_language_uri($languages, $language_current, $request_uri)
{
    if ((empty($language_current)) || (empty($languages['languages'][$language_current])))
    {
        return $request_uri;
    } 
    
    // echo "<pre>";
    // print_r($languages);
    // echo "language_current=$language_current \n";
    // echo "request_uri=$request_uri \n";
    // echo "</pre>";

    if ($languages['default']!=$language_current)
    {
        $host=$_SERVER['HTTP_HOST'];
        if (eregi("^www.",$host)) $host=str_replace("www.",'',$host);
    
        if (! empty($languages['domains'][$language_current])) 
        {
            foreach ($languages['domains'][$language_current] as $id=>$domain)
            {
                if (strtolower($domain)==strtolower($host))
                {
                    // 2. goto end                    
                    return $request_uri;
                }
            }        
        } 
        
        // 3. change request_uri, there is no domain for this language
        if ($request_uri=='/index.html') $request_uri='';
        return $request_uri.'/lang/'.$languages['languages'][$language_current];                
        
    }

    // langauge was not changed
    return $request_uri;
}

