<?php
/**
 * Wywołanie frontend w trybie produkcyjnym.
 * 
 * @package   stFrontend
 * @author    Marek Jakubowicz <marek.jakubowicz@sote.pl>
 * @copyright SOTE
 * @license   SOTE
 * @version   SVN: $Id: index.php 10025 2010-12-28 10:14:43Z marek $
 */
 
// start time calc
$mtime = microtime(); $mtime = explode(" ",$mtime); $mtime = $mtime[1] + $mtime[0]; $starttime = $mtime; 


/**
 * Ładownienie pliku profile z ST_ROOT_DIR
 */
if (file_exists('.profile.php'))
{
    include_once('.profile.php');
}
/**
 * Scieżka do katalogu głównego instalacji.
 */
if (defined('ST_ROOT_DIR'))
{
    define('SF_ROOT_DIR',    realpath(dirname(__FILE__).ST_ROOT_DIR));
} else {
    define('SF_ROOT_DIR',    realpath(dirname(__FILE__).'/..'));
}


// show fast cache debug results
if (file_exists(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'db'.DIRECTORY_SEPARATOR.'generation_time_enabled'))
{
    define ("ST_TIME_DEBUG",1);
}

    
/**
* Fast cache
*/
$fastcache_include=SF_ROOT_DIR.DIRECTORY_SEPARATOR."fastcache".DIRECTORY_SEPARATOR."lib".DIRECTORY_SEPARATOR."fastcache.php";
if (file_exists($fastcache_include)) include($fastcache_include);
// end fastcache

/**
 * Definicja aplikacji Symfony.
 */
define('SF_APP',         'frontend');        

/**
 * Tryb uruchomienia [dev|prod|test]
 */
define('SF_ENVIRONMENT', 'prod');  

/**
 * Tryb raportowania błędów.
 */
define('SF_DEBUG',       false);
      
/**
 * Sprawdzanie czy jest włączna blokada sklepu
 */
include(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.'stLockPlugin'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'stLock.class.php');
if(!stLock::check())
{
    include SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'errors'.DIRECTORY_SEPARATOR.'unavailable.php';
    exit();
}

/**
 * Odczytuje konfigurację Symfony.
 */
require_once(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'config.php');

sfContext::getInstance()->getController()->dispatch();

include (SF_ROOT_DIR.DIRECTORY_SEPARATOR."fastcache".DIRECTORY_SEPARATOR."lib".DIRECTORY_SEPARATOR."fcTimer.php");