<?php

/**
 * SOTESHOP/stBase
 *
 * Ten plik należy do aplikacji stBase opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stBase
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stFunctionCache.class.php 7 2009-08-24 08:59:30Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 * @author      Piotr Halas <piotr.halas@sote.pl>
 */

/**
 * Klasa stFunctionCache2
 *
 * @package     stBase
 * @subpackage  libs
 */
class stFunctionCache extends sfFileCache
{

   protected $moduleName = null;
   protected $cacheFormat = 'serialized';
   protected $cacheApp = null;
   protected $cacheEnv = null;

   /**
    * Konstruktor
    *
    * @param string $moduleName the module name
    * @param string $app The application name
    */
   public function __construct($moduleName = null, $app = 'shared')
   {
      $this->moduleName = $moduleName;
      $this->cacheApp = $app;
      $this->cacheEnv = SF_ENVIRONMENT;

      $cacheDir = $this->generateCacheDir($moduleName, $app);

      parent::__construct($cacheDir);
   }

   /**
    *
    * Sets the cache format
    *
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    * @param const $format Cache format (Default: 'serialized')
    */
   public function setCacheFormat($format = 'serialized')
   {
      $this->cacheFormat = $format;
   }

   /**
    *
    * Calls a cacheable function or method
    * Examples:
    * $fc->cacheCall(array('Product', 'doSelect'), array(new Criteria()));
    * $fc->cacheCall('Product::doSelect', array(new Criteria()));
    *
    * @author Marcin Butlak <marcin.butlak@sote.pl>
    * @param mixed $callable Function or Method name
    * @param array $arguments Arguments
    * @return mixed The result of the function/method call
    */
   public function cacheCall($callback, $arguments, $options = array())
   {
      if (!isset($options['id']))
      {
         $id = is_array($callback) ? implode('-', $callback).md5(serialize($arguments)) : strtr($callback, ':', '_').md5(serialize($arguments));
      }
      else
      {
         $id = $options['id'];
      }

      $namespace = isset($options['namespace']) ? $options['namespace'] : null;

      $data = $this->get($id, $namespace);

      if ($data !== null)
      {
         return $this->cacheFormat == 'serialized' ? unserialize($data) : $data;
      }

      $result = call_user_func_array($callback, $arguments);

      $this->set($id, $namespace, $this->cacheFormat == 'serialized' ? serialize($result) : $result);

      return $result;
   }

   /**
    *
    * Generates path to cache directory
    *
    * @param string $moduleName Module name
    * @param string $app The application name
    * @return string Cache path
    */
   protected function generateCacheDir($moduleName = null, $app = null, $env = null)
   {
      if (null === $moduleName)
      {
         $moduleName = 'shared';
      }

      if (null === $app)
      {
         $app = $this->cacheApp;
      }

      if (null === $env)
      {
         $env = $this->cacheEnv;
      }

      return sfConfig::get('sf_root_cache_dir').DIRECTORY_SEPARATOR.'functions'.DIRECTORY_SEPARATOR.$app.DIRECTORY_SEPARATOR.$env.DIRECTORY_SEPARATOR.$moduleName;
   }

   /**
    *
    * Removes a cache file
    *
    * @param string $id The cache id
    * @param string $namespace The name of the cache namespace
    * @param string $app The application name
    */
   public function removeById($id, $namespace = null, $app = null)
   {
      $this->removeIdCache($id, $namespace, $app, 'dev');

      $this->removeIdCache($id, $namespace, $app, 'prod');

      $this->removeIdCache($id, $namespace, $app, 'edit');
      
      $this->removeIdCache($id, $namespace, $app, 'theme');
   }

   /**
    *
    * Removes cache files by namespace
    *
    * If no namespace is specified all cache files will be destroyed
    * else only cache files of the specified namespace will be destroyed.
    *
    * @param string $namespace  The name of the cache namespace
    * @param string $app The application name
    */
   public function removeByNamespace($namespace = null, $app = null)
   {
      $this->removeNamespaceCache($namespace, $app, 'dev');

      $this->removeNamespaceCache($namespace, $app, 'prod');

      $this->removeNamespaceCache($namespace, $app, 'edit');
      
      $this->removeNamespaceCache($namespace, $app, 'theme');
   }

   /**
    * Removes all cache files
    *
    * @param string $app The application name
    */
   public function removeAll($app = null)
   {
      $this->removeByNamespace(null, $app);
   }

   /**
    *
    * This function is deprecated. Please use stFunctionCache::removeById instead.
    *
    */
   public function clearFunction($id)
   {
      $this->removeById($id);
   }

   /**
    *
    * This function is deprecated. Please use stFunctionCache::removeById instead.
    *
    */
   public function cleanBy($app, $namespace)
   {
      $this->clean($namespace);
   }

   /**
    *
    * This function is deprecated. Please use stFunctionCache::cacheCall instead.
    *
    */
   public function add($id, $callback)
   {
      $arguments = func_get_args();

      unset($arguments[0]);

      unset($arguments[1]);

      return $this->cacheCall($callback, $arguments, array('id' => $id));
   }

   /**
    *
    * This function is deprecated. Please use stFunctionCache::cacheCall instead.
    *
    */
   public function callBy($namespace, $callback)
   {
      $arguments = func_get_args();

      unset($arguments[0]);

      unset($arguments[1]);

      return $this->cacheCall($callback, $arguments, array('namespace' => $namespace));
   }

   /**
    *
    * This function is deprecated. Please use stFunctionCache::removeAll instead.
    *
    */
   public static function clearFrontendModule($moduleName = '', $route = '')
   {
      $fc = new self($moduleName);

      $fc->removeAll();
   }

   protected function removeNamespaceCache($namespace = null, $app = null, $env = null)
   {
      $cacheDir = $this->getCacheDir();

      $this->setCacheDir($this->generateCacheDir($this->moduleName, $app, $env));

      $this->clean($namespace);

      $this->setCacheDir($cacheDir);
   }

   protected function removeIdCache($id, $namespace = null, $app = null, $env = null)
   {
      $cacheDir = $this->getCacheDir();

      $this->setCacheDir($this->generateCacheDir($this->moduleName, $app, $env));

      $this->remove($id, $namespace);

      $this->setCacheDir($cacheDir);
   }

}

