<?php

class stPartialCache
{

   protected static
   $instance = array();
   protected
   $response,
   $theme,
   $cache,
   $cacheConfig = array(),
   $cacheEnabled;

   public static function getInstance(sfContext $context, $application = null, $cache_class = 'sfFileCache', $singleton_class = __CLASS__)
   {
      if (null === $application)
      {
         $application = SF_APP;
      }

      $index = $application.$cache_class;

      if (!isset(self::$instance[$index]))
      {
         self::$instance[$index] = new $singleton_class();

         self::$instance[$index]->initialize($context, $application, $cache_class);
      }

      return self::$instance[$index];
   }

   public function initialize($context, $application, $cache_class)
   {
      $cache_root_dir = sfConfig::get('sf_root_cache_dir').DIRECTORY_SEPARATOR.$application.DIRECTORY_SEPARATOR.SF_ENVIRONMENT.DIRECTORY_SEPARATOR.'template';

      $this->appModuleDir = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.sfConfig::get('sf_apps_dir_name').DIRECTORY_SEPARATOR.$application.DIRECTORY_SEPARATOR.'modules';

      $this->cache = new $cache_class($cache_root_dir);

      $this->cacheEnabled = sfConfig::get('sf_cache');

      $this->response = $context->getResponse();

      if (SF_APP == 'frontend')
      {
         $this->theme = stTheme::getInstance($context);
      }
   }

   public function initializeFor($moduleName)
   {
      $this->moduleName = $moduleName;

      if (isset($this->cacheConfig[$moduleName]))
      {
         return;
      }

      $config_path = null;

      if (!is_readable($this->appModuleDir.DIRECTORY_SEPARATOR.$moduleName.DIRECTORY_SEPARATOR.sfConfig::get('sf_app_module_config_dir_name').DIRECTORY_SEPARATOR.'cache.yml'))
      {
         $modulePaths = sfLoader::getPluginModulePaths();

         if (isset($modulePaths[$moduleName]) && is_readable($modulePaths[$moduleName].DIRECTORY_SEPARATOR.sfConfig::get('sf_app_module_config_dir_name').DIRECTORY_SEPARATOR.'cache.yml'))
         {
            $config_path = $modulePaths[$moduleName].DIRECTORY_SEPARATOR.sfConfig::get('sf_app_module_config_dir_name').DIRECTORY_SEPARATOR.'cache.yml';
         }
      }
      else
      {
         $config_path = $this->appModuleDir.DIRECTORY_SEPARATOR.$moduleName.DIRECTORY_SEPARATOR.sfConfig::get('sf_app_module_config_dir_name').DIRECTORY_SEPARATOR.'cache.yml';
      }

      if ($config_path)
      {
         require(sfConfigCache::getInstance()->checkConfig($config_path));
      }
      else
      {
         $this->addCache($moduleName, 'DEFAULT', array('enabled' => false));
      }
   }

   public function isCacheable($moduleName, $actionName)
   {
      if (false === $this->cacheEnabled)
      {
         return false;
      }

      $this->initializeFor($moduleName);

      return isset($this->cacheConfig[$moduleName][$actionName]) && $this->cacheConfig[$moduleName][$actionName]['enabled'];
   }

   public function get($moduleName, $actionName, $id, $culture = null)
   {
      $ret = $this->cache->get($id, $this->generateNamespace($moduleName, $actionName, $culture));

      if (null !== $ret)
      {
         $view = $this->cacheConfig[$moduleName][$actionName]['view'];

         foreach ($view['javascripts'] as $javascript)
         {
            $this->response->addJavascript($javascript['filename'], $javascript['position']);
         }

         foreach ($view['stylesheets'] as $stylesheet)
         {
            if ($this->theme)
            {
               $this->theme->addStylesheet($stylesheet['filename'], $stylesheet['position']);
            }
            else
            {
               $this->response->addStylesheet($stylesheet['filename'], $stylesheet['position']);
            }
         }
      }

      return $ret;
   }

   public function set($moduleName, $actionName, $id, $data, $culture = null)
   {
      $this->cache->set($id, $this->generateNamespace($moduleName, $actionName, $culture), $data);
   }

   public function clean($moduleName, $actionName, $culture = null, $id = null)
   {
      $namespace = $this->generateNamespace($moduleName, $actionName, $culture);

      if (null === $id)
      {
         $this->cache->clean($namespace);
      }
      else
      {
         $this->cache->remove($id, $namespace);
      }
   }

   protected function generateNamespace($moduleName, $actionName, $culture = null)
   {
      return $moduleName.DIRECTORY_SEPARATOR.$actionName.($culture ? DIRECTORY_SEPARATOR.$culture : '');
   }

   public static function generateIdFromArray($params = array())
   {
      return md5(serialize($params));
   }

   /**
    * Adds a cache to the manager.
    *
    * @param string Module name
    * @param string Action name
    * @param array Options for the cache
    */
   protected function addCache($moduleName, $actionName, $options = array())
   {
      if (!isset($this->cacheConfig[$moduleName]))
      {
         $this->cacheConfig[$moduleName] = array();
      }

      $this->cacheConfig[$moduleName][$actionName] = $options;
   }

   protected function setCacheDir($value)
   {
      if ($this->cache->getCacheDir() != $this->cacheRootDir.DIRECTORY_SEPARATOR.$this->moduleName)
      {
         $this->cache->setCacheDir($this->cacheRootDir.DIRECTORY_SEPARATOR.$this->moduleName);
      }
   }

}