<?php

/**
 * Klasa scalajaca wszystkie pliki config/config.php
 *
 * @package    stSymfonyUpdate
 * @subpackage libs
 * @author     Marcin Butlak
 * @version    SVN: $Id: stConfigCompileConfigHandler.class.php 1666 2009-06-10 14:41:07Z marcin $
 */
class stConfigCompileConfigHandler extends sfYamlConfigHandler
{
    public function execute($configFiles)
    {
        // parse the yaml
        $config = array();

        $content = '';

        foreach ($configFiles as $configFile)
        {
            $config = array_merge_recursive($config, $this->parseYaml($configFile));
        }

        foreach ($config['search_paths'] as $config_path)
        {
            $paths = glob($this->getPath($config_path));

            foreach ($paths as $path)
            {
                $content .= $this->compilePhp($path) . "\n";
            }
        }

        return "<?php \$timer = sfTimerManager::getTimer('Plugin configuration');\n\$dispatcher = stEventDispatcher::getInstance();\n" . $content . "\n\$timer->addTime(); ?>";
    }
    /**
     *
     * Zamienia sciezke relatywna na absolutna
     *
     * @param string $path Sciezka relatywna
     * @return string Sciezka absolutna
     */
    protected function getPath($path)
    {
        return sfConfig::get('sf_root_dir') . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, trim($path, '/'));
    }

    /**
     *
     * Minimalizuje skrypt php
     *
     * @param string $filename Sciezka do skryptu php
     * @return string Zminimalizowany skrypt php
     */
    protected function compilePhp($filename)
    {
        $content = str_replace("\r\n", "\n", php_strip_whitespace($filename));

        $content = str_replace('stEventDispatcher::getInstance()->', '$dispatcher->', $content);

        $content = str_replace('$dispatcher = stEventDispatcher::getInstance();', '', $content);

        return substr(rtrim($content, "?>\n"), 5);
    }
}

?>
