<?php
/**
 * SOTESHOP/stLanguagePlugin
 *
 * Ten plik należy do aplikacji stLanguagePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stLanguagePlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stLanguageFilter.class.php 16153 2011-11-17 09:39:02Z michal $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa stLanguageFilter
 *
 * @package     stLanguagePlugin
 * @subpackage  libs
 */
class stLanguageFilter extends sfFilter
{
	/**
	 * Wykonywanie filtra
	 *
	 * @param $filterChain
	 */
	public function execute($filterChain)
	{
		if ($this->isFirstCall())
		{
			$stWebRequest = new stWebRequest();
			$context = $this->getContext();
			$stCache = new stFunctionCache('stLanguagePlugin');
			$changedLanguage = false;
			$changedLanguageFor = "";

			$c = new Criteria();
			$c->add(LanguageHasDomainPeer::DOMAIN, $stWebRequest->getHost());
			$language = $stCache->add('languageByDomain'.$stWebRequest->getHost(), "LanguageHasDomainPeer::doSelectJoinLanguage", $c);

			if (!$context->getUser()->hasAttribute('lang', stLanguage::SESSION_NAMESPACE))
			{
				if (isset($_SESSION['fastcache_lang'])) $sessionFastCacheLang = $_SESSION['fastcache_lang'];

				if (isset($language[0]) && is_object($language[0]))
				{
					$stLanguage = stLanguage::getInstance($context);
					stLanguage::changeLanguageByShortcut($language[0]->getLanguage()->getShortcut());
					$context->getUser()->setAttribute('lang', $language[0]->getLanguage()->getShortcut(), stLanguage::SESSION_NAMESPACE);
					$changedLanguage = true;
					$changedLanguageFor = $language[0]->getLanguage()->getShortcut();
				}
			}

			if ($context->getRequest()->hasParameter('lang'))
			{
				$lang = $context->getRequest()->getParameter('lang');
				$changed = stLanguage::changeLanguageByShortcut($lang);
				if ($changed == false) throw new sfError404Exception();
				$context->getUser()->setAttribute('lang', $lang, stLanguage::SESSION_NAMESPACE);
				$changedLanguage = true;
				$changedLanguageFor = $lang;
			}

			if ($context->getRequest()->hasParameter('lang') && isset($language[0]) && is_object($language[0]))
			{
				if ($context->getRequest()->getParameter('lang') == $language[0]->getLanguage()->getShortcut())
				{
					sfLoader::loadHelpers(array('Helper','stUrl'));
					$r = sfRouting::getInstance();
					list(,$redirect) = $context->getController()->convertUrlStringToParameters($r->getCurrentInternalUri());
					unset($redirect['lang']);
					$context->getController()->redirect(st_url_for($redirect, true, null, $language[0]->getDomain()), 0, 301);
					exit();
				}
			}

			if (!$context->getRequest()->isXmlHttpRequest() && $context->getRequest()->getMethod() != sfRequest::POST)
			{
				//nie zapisuj sciezki do wywolan fast cache
				if ($context->getModuleName() != 'stFastCacheFrontend') stLanguage::getInstance($context)->setPath(sfRouting::getInstance()->getCurrentInternalUri());
			} elseif (!$context->getRequest()->isXmlHttpRequest() && $context->getRequest()->getMethod() == sfRequest::POST) {
				stLanguage::getInstance($context)->setPath('stFrontendMain/index');
			}

			if ($changedLanguage == true && $context->getUser()->isAuthenticated())
			{
				$language = LanguagePeer::retrieveByShortcut($changedLanguageFor);
				if (is_object($language))
				{
					$user = $context->getUser()->getGuardUser();
					$user->setLanguage($language->getOriginalLanguage());
					$user->save();
				}
			}

			/**
			 * Zmiana waluty w zależności od wybranego języka
			 */
			if ($context->getUser()->getAttribute('currencyLanguage', null) != null)
			{
				if ($context->getUser()->getCulture() != $context->getUser()->getAttribute('currencyLanguage'))
				{
					$this->changeCurrency($context);
				}
			} else {
				$this->changeCurrency($context);
			}

			/**
			 * Zmiana języka dla FastCache
			 */
			if (isset($_SESSION['fastcache_lang']))
			{
				if (isset($sessionFastCacheLang)) $_SESSION['fastcache_lang'] = $sessionFastCacheLang;

				if ($context->getUser()->getCulture() != $_SESSION['fastcache_lang'])
				{
					$context->getUser()->setCulture($_SESSION['fastcache_lang']);
					stLanguage::getInstance($context)->setLanguageChangedFlag(true);
				}
			}
		}
		$filterChain->execute();
	}

	/**
	 * Zmiana waluty
	 *
	 * @param sfContext $context
	 */
	private function changeCurrency($context)
	{
		$context->getUser()->setAttribute('currencyLanguage', $context->getUser()->getCulture());

		$c = new Criteria();
		$c->add(LanguagePeer::LANGUAGE, $context->getUser()->getCulture());
		$language = LanguagePeer::doSelectOne($c);

		$stCurrency = stCurrency::getInstance($context);

		if ($language->getCurrencyId() == 0)
		{
			$stCurrency->set($stCurrency->getMainCurrency()->getId());
		} else {
			$stCurrency->set($language->getCurrencyId());
		}
		stCacheManager::remove('sf_cache_partial/stCurrencyFrontend/_pickCurrency/*');
	}
}