<?php
use_helper('Javascript');

$response = sfContext::getInstance()->getResponse();

$response->addJavascript('/js/tiny_mce/plugins/tinybrowser/tb_tinymce.js.php');

/*
 * This file is part of the symfony package.
 * (c) 2004-2006 Fabien Potencier <fabien.potencier@symfony-project.com>
 * 
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * sfRichTextEditorTinyMCE implements the TinyMCE rich text editor.
 *
 * <b>Options:</b>
 *  - css - Path to the TinyMCE editor stylesheet
 *
 *    <b>Css example:</b>
 *    <code>
 *    / * user: foo * / => without spaces. 'foo' is the name in the select box
 *    .foobar
 *    {
 *      color: #f00;
 *    }
 *    </code>
 *
 * @package    symfony
 * @subpackage helper
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: sfRichTextEditorTinyMCE.class.php 904 2009-04-29 13:08:36Z bartek $
 */
class sfRichTextEditorTinyMCE extends sfRichTextEditor
{
  /**
   * Returns the rich text editor as HTML.
   *
   * @return string Rich text editor HTML representation
   */
  public function toHTML()
  {   
    $options = $this->options;

    // we need to know the id for things the rich text editor
    // in advance of building the tag
    $id = _get_option($options, 'id', get_id_from_name($this->name, null));

    // use tinymce's gzipped js?
    $tinymce_file = _get_option($options, 'tinymce_gzip') ? '/tiny_mce_gzip.php' : '/tiny_mce.js';
    

    // tinymce installed?
    $js_path = sfConfig::get('sf_rich_text_js_dir') ? '/'.sfConfig::get('sf_rich_text_js_dir').$tinymce_file : '/sf/tinymce/js'.$tinymce_file;
    if (!is_readable(sfConfig::get('sf_web_dir').$js_path))
    {
      throw new sfConfigurationException('You must install TinyMCE to use this helper (see rich_text_js_dir settings).');
    }

    sfContext::getInstance()->getResponse()->addJavascript($js_path . '?version=3-2-7');

    $tinymce_options = '';
    $style_selector  = '';

    // custom CSS file?
    if ($css_file = _get_option($options, 'css'))
    {
      $css_path = stylesheet_path($css_file);

      sfContext::getInstance()->getResponse()->addStylesheet($css_path);

      $css    = file_get_contents(sfConfig::get('sf_web_dir').DIRECTORY_SEPARATOR.$css_path);
      $styles = array();
      preg_match_all('#^/\*\s*user:\s*(.+?)\s*\*/\s*\015?\012\s*\.([^\s]+)#Smi', $css, $matches, PREG_SET_ORDER);
      foreach ($matches as $match)
      {
        $styles[] = $match[1].'='.$match[2];
      }

      $tinymce_options .= '  content_css: "'.$css_path.'",'."\n";
      $tinymce_options .= '  theme_advanced_styles: "'.implode(';', $styles).'"'."\n";
      $style_selector   = 'styleselect,separator,';
    }

    $culture = sfContext::getInstance()->getUser()->getCulture();


    $tinymce_js = "
    

    tinyMCE.init({
      mode: 'exact',
      language: '".strtolower(substr($culture, 0, 2))."',
      elements: '".$id."',
      plugins : 'autolink,lists,spellchecker,pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template',
      theme: 'advanced',
      force_p_newlines: false,
      remove_trailing_nbsp: true,  
      theme_advanced_toolbar_location: 'top',
      theme_advanced_toolbar_align: 'left',
      theme_advanced_path_location: 'bottom',
      theme_advanced_buttons1:'bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,bullist,numlist,|,link,unlink,|,image,media,|,formatselect,forecolor,|,copy,paste,|,undo,redo,|,fullscreen',
      theme_advanced_buttons2:'',
      theme_advanced_buttons3:'',

      fullscreen_settings: {
      theme_advanced_buttons1 : 'fullscreen,|,save,newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,bullist,numlist,|,outdent,indent,|,sub,sup,blockquote,|,cut,copy,paste,pastetext,pasteword,|,undo,redo',
      theme_advanced_buttons2 : 'formatselect,fontselect,fontsizeselect,|,forecolor,backcolor,|,link,unlink,anchor,image,media,charmap,emotions,iespell,|,styleprops,cleanup,removeformat,code',
      theme_advanced_buttons3 : 'tablecontrols,|,insertlayer,moveforward,movebackward,absolute,|,spellchecker,|,search,replace,|,print',
      theme_advanced_buttons4 : '',
      },

      extended_valid_elements: '*',
      file_browser_callback : 'tinyBrowser',
      theme_advanced_blockformats : 'p,h1,h2,h3,h4,h5,h6,blockquote',
      theme_advanced_path : false,
      forced_root_block : false, 
      convert_urls : false,
      skin : 'o2k7',
      theme_advanced_resizing : true,
      theme_advanced_resize_horizontal : false,
      debug: false
  
  
  ".($tinymce_options ? ','.$tinymce_options : '')."
  ".(isset($options['tinymce_options']) ? ','.$options['tinymce_options'] : '').'

});';

    if (isset($options['tinymce_options']))
    {
      unset($options['tinymce_options']);
    }

    return
      content_tag('script', javascript_cdata_section($tinymce_js), array('type' => 'text/javascript')).
      content_tag('div', '<a style="text-decoration:none;" onclick="tinymce.execCommand(\'mceToggleEditor\',false,\''.$id.'\');" href="javascript:;" class="btn"><span style>HTML / '.__('Wizualny', null, 'stTinyMCEPlugin').'</span></a>').
      content_tag('textarea', $this->content, array_merge(array('name' => $this->name, 'id' => $id), _convert_options($options)));
  }
}
